/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.AdvancementHelper;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.advancements.criterion.CriterionTriggerImpossible;
import net.minecraft.core.ClientAsset;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AdvancementHelperImpl
extends AdvancementHelper {
    private static final String IMPOSSIBLE_KEY = "impossible";
    private static final Map<String, Criterion<?>> IMPOSSIBLE_CRITERIA = Map.of("impossible", new Criterion((CriterionTrigger)new CriterionTriggerImpossible(), (CriterionInstance)new CriterionTriggerImpossible.a()));
    private static final List<List<String>> IMPOSSIBLE_REQUIREMENTS = List.of(List.of("impossible"));

    public static AdvancementDataWorld getNMSAdvancementManager() {
        return ((CraftServer)Bukkit.getServer()).getServer().aB();
    }

    @Override
    public void register(com.denizenscript.denizen.nms.util.Advancement advancement) {
        AdvancementNode root;
        if (advancement.temporary || advancement.registered) {
            return;
        }
        AdvancementHolder nmsAdvancementHolder = AdvancementHelperImpl.asNMSCopy(advancement);
        Map nmsAdvancements = AdvancementHelperImpl.getNMSAdvancementManager().b;
        ImmutableMap.Builder mapBuilder = ImmutableMap.builderWithExpectedSize((int)(nmsAdvancements.size() + 1));
        mapBuilder.putAll(nmsAdvancements);
        mapBuilder.put((Object)nmsAdvancementHolder.a(), (Object)nmsAdvancementHolder);
        AdvancementHelperImpl.getNMSAdvancementManager().b = mapBuilder.build();
        AdvancementTree tree = AdvancementHelperImpl.getNMSAdvancementManager().a();
        tree.a(List.of(nmsAdvancementHolder));
        AdvancementNode node = tree.a(nmsAdvancementHolder.a());
        if (node != null && (root = node.d()).b().b().c().isPresent()) {
            TreeNodePosition.a((AdvancementNode)root);
        }
        advancement.registered = true;
        if (!advancement.hidden && advancement.parent != null) {
            PacketHelperImpl.broadcast(new PacketPlayOutAdvancements(false, List.of(nmsAdvancementHolder), Set.of(), Map.of(), false));
        }
    }

    @Override
    public void unregister(com.denizenscript.denizen.nms.util.Advancement advancement) {
        if (advancement.temporary || !advancement.registered) {
            return;
        }
        MinecraftKey nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)advancement.key);
        Map nmsAdvancements = AdvancementHelperImpl.getNMSAdvancementManager().b;
        ImmutableMap.Builder mapBuilder = ImmutableMap.builderWithExpectedSize((int)(nmsAdvancements.size() - 1));
        for (Map.Entry entry : nmsAdvancements.entrySet()) {
            if (((MinecraftKey)entry.getKey()).equals((Object)nmsKey)) continue;
            mapBuilder.put(entry);
        }
        AdvancementHelperImpl.getNMSAdvancementManager().b = mapBuilder.build();
        AdvancementHelperImpl.getNMSAdvancementManager().a().a(Set.of(nmsKey));
        advancement.registered = false;
        PacketHelperImpl.broadcast(new PacketPlayOutAdvancements(false, List.of(), Set.of(nmsKey), Map.of(), false));
    }

    @Override
    public void grantPartial(com.denizenscript.denizen.nms.util.Advancement advancement, Player player, int len) {
        if (advancement.length <= 1) {
            this.grant(advancement, player);
            return;
        }
        if (advancement.temporary) {
            AdvancementHolder nmsAdvancement = AdvancementHelperImpl.asNMSCopy(advancement);
            AdvancementProgress progress = new AdvancementProgress();
            progress.a(new AdvancementRequirements(IMPOSSIBLE_REQUIREMENTS));
            for (int i = 0; i < len; ++i) {
                progress.a(IMPOSSIBLE_KEY + i);
            }
            PacketHelperImpl.send(player, new PacketPlayOutAdvancements(false, List.of(nmsAdvancement), Set.of(), Map.of(nmsAdvancement.a(), progress), false));
        } else {
            AdvancementHolder nmsAdvancement = (AdvancementHolder)AdvancementHelperImpl.getNMSAdvancementManager().b.get(CraftNamespacedKey.toMinecraft((NamespacedKey)advancement.key));
            for (int i = 0; i < len; ++i) {
                ((CraftPlayer)player).getHandle().U().a(nmsAdvancement, IMPOSSIBLE_KEY + i);
            }
        }
    }

    @Override
    public void grant(com.denizenscript.denizen.nms.util.Advancement advancement, Player player) {
        if (advancement.length > 1) {
            this.grantPartial(advancement, player, advancement.length);
            return;
        }
        if (advancement.temporary) {
            AdvancementHolder nmsAdvancement = AdvancementHelperImpl.asNMSCopy(advancement);
            AdvancementProgress progress = new AdvancementProgress();
            progress.a(new AdvancementRequirements(IMPOSSIBLE_REQUIREMENTS));
            progress.a(IMPOSSIBLE_KEY);
            PacketHelperImpl.send(player, new PacketPlayOutAdvancements(false, List.of(nmsAdvancement), Set.of(), Map.of(nmsAdvancement.a(), progress), true));
        } else {
            AdvancementHolder nmsAdvancement = (AdvancementHolder)AdvancementHelperImpl.getNMSAdvancementManager().b.get(CraftNamespacedKey.toMinecraft((NamespacedKey)advancement.key));
            ((CraftPlayer)player).getHandle().U().a(nmsAdvancement, IMPOSSIBLE_KEY);
        }
    }

    @Override
    public void revokePartial(com.denizenscript.denizen.nms.util.Advancement advancement, Player player, int len) {
        if (advancement.length <= 1) {
            this.revoke(advancement, player);
            return;
        }
        if (advancement.temporary) {
            AdvancementHolder nmsAdvancement = AdvancementHelperImpl.asNMSCopy(advancement);
            AdvancementProgress progress = new AdvancementProgress();
            progress.a(new AdvancementRequirements(IMPOSSIBLE_REQUIREMENTS));
            for (int i = 0; i < len; ++i) {
                progress.a(IMPOSSIBLE_KEY + i);
            }
            PacketHelperImpl.send(player, new PacketPlayOutAdvancements(false, List.of(nmsAdvancement), Set.of(), Map.of(nmsAdvancement.a(), progress), false));
        } else {
            AdvancementHolder nmsAdvancement = (AdvancementHolder)AdvancementHelperImpl.getNMSAdvancementManager().b.get(CraftNamespacedKey.toMinecraft((NamespacedKey)advancement.key));
            AdvancementDataPlayer advancements = ((CraftPlayer)player).getHandle().U();
            for (int i = len; i < advancement.length; ++i) {
                advancements.b(nmsAdvancement, IMPOSSIBLE_KEY + i);
            }
        }
    }

    @Override
    public void revoke(com.denizenscript.denizen.nms.util.Advancement advancement, Player player) {
        if (advancement.temporary) {
            PacketHelperImpl.send(player, new PacketPlayOutAdvancements(false, List.of(), Set.of(CraftNamespacedKey.toMinecraft((NamespacedKey)advancement.key)), Map.of(), false));
        } else {
            AdvancementHolder nmsAdvancement = (AdvancementHolder)AdvancementHelperImpl.getNMSAdvancementManager().b.get(CraftNamespacedKey.toMinecraft((NamespacedKey)advancement.key));
            AdvancementDataPlayer advancements = ((CraftPlayer)player).getHandle().U();
            for (String criterion : nmsAdvancement.b().e().keySet()) {
                advancements.b(nmsAdvancement, criterion);
            }
        }
    }

    @Override
    public void update(Player player) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        nmsPlayer.g.b((Packet)new PacketPlayOutAdvancements(true, List.of(), Set.of(), Map.of(), false));
        AdvancementDataPlayer data = nmsPlayer.U();
        data.b();
        data.a(AdvancementHelperImpl.getNMSAdvancementManager());
        data.a(nmsPlayer, false);
    }

    private static AdvancementHolder asNMSCopy(com.denizenscript.denizen.nms.util.Advancement advancement) {
        AdvancementHolder parent = advancement.parent != null ? (AdvancementHolder)AdvancementHelperImpl.getNMSAdvancementManager().b.get(CraftNamespacedKey.toMinecraft((NamespacedKey)advancement.parent)) : null;
        AdvancementDisplay display = new AdvancementDisplay(CraftItemStack.asNMSCopy((ItemStack)advancement.icon), Handler.componentToNMS(FormattedTextHelper.parse(advancement.title, ChatColor.WHITE)), Handler.componentToNMS(FormattedTextHelper.parse(advancement.description, ChatColor.WHITE)), Optional.ofNullable(advancement.background).map(CraftNamespacedKey::toMinecraft).map(ClientAsset.b::new), AdvancementFrameType.valueOf((String)advancement.frame.name()), advancement.toast, advancement.announceToChat, advancement.hidden);
        display.a(advancement.xOffset, advancement.yOffset);
        Map<String, Criterion<?>> criteria = IMPOSSIBLE_CRITERIA;
        List<List<String>> requirements = IMPOSSIBLE_REQUIREMENTS;
        if (advancement.length > 1) {
            criteria = new HashMap();
            requirements = new ArrayList<List<String>>(advancement.length);
            for (int i = 0; i < advancement.length; ++i) {
                criteria.put(IMPOSSIBLE_KEY + i, new Criterion((CriterionTrigger)new CriterionTriggerImpossible(), (CriterionInstance)new CriterionTriggerImpossible.a()));
                requirements.add(List.of(IMPOSSIBLE_KEY + i));
            }
        }
        AdvancementRequirements reqs = new AdvancementRequirements(requirements);
        Advancement adv = new Advancement(parent == null ? Optional.empty() : Optional.of(parent.a()), Optional.of(display), AdvancementRewards.b, criteria, reqs, false);
        return new AdvancementHolder(CraftNamespacedKey.toMinecraft((NamespacedKey)advancement.key), adv);
    }
}

