/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.CommandScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandScriptContainer
extends ScriptContainer {
    public boolean hasProcStyleTabComplete = false;
    public HashMap<Integer, String> tabCompletionTaggables;

    public CommandScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        CommandScriptHelper.init();
        CommandScriptHelper.commandScripts.put(this.getName(), this);
        if (this.containsScriptSection("tab complete")) {
            this.hasProcStyleTabComplete = true;
        }
        if (this.contains("tab completions", Map.class)) {
            this.tabCompletionTaggables = new HashMap();
            YamlConfiguration section = this.getConfigurationSection("tab completions");
            for (StringHolder key : section.getKeys(false)) {
                String val = section.getString(key.str);
                if (key.str.equals("default")) {
                    this.tabCompletionTaggables.put(-1, val);
                    continue;
                }
                try {
                    for (String num : key.str.split(" ")) {
                        this.tabCompletionTaggables.put(Integer.parseInt(num), val);
                    }
                }
                catch (NumberFormatException ex) {
                    Debug.echoError("Invalid tab completion argument number key '" + key.str + "'.");
                }
            }
        }
        this.handlePseudoTagBasesDeprecation("permission message", "<permission");
    }

    public String getCommandName() {
        String name = this.getString("name", null);
        if (name == null) {
            Debug.echoError("Command script '" + this.getName() + "' is missing required 'name' key!");
            return null;
        }
        return CoreUtilities.toLowerCase(name);
    }

    public String getDescription() {
        return this.getString("description", "", true).replace("\n", " \n");
    }

    public String getUsage() {
        return this.getString("usage", "", true);
    }

    public List<String> getAliases() {
        ArrayList aliases = this.getStringList("aliases", true);
        return aliases != null ? aliases : new ArrayList();
    }

    public String getPermission() {
        return this.getString("permission");
    }

    public String getPermissionMessage() {
        return this.getString("permission message");
    }

    public ScriptQueue runCommandScript(PlayerTag player, NPCTag npc, Map<String, ObjectTag> context) {
        InstantQueue queue = new InstantQueue(this.getName());
        queue.addEntries(this.getBaseEntries(new BukkitScriptEntryData(player, npc)));
        if (context != null) {
            ContextSource.SimpleMap src = new ContextSource.SimpleMap();
            src.contexts = context;
            queue.setContextSource(src);
        }
        queue.start();
        return queue;
    }

    public boolean runAllowedHelpProcedure(PlayerTag player, NPCTag npc, Map<String, ObjectTag> context) {
        List<ScriptEntry> entries = this.getEntries(new BukkitScriptEntryData(player, npc), "allowed help");
        InstantQueue queue = new InstantQueue(this.getName());
        queue.addEntries(entries);
        if (context != null) {
            ContextSource.SimpleMap src = new ContextSource.SimpleMap();
            src.contexts = context;
            queue.setContextSource(src);
        }
        queue.start();
        return queue.determinations != null && queue.determinations.size() > 0 && queue.determinations.get(0).equalsIgnoreCase("true");
    }

    public List<String> runTabCompleteProcedure(PlayerTag player, NPCTag npc, Map<String, ObjectTag> context, String[] originalArguments) {
        BukkitTagContext tagContext = new BukkitTagContext(player, npc, new ScriptTag(this));
        ContextSource.SimpleMap contextSrc = null;
        if (context != null) {
            ContextSource.SimpleMap src = new ContextSource.SimpleMap();
            src.contexts = context;
            tagContext.contextSource = src;
            contextSrc = src;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.tabCompletionTaggables != null) {
            int argCount = Math.max(originalArguments.length, 1);
            String taggable = this.tabCompletionTaggables.get(argCount);
            if (taggable == null) {
                taggable = this.tabCompletionTaggables.get(-1);
            }
            if (taggable != null) {
                String argLow = originalArguments.length == 0 ? "" : CoreUtilities.toLowerCase(originalArguments[originalArguments.length - 1]);
                for (String value : ListTag.getListFor(TagManager.tagObject(taggable, tagContext), tagContext)) {
                    if (!CoreUtilities.toLowerCase(value).startsWith(argLow)) continue;
                    list.add(value);
                }
            }
        }
        if (this.hasProcStyleTabComplete) {
            List<ScriptEntry> entries = this.getEntries(new BukkitScriptEntryData(player, npc), "tab complete");
            InstantQueue queue = new InstantQueue(this.getName());
            queue.addEntries(entries);
            if (contextSrc != null) {
                queue.setContextSource(contextSrc);
            }
            queue.start();
            if (queue.determinations != null && queue.determinations.size() > 0) {
                list.addAll(ListTag.getListFor(queue.determinations.getObject(0), tagContext));
            }
        }
        return list;
    }

    public boolean hasAllowedHelpProcedure() {
        return this.containsScriptSection("allowed help");
    }

    public boolean hasTabCompleteProcedure() {
        return this.hasProcStyleTabComplete || this.tabCompletionTaggables != null;
    }
}

