/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.ZombieNautilus;

public class EntityVariant
extends EntityProperty<ElementTag> {
    public static final MethodHandle COW_GET_VARIANT;
    public static final MethodHandle COW_SET_VARIANT;

    public static boolean describes(EntityTag entityTag) {
        Entity entity = entityTag.getBukkitEntity();
        return entity instanceof Wolf || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (entity instanceof Chicken || entity instanceof CopperGolem || entity instanceof Cow || entity instanceof Pig || entity instanceof ZombieNautilus);
    }

    @Override
    public ElementTag getPropertyValue() {
        Entity entity = this.getEntity();
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            return new ElementTag(Utilities.namespacedKeyToString(wolf.getVariant().getKey()), true);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
            Entity entity2 = this.getEntity();
            if (entity2 instanceof Chicken) {
                Chicken chicken = (Chicken)entity2;
                return new ElementTag(Utilities.namespacedKeyToString(chicken.getVariant().getKey()), true);
            }
            entity2 = this.getEntity();
            if (entity2 instanceof CopperGolem) {
                CopperGolem copperGolem = (CopperGolem)entity2;
                return new ElementTag(PaperAPITools.instance.getCopperGolemState(copperGolem), true);
            }
            if (COW_GET_VARIANT != null && (entity2 = this.getEntity()) instanceof Cow) {
                Cow cow = (Cow)entity2;
                try {
                    return new ElementTag(Utilities.namespacedKeyToString(COW_GET_VARIANT.invoke(cow).getKey()), true);
                }
                catch (Throwable e) {
                    Debug.echoError(e);
                    return null;
                }
            }
            entity2 = this.getEntity();
            if (entity2 instanceof Pig) {
                Pig pig = (Pig)entity2;
                return new ElementTag(Utilities.namespacedKeyToString(pig.getVariant().getKey()), true);
            }
            entity2 = this.getEntity();
            if (entity2 instanceof ZombieNautilus) {
                ZombieNautilus zombieNautilus = (ZombieNautilus)entity2;
                return new ElementTag(Utilities.namespacedKeyToString(zombieNautilus.getVariant().getKey()), true);
            }
        }
        return null;
    }

    @Override
    public void setPropertyValue(ElementTag variant, Mechanism mechanism) {
        Entity entity = this.getEntity();
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            Wolf.Variant wolfVariant = Utilities.elementToRequiredEnumLike(variant, Wolf.Variant.class, mechanism);
            if (wolfVariant != null) {
                wolf.setVariant(wolfVariant);
            }
        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
            Entity entity2 = this.getEntity();
            if (entity2 instanceof Chicken) {
                Chicken chicken = (Chicken)entity2;
                chickenVariant = Utilities.elementToRequiredEnumLike(variant, Chicken.Variant.class, mechanism);
                if (chickenVariant != null) {
                    chicken.setVariant((Chicken.Variant)chickenVariant);
                }
            } else {
                chickenVariant = this.getEntity();
                if (chickenVariant instanceof CopperGolem) {
                    CopperGolem copperGolem = (CopperGolem)chickenVariant;
                    PaperAPITools.instance.setCopperGolemState(variant, copperGolem, mechanism);
                } else if (COW_SET_VARIANT != null && (chickenVariant = this.getEntity()) instanceof Cow) {
                    Cow cow = (Cow)chickenVariant;
                    cowVariant = Utilities.elementToRequiredEnumLike(variant, Cow.Variant.class, mechanism);
                    if (cowVariant != null) {
                        try {
                            COW_SET_VARIANT.invoke(cow, (Cow.Variant)cowVariant);
                        }
                        catch (Throwable e) {
                            Debug.echoError(e);
                        }
                    }
                } else {
                    cowVariant = this.getEntity();
                    if (cowVariant instanceof Pig) {
                        Pig pig = (Pig)cowVariant;
                        pigVariant = Utilities.elementToRequiredEnumLike(variant, Pig.Variant.class, mechanism);
                        if (pigVariant != null) {
                            pig.setVariant((Pig.Variant)pigVariant);
                        }
                    } else {
                        pigVariant = this.getEntity();
                        if (pigVariant instanceof ZombieNautilus) {
                            ZombieNautilus zombieNautilus = (ZombieNautilus)pigVariant;
                            ZombieNautilus.Variant zombieNautilusVariant = Utilities.elementToRequiredEnumLike(variant, ZombieNautilus.Variant.class, mechanism);
                            if (zombieNautilusVariant != null) {
                                zombieNautilus.setVariant(zombieNautilusVariant);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getPropertyId() {
        return "variant";
    }

    public static void register() {
        EntityVariant.autoRegister("variant", EntityVariant.class, ElementTag.class, false, new String[0]);
    }

    static {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
            Class<?> cowClass = ReflectionHelper.getClassOrThrow("org.bukkit.entity.Cow");
            COW_GET_VARIANT = ReflectionHelper.getMethodHandle(cowClass, "getVariant", new Class[0]);
            COW_SET_VARIANT = ReflectionHelper.getMethodHandle(cowClass, "setVariant", Cow.Variant.class);
        } else {
            COW_GET_VARIANT = null;
            COW_SET_VARIANT = null;
        }
    }
}

