/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.BigDripleaf;
import org.bukkit.block.data.type.BubbleColumn;
import org.bukkit.block.data.type.CommandBlock;
import org.bukkit.block.data.type.Comparator;
import org.bukkit.block.data.type.CreakingHeart;
import org.bukkit.block.data.type.DaylightDetector;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.block.data.type.SculkCatalyst;
import org.bukkit.block.data.type.SculkSensor;
import org.bukkit.block.data.type.SculkShrieker;
import org.bukkit.block.data.type.StructureBlock;
import org.bukkit.block.data.type.Tripwire;

public class MaterialMode
extends MaterialProperty<ElementTag> {
    public static boolean describes(MaterialTag material) {
        BlockData data = material.getModernData();
        return data instanceof Comparator || data instanceof PistonHead || data instanceof BubbleColumn || data instanceof StructureBlock || data instanceof DaylightDetector || data instanceof CommandBlock || data instanceof SculkSensor || data instanceof BigDripleaf || data instanceof Tripwire || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && (data instanceof SculkCatalyst || data instanceof SculkShrieker) || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && data instanceof CreakingHeart;
    }

    @Override
    public ElementTag getPropertyValue() {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Comparator) {
            Comparator comparator = (Comparator)blockData;
            return new ElementTag((Enum<?>)comparator.getMode());
        }
        blockData = this.getBlockData();
        if (blockData instanceof BubbleColumn) {
            BubbleColumn bubbleColumn = (BubbleColumn)blockData;
            return new ElementTag(bubbleColumn.isDrag() ? "DRAG" : "NORMAL", true);
        }
        blockData = this.getBlockData();
        if (blockData instanceof PistonHead) {
            PistonHead pistonHead = (PistonHead)blockData;
            return new ElementTag(pistonHead.isShort() ? "SHORT" : "NORMAL", true);
        }
        blockData = this.getBlockData();
        if (blockData instanceof StructureBlock) {
            StructureBlock structureBlock = (StructureBlock)blockData;
            return new ElementTag((Enum<?>)structureBlock.getMode());
        }
        blockData = this.getBlockData();
        if (blockData instanceof DaylightDetector) {
            DaylightDetector daylightDetector = (DaylightDetector)blockData;
            return new ElementTag(daylightDetector.isInverted() ? "INVERTED" : "NORMAL", true);
        }
        blockData = this.getBlockData();
        if (blockData instanceof CommandBlock) {
            CommandBlock cmdBlock = (CommandBlock)blockData;
            return new ElementTag(cmdBlock.isConditional() ? "CONDITIONAL" : "NORMAL", true);
        }
        blockData = this.getBlockData();
        if (blockData instanceof SculkSensor) {
            SculkSensor sculkSensor = (SculkSensor)blockData;
            return new ElementTag((Enum<?>)sculkSensor.getPhase());
        }
        blockData = this.getBlockData();
        if (blockData instanceof BigDripleaf) {
            BigDripleaf bigDripleaf = (BigDripleaf)blockData;
            return new ElementTag((Enum<?>)bigDripleaf.getTilt());
        }
        blockData = this.getBlockData();
        if (blockData instanceof Tripwire) {
            Tripwire tripwire = (Tripwire)blockData;
            return new ElementTag(tripwire.isDisarmed() ? "DISARMED" : "ARMED", true);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && (blockData = this.getBlockData()) instanceof SculkCatalyst) {
            SculkCatalyst sculkCatalyst = (SculkCatalyst)blockData;
            return new ElementTag(sculkCatalyst.isBloom() ? "BLOOM" : "NORMAL", true);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && (blockData = this.getBlockData()) instanceof SculkShrieker) {
            SculkShrieker sculkShrieker = (SculkShrieker)blockData;
            return new ElementTag(sculkShrieker.isShrieking() ? "SHRIEKING" : "NORMAL", true);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (blockData = this.getBlockData()) instanceof CreakingHeart) {
            CreakingHeart creakingHeart = (CreakingHeart)blockData;
            return new ElementTag((Enum<?>)creakingHeart.getCreakingHeartState());
        }
        return null;
    }

    @Override
    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Comparator) {
            Comparator comparator = (Comparator)blockData;
            if (mechanism.requireEnum(Comparator.Mode.class)) {
                comparator.setMode(value.asEnum(Comparator.Mode.class));
            }
        } else {
            blockData = this.getBlockData();
            if (blockData instanceof BubbleColumn) {
                BubbleColumn bubbleColumn = (BubbleColumn)blockData;
                bubbleColumn.setDrag(value.asLowerString().equals("drag"));
            } else {
                blockData = this.getBlockData();
                if (blockData instanceof PistonHead) {
                    PistonHead pistonHead = (PistonHead)blockData;
                    pistonHead.setShort(value.asLowerString().equals("short"));
                } else {
                    blockData = this.getBlockData();
                    if (blockData instanceof StructureBlock) {
                        StructureBlock structureBlock = (StructureBlock)blockData;
                        if (mechanism.requireEnum(StructureBlock.Mode.class)) {
                            structureBlock.setMode(value.asEnum(StructureBlock.Mode.class));
                        }
                    } else {
                        blockData = this.getBlockData();
                        if (blockData instanceof DaylightDetector) {
                            DaylightDetector daylightDetector = (DaylightDetector)blockData;
                            daylightDetector.setInverted(value.asLowerString().equals("inverted"));
                        } else {
                            blockData = this.getBlockData();
                            if (blockData instanceof CommandBlock) {
                                CommandBlock cmdBlock = (CommandBlock)blockData;
                                cmdBlock.setConditional(value.asLowerString().equals("conditional"));
                            } else {
                                blockData = this.getBlockData();
                                if (blockData instanceof SculkSensor) {
                                    SculkSensor sculkSensor = (SculkSensor)blockData;
                                    if (mechanism.requireEnum(SculkSensor.Phase.class)) {
                                        sculkSensor.setPhase(value.asEnum(SculkSensor.Phase.class));
                                    }
                                } else {
                                    blockData = this.getBlockData();
                                    if (blockData instanceof BigDripleaf) {
                                        BigDripleaf bigDripleaf = (BigDripleaf)blockData;
                                        if (mechanism.requireEnum(BigDripleaf.Tilt.class)) {
                                            bigDripleaf.setTilt(value.asEnum(BigDripleaf.Tilt.class));
                                        }
                                    } else {
                                        blockData = this.getBlockData();
                                        if (blockData instanceof Tripwire) {
                                            Tripwire tripwire = (Tripwire)blockData;
                                            tripwire.setDisarmed(value.asLowerString().equals("disarmed"));
                                        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && (blockData = this.getBlockData()) instanceof SculkCatalyst) {
                                            SculkCatalyst sculkCatalyst = (SculkCatalyst)blockData;
                                            sculkCatalyst.setBloom(value.asLowerString().equals("bloom"));
                                        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && (blockData = this.getBlockData()) instanceof SculkShrieker) {
                                            SculkShrieker sculkShrieker = (SculkShrieker)blockData;
                                            sculkShrieker.setShrieking(value.asLowerString().equals("shrieking"));
                                        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (blockData = this.getBlockData()) instanceof CreakingHeart) {
                                            CreakingHeart creakingHeart = (CreakingHeart)blockData;
                                            if (mechanism.requireEnum(CreakingHeart.State.class)) {
                                                creakingHeart.setCreakingHeartState(value.asEnum(CreakingHeart.State.class));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getPropertyId() {
        return "mode";
    }

    public static void register() {
        MaterialMode.autoRegister("mode", MaterialMode.class, ElementTag.class, false, new String[0]);
    }
}

