/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.interfaces.EnchantmentHelper;
import com.denizenscript.denizen.nms.v1_20.Handler;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.helpers.EntityHelperImpl;
import com.denizenscript.denizen.scripts.containers.core.EnchantmentScriptContainer;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R4.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class EnchantmentHelperImpl
extends EnchantmentHelper {
    public static final Field REGISTRY_FROZEN = ReflectionHelper.getFields(RegistryMaterials.class).get(ReflectionMappingsInfo.MappedRegistry_frozen, Boolean.TYPE);
    public static final Field REGISTRY_INTRUSIVE_HOLDERS = ReflectionHelper.getFields(RegistryMaterials.class).get(ReflectionMappingsInfo.MappedRegistry_unregisteredIntrusiveHolders, Map.class);

    @Override
    public org.bukkit.enchantments.Enchantment registerFakeEnchantment(final EnchantmentScriptContainer.EnchantmentReference script) {
        try {
            Map holders = (Map)REGISTRY_INTRUSIVE_HOLDERS.get(BuiltInRegistries.f);
            if (holders == null) {
                REGISTRY_INTRUSIVE_HOLDERS.set(BuiltInRegistries.f, new IdentityHashMap());
            }
            boolean wasFrozen = REGISTRY_FROZEN.getBoolean(BuiltInRegistries.f);
            REGISTRY_FROZEN.setBoolean(BuiltInRegistries.f, false);
            EnumItemSlot[] slots = new EnumItemSlot[script.script.slots.size()];
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = EnumItemSlot.valueOf((String)CoreUtilities.toUpperCase(script.script.slots.get(i)));
            }
            Enchantment nmsEnchant = new Enchantment(null){

                public int a(int level, DamageSource src) {
                    return script.script.getDamageProtection(level, src.e(), (Entity)(src.d() == null ? null : src.d().getBukkitEntity()));
                }

                protected boolean a(Enchantment nmsEnchantment) {
                    MinecraftKey nmsKey = BuiltInRegistries.f.b((Object)nmsEnchantment);
                    NamespacedKey bukkitKey = CraftNamespacedKey.fromMinecraft((MinecraftKey)nmsKey);
                    org.bukkit.enchantments.Enchantment bukkitEnchant = CraftEnchantment.getByKey((NamespacedKey)bukkitKey);
                    return script.script.isCompatible(bukkitEnchant);
                }

                protected String h() {
                    return script.script.descriptionId;
                }

                public String j() {
                    return script.script.descriptionId;
                }

                public IChatBaseComponent e(int level) {
                    return Handler.componentToNMS(script.script.getFullName(level));
                }

                public boolean b(ItemStack var0) {
                    return super.b(var0) && script.script.canEnchant(CraftItemStack.asBukkitCopy((ItemStack)var0));
                }

                public void a(EntityLiving attacker, net.minecraft.world.entity.Entity victim, int level) {
                    script.script.doPostAttack((Entity)attacker.getBukkitEntity(), (Entity)victim.getBukkitEntity(), level);
                }

                public void b(EntityLiving victim, net.minecraft.world.entity.Entity attacker, int level) {
                    script.script.doPostHurt((Entity)victim.getBukkitEntity(), (Entity)attacker.getBukkitEntity(), level);
                }

                public boolean a() {
                    return script.script.isTreasureOnly;
                }

                public boolean b() {
                    return script.script.isCurse;
                }

                public boolean k() {
                    return script.script.isTradable;
                }

                public boolean l() {
                    return script.script.isDiscoverable;
                }
            };
            NamespacedKey enchantmentKey = new NamespacedKey((Plugin)Denizen.getInstance(), script.script.id);
            IRegistry.a((IRegistry)BuiltInRegistries.f, (String)enchantmentKey.toString(), (Object)nmsEnchant);
            final String enchName = CoreUtilities.toUpperCase(script.script.id);
            CraftEnchantment ench = new CraftEnchantment(enchantmentKey, nmsEnchant){

                public String getName() {
                    return enchName;
                }
            };
            REGISTRY_INTRUSIVE_HOLDERS.set(BuiltInRegistries.f, holders);
            if (wasFrozen) {
                BuiltInRegistries.f.l();
            }
            return ench;
        }
        catch (Throwable ex) {
            Debug.echoError("Failed to register enchantment " + script.script.id);
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public boolean isDiscoverable(org.bukkit.enchantments.Enchantment enchantment) {
        return ((CraftEnchantment)enchantment).getHandle().l();
    }

    @Override
    public boolean isTradable(org.bukkit.enchantments.Enchantment enchantment) {
        return ((CraftEnchantment)enchantment).getHandle().k();
    }

    @Override
    public boolean isCurse(org.bukkit.enchantments.Enchantment enchantment) {
        return ((CraftEnchantment)enchantment).getHandle().b();
    }

    @Override
    public int getMinCost(org.bukkit.enchantments.Enchantment enchantment, int level) {
        return ((CraftEnchantment)enchantment).getHandle().c(level);
    }

    @Override
    public int getMaxCost(org.bukkit.enchantments.Enchantment enchantment, int level) {
        return ((CraftEnchantment)enchantment).getHandle().d(level);
    }

    @Override
    public String getFullName(org.bukkit.enchantments.Enchantment enchantment, int level) {
        return FormattedTextHelper.stringify(Handler.componentToSpigot(((CraftEnchantment)enchantment).getHandle().e(level)));
    }

    @Override
    public int getDamageProtection(org.bukkit.enchantments.Enchantment enchantment, int level, EntityDamageEvent.DamageCause type, Entity attacker) {
        net.minecraft.world.entity.Entity nmsAttacker = attacker == null ? null : ((CraftEntity)attacker).getHandle();
        DamageSource src = EntityHelperImpl.getSourceFor(nmsAttacker, type, nmsAttacker);
        if (src instanceof EntityHelperImpl.FakeDamageSrc) {
            EntityHelperImpl.FakeDamageSrc fakeDamageSrc = (EntityHelperImpl.FakeDamageSrc)src;
            src = fakeDamageSrc.real;
        }
        return ((CraftEnchantment)enchantment).getHandle().a(level, src);
    }
}

