/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleSwimEvent;

public class EntitySwimScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntitySwimScriptEvent instance;
    public EntityTag entity;
    public boolean state;

    public EntitySwimScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(2).equals("swimming")) {
            return false;
        }
        String cmd = path.eventArgLowerAt(1);
        if (!(cmd.equals("starts") || cmd.equals("stops") || cmd.equals("toggles"))) {
            return false;
        }
        return EntitySwimScriptEvent.couldMatchEntity(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!EntitySwimScriptEvent.tryEntity(this.entity, path.eventArgLowerAt(0))) {
            return false;
        }
        String cmd = path.eventArgLowerAt(1);
        if (cmd.equals("starts") && !this.state) {
            return false;
        }
        if (cmd.equals("stops") && this.state) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntitySwim";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("state")) {
            return new ElementTag(this.state);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityToggleSwim(EntityToggleSwimEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.state = event.isSwimming();
        this.fire((Event)event);
    }
}

