/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.bukkit;

import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EnchantmentTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.containers.core.FormatScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.tags.core.CustomColorTagBase;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.TextWidthHelper;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.nio.charset.StandardCharsets;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Color;

public class BukkitElementProperties
implements Property {
    public static final String[] handledMechs = new String[0];
    ElementTag element;

    public static boolean describes(ObjectTag element) {
        return element instanceof ElementTag;
    }

    public static BukkitElementProperties getFrom(ObjectTag element) {
        if (!BukkitElementProperties.describes(element)) {
            return null;
        }
        return new BukkitElementProperties((ElementTag)element);
    }

    private BukkitElementProperties(ElementTag element) {
        this.element = element;
    }

    public static String replaceEssentialsHexColors(char prefix, String input) {
        int hex = input.indexOf(prefix + "#");
        while (hex != -1 && hex < input.length() + 8) {
            StringBuilder converted = new StringBuilder(10);
            converted.append('\u00a7').append("x");
            for (int i = 0; i < 6; ++i) {
                char c = input.charAt(hex + 2 + i);
                if (!ArgumentHelper.HEX_MATCHER.isMatch(c)) {
                    return input;
                }
                converted.append('\u00a7').append(c);
            }
            input = input.substring(0, hex) + converted.toString() + input.substring(hex + 8);
            hex = input.indexOf(prefix + "#", hex + 2);
        }
        return input;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(BiomeTag.class, "as_biome", (attribute, object) -> ElementTag.handleNull(object.asString(), BiomeTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "BiomeTag", attribute.hasAlternative()), new String[0]);
        PropertyParser.registerTag(ChunkTag.class, "as_chunk", (attribute, object) -> ElementTag.handleNull(object.asString(), ChunkTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "ChunkTag", attribute.hasAlternative()), "aschunk");
        PropertyParser.registerStaticTag(ColorTag.class, "as_color", (attribute, object) -> ElementTag.handleNull(object.asString(), ColorTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "ColorTag", attribute.hasAlternative()), "ascolor");
        PropertyParser.registerTag(CuboidTag.class, "as_cuboid", (attribute, object) -> ElementTag.handleNull(object.asString(), CuboidTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "CuboidTag", attribute.hasAlternative()), "ascuboid");
        PropertyParser.registerTag(EllipsoidTag.class, "as_ellipsoid", (attribute, object) -> ElementTag.handleNull(object.asString(), EllipsoidTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "EllipsoidTag", attribute.hasAlternative()), new String[0]);
        PropertyParser.registerStaticTag(EnchantmentTag.class, "as_enchantment", (attribute, object) -> ElementTag.handleNull(object.asString(), EnchantmentTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "EnchantmentTag", attribute.hasAlternative()), new String[0]);
        PropertyParser.registerTag(EntityTag.class, "as_entity", (attribute, object) -> ElementTag.handleNull(object.asString(), EntityTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "EntityTag", attribute.hasAlternative()), "asentity");
        PropertyParser.registerTag(InventoryTag.class, "as_inventory", (attribute, object) -> ElementTag.handleNull(object.asString(), InventoryTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "InventoryTag", attribute.hasAlternative()), "asinventory");
        PropertyParser.registerTag(ItemTag.class, "as_item", (attribute, object) -> ElementTag.handleNull(object.asString(), ItemTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "ItemTag", attribute.hasAlternative()), "asitem");
        PropertyParser.registerTag(LocationTag.class, "as_location", (attribute, object) -> ElementTag.handleNull(object.asString(), LocationTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "LocationTag", attribute.hasAlternative()), "aslocation");
        PropertyParser.registerStaticTag(MaterialTag.class, "as_material", (attribute, object) -> ElementTag.handleNull(object.asString(), MaterialTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "MaterialTag", attribute.hasAlternative()), "asmaterial");
        PropertyParser.registerTag(NPCTag.class, "as_npc", (attribute, object) -> ElementTag.handleNull(object.asString(), NPCTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "NPCTag", attribute.hasAlternative()), "asnpc");
        PropertyParser.registerTag(PlayerTag.class, "as_player", (attribute, object) -> ElementTag.handleNull(object.asString(), PlayerTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "PlayerTag", attribute.hasAlternative()), "asplayer");
        PropertyParser.registerStaticTag(PluginTag.class, "as_plugin", (attribute, object) -> ElementTag.handleNull(object.asString(), PluginTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "PluginTag", attribute.hasAlternative()), "asplugin");
        PropertyParser.registerTag(PolygonTag.class, "as_polygon", (attribute, object) -> ElementTag.handleNull(object.asString(), PolygonTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "PolygonTag", attribute.hasAlternative()), new String[0]);
        PropertyParser.registerStaticTag(TradeTag.class, "as_trade", (attribute, object) -> ElementTag.handleNull(object.asString(), TradeTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "TradeTag", attribute.hasAlternative()), new String[0]);
        PropertyParser.registerTag(WorldTag.class, "as_world", (attribute, object) -> ElementTag.handleNull(object.asString(), WorldTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "WorldTag", attribute.hasAlternative()), "asworld");
        PropertyParser.registerTag(ElementTag.class, "format", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            FormatScriptContainer format = (FormatScriptContainer)ScriptRegistry.getScriptContainer(attribute.getParam());
            if (format == null) {
                attribute.echoError("Could not find format script matching '" + attribute.getParam() + "'");
                return null;
            }
            return new ElementTag(format.getFormattedText(object.asString(), attribute.getScriptEntry() != null ? ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getNPC() : null, attribute.getScriptEntry() != null ? ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getPlayer() : null));
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "split_lines_by_width", (attribute, object) -> {
            int width = attribute.getIntParam();
            return new ElementTag(TextWidthHelper.splitLines(object.asString(), width));
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "text_width", (attribute, object) -> new ElementTag(TextWidthHelper.getWidth(object.asString())), new String[0]);
        PropertyParser.registerStaticTag(ListTag.class, "lines_to_colored_list", (attribute, object) -> {
            ListTag output = new ListTag();
            String colors = "";
            for (String line : CoreUtilities.split(object.asString(), '\n')) {
                output.add(colors + line);
                colors = ChatColor.getLastColors((String)(colors + line));
            }
            return output;
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "last_color", (attribute, object) -> new ElementTag(ChatColor.getLastColors((String)object.asString())), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "strip_color", (attribute, object) -> new ElementTag(FormattedTextHelper.parse(object.asString(), net.md_5.bungee.api.ChatColor.WHITE)[0].toPlainText()), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "parse_color", (attribute, object) -> {
            char prefix = '&';
            if (attribute.hasParam()) {
                prefix = attribute.getParam().charAt(0);
            }
            String parsed = net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)prefix, (String)object.asString());
            parsed = BukkitElementProperties.replaceEssentialsHexColors(prefix, parsed);
            return new ElementTag(parsed);
        }, new String[0]);
        PropertyParser.registerTag(ElementTag.class, "to_itemscript_hash", (attribute, object) -> new ElementTag(ItemScriptHelper.createItemScriptID(object.asString())), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "to_secret_colors", (attribute, object) -> {
            String text = object.asString();
            byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
            String hex = CoreUtilities.hexEncode(bytes);
            StringBuilder colors = new StringBuilder(text.length() * 2);
            for (int i = 0; i < hex.length(); ++i) {
                colors.append('\u00a7').append(hex.charAt(i));
            }
            return new ElementTag(colors.toString());
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "from_secret_colors", (attribute, object) -> {
            String text = object.asString().replace(String.valueOf('\u00a7'), "");
            byte[] bytes = CoreUtilities.hexDecode(text);
            return new ElementTag(new String(bytes, StandardCharsets.UTF_8));
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "to_raw_json", (attribute, object) -> new ElementTag(ComponentSerializer.toString((BaseComponent[])FormattedTextHelper.parse(object.asString(), net.md_5.bungee.api.ChatColor.WHITE))), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "from_raw_json", (attribute, object) -> new ElementTag(FormattedTextHelper.stringify(ComponentSerializer.parse((String)object.asString()), net.md_5.bungee.api.ChatColor.WHITE)), new String[0]);
        PropertyParser.registerTag(ElementTag.class, "on_hover", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String hoverText = attribute.getParam();
            String type = "SHOW_TEXT";
            if (attribute.startsWith("type", 2)) {
                type = attribute.getContext(2);
                attribute.fulfill(1);
            }
            return new ElementTag("\u00a7[hover=" + type + ";" + FormattedTextHelper.escape(hoverText) + "]" + object.asString() + '\u00a7' + "[/hover]");
        }, new String[0]);
        PropertyParser.registerTag(ElementTag.class, "on_click", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String clickText = attribute.getParam();
            String type = "RUN_COMMAND";
            if (attribute.startsWith("type", 2)) {
                type = attribute.getContext(2);
                attribute.fulfill(1);
            }
            return new ElementTag("\u00a7[click=" + type + ";" + FormattedTextHelper.escape(clickText) + "]" + object.asString() + '\u00a7' + "[/click]");
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "with_insertion", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String insertionText = attribute.getParam();
            return new ElementTag("\u00a7[insertion=" + FormattedTextHelper.escape(insertionText) + "]" + object.asString() + '\u00a7' + "[/insertion]");
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "no_reset", (attribute, object) -> {
            if (object.asString().length() == 2 && object.asString().charAt(0) == '\u00a7') {
                return new ElementTag("\u00a7[color=" + object.asString().charAt(1) + "]");
            }
            return null;
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "end_format", (attribute, object) -> {
            if (object.asString().length() == 2 && object.asString().charAt(0) == '\u00a7') {
                return new ElementTag("\u00a7[reset=" + object.asString().charAt(1) + "]");
            }
            return null;
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "italicize", (attribute, object) -> new ElementTag(net.md_5.bungee.api.ChatColor.ITALIC + object.asString() + '\u00a7' + "[reset=o]"), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "bold", (attribute, object) -> new ElementTag(net.md_5.bungee.api.ChatColor.BOLD + object.asString() + '\u00a7' + "[reset=l]"), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "underline", (attribute, object) -> new ElementTag(net.md_5.bungee.api.ChatColor.UNDERLINE + object.asString() + '\u00a7' + "[reset=n]"), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "strikethrough", (attribute, object) -> new ElementTag(net.md_5.bungee.api.ChatColor.STRIKETHROUGH + object.asString() + '\u00a7' + "[reset=m]"), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "obfuscate", (attribute, object) -> new ElementTag(net.md_5.bungee.api.ChatColor.MAGIC + object.asString() + '\u00a7' + "[reset=k]"), new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "custom_color", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new ElementTag("\u00a7[color=f]" + CustomColorTagBase.getColor(attribute.getParam(), attribute.context) + object.asString() + '\u00a7' + "[reset=color]");
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "color", (attribute, object) -> {
            net.md_5.bungee.api.ChatColor color;
            if (!attribute.hasParam()) {
                return null;
            }
            String colorName = attribute.getParam();
            String colorOut = null;
            if (colorName.length() == 1) {
                color = net.md_5.bungee.api.ChatColor.getByChar((char)colorName.charAt(0));
                if (color != null) {
                    colorOut = color.toString();
                }
            } else {
                if (colorName.length() == 7 && colorName.startsWith("#")) {
                    return new ElementTag("\u00a7[color=" + colorName + "]" + object.asString() + '\u00a7' + "[reset=color]");
                }
                if (colorName.length() == 14 && colorName.startsWith("\u00a7x")) {
                    return new ElementTag("\u00a7[color=#" + CoreUtilities.replace(colorName.substring(2), String.valueOf('\u00a7'), "") + "]" + object.asString() + '\u00a7' + "[reset=color]");
                }
                if (colorName.startsWith("co@")) {
                    ColorTag color2 = ColorTag.valueOf(colorName, attribute.context);
                    StringBuilder hex = new StringBuilder(Integer.toHexString(color2.getColor().asRGB()));
                    while (hex.length() < 6) {
                        hex.insert(0, "0");
                    }
                    return new ElementTag("\u00a7[color=#" + hex + "]" + object.asString() + '\u00a7' + "[reset=color]");
                }
            }
            if (colorOut == null) {
                try {
                    color = net.md_5.bungee.api.ChatColor.of((String)colorName.toUpperCase());
                    String colorStr = color.toString().replace(String.valueOf('\u00a7'), "").replace("x", "#");
                    colorOut = "\u00a7[color=" + colorStr + "]";
                }
                catch (IllegalArgumentException ex) {
                    attribute.echoError("Color '" + colorName + "' doesn't exist (for ElementTag.color[...]).");
                    return null;
                }
            }
            return new ElementTag(colorOut + object.asString() + '\u00a7' + "[reset=color]");
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "font", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String fontName = attribute.getParam();
            return new ElementTag("\u00a7[font=" + fontName + "]" + object.asString() + '\u00a7' + "[reset=font]");
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "rainbow", (attribute, object) -> {
            String str = object.asString();
            String pattern = "4c6e2ab319d5";
            if (attribute.hasParam()) {
                pattern = attribute.getParam();
            }
            StringBuilder output = new StringBuilder(str.length() * 3);
            for (int i = 0; i < str.length(); ++i) {
                output.append('\u00a7').append(pattern.charAt(i % pattern.length())).append(str.charAt(i));
            }
            return new ElementTag(output.toString());
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "hex_rainbow", (attribute, object) -> {
            String str = object.asString();
            int[] HSB = new int[]{0, 255, 255};
            if (str.startsWith("\u00a7x") && str.length() > 14) {
                char[] colors = new char[6];
                for (int i = 0; i < 6; ++i) {
                    colors[i] = str.charAt(3 + i * 2);
                }
                int rgb = Integer.parseInt(new String(colors), 16);
                HSB = new ColorTag(Color.fromRGB((int)rgb)).toHSB();
                str = str.substring(14);
            }
            float hue = (float)HSB[0] / 255.0f;
            str = net.md_5.bungee.api.ChatColor.stripColor((String)str);
            int length = str.length();
            if (attribute.hasParam()) {
                length = attribute.getIntParam();
            }
            float increment = 1.0f / (float)length;
            StringBuilder output = new StringBuilder(str.length() * 8);
            for (int i = 0; i < str.length(); ++i) {
                String hex = Integer.toHexString(ColorTag.fromHSB(HSB).getColor().asRGB());
                output.append(FormattedTextHelper.stringifyRGBSpigot(hex)).append(str.charAt(i));
                HSB[0] = Math.round((hue += increment) * 255.0f);
            }
            return new ElementTag(output.toString());
        }, new String[0]);
        PropertyParser.registerStaticTag(ElementTag.class, "color_gradient", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String str = net.md_5.bungee.api.ChatColor.stripColor((String)object.asString());
            if (str.length() == 0) {
                return new ElementTag("");
            }
            MapTag inputMap = attribute.paramAsType(MapTag.class);
            if (inputMap == null) {
                return null;
            }
            ObjectTag fromObj = inputMap.getObject("from");
            ObjectTag toObj = inputMap.getObject("to");
            if (fromObj == null || toObj == null) {
                return null;
            }
            ColorTag fromColor = fromObj.asType(ColorTag.class, attribute.context);
            ColorTag toColor = toObj.asType(ColorTag.class, attribute.context);
            if (fromColor == null || toColor == null) {
                return null;
            }
            float red = fromColor.getColor().getRed();
            float green = fromColor.getColor().getGreen();
            float blue = fromColor.getColor().getBlue();
            float targetRed = toColor.getColor().getRed();
            float targetGreen = toColor.getColor().getGreen();
            float targetBlue = toColor.getColor().getBlue();
            int length = str.length();
            float redMove = (targetRed - red) / (float)length;
            float greenMove = (targetGreen - green) / (float)length;
            float blueMove = (targetBlue - blue) / (float)length;
            StringBuilder output = new StringBuilder(str.length() * 15);
            for (int i = 0; i < str.length(); ++i) {
                String hex = Integer.toHexString((int)red << 16 | (int)green << 8 | (int)blue);
                output.append(FormattedTextHelper.stringifyRGBSpigot(hex)).append(str.charAt(i));
                red += redMove;
                green += greenMove;
                blue += blueMove;
            }
            return new ElementTag(output.toString());
        }, new String[0]);
    }

    public String asString() {
        return this.element.asString();
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "BukkitElementProperties";
    }

    @Override
    public void adjust(Mechanism mechanism) {
    }
}

