/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;

public class HotbarScrollScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static HotbarScrollScriptEvent instance;
    public PlayerItemHeldEvent event;

    public HotbarScrollScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player holds item") || path.eventLower.startsWith("player scrolls their hotbar");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        if (path.switches.containsKey("item") && !HotbarScrollScriptEvent.tryItem(new ItemTag(this.event.getPlayer().getInventory().getItem(this.event.getNewSlot())), path.switches.get("item"))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerScrollsItem";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("new_slot")) {
            return new ElementTag(this.event.getNewSlot() + 1);
        }
        if (name.equals("previous_slot")) {
            return new ElementTag(this.event.getPreviousSlot() + 1);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerScrollsHotbar(PlayerItemHeldEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

