/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.bukkit;

import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import java.util.List;
import org.bukkit.ChatColor;

public class BukkitListProperties
implements Property {
    public static final String[] handledMechs = new String[0];
    ListTag list;

    public static boolean describes(ObjectTag list) {
        return list instanceof ListTag;
    }

    public static BukkitListProperties getFrom(ObjectTag list) {
        if (!BukkitListProperties.describes(list)) {
            return null;
        }
        return new BukkitListProperties((ListTag)list);
    }

    private BukkitListProperties(ListTag list) {
        this.list = list;
    }

    public static void registerTags() {
        PropertyParser.registerTag(ElementTag.class, "formatted", (attribute, listObj) -> {
            ListTag list = listObj.list;
            if (list.isEmpty()) {
                return new ElementTag("");
            }
            StringBuilder output = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                MaterialTag material;
                ItemTag item;
                EntityFormObject gotten;
                ObjectTag object = list.getObject(i);
                String val = object.toString();
                boolean handled = false;
                if (val.startsWith("p@") && (gotten = object.asType(PlayerTag.class, attribute.context)) != null) {
                    output.append(((PlayerTag)gotten).getName());
                    handled = true;
                }
                if ((val.startsWith("e@") || val.startsWith("n@")) && (gotten = object.asType(EntityTag.class, attribute.context)) != null) {
                    output.append(((EntityTag)gotten).getName());
                    handled = true;
                }
                if (val.startsWith("i@") && (item = object.asType(ItemTag.class, attribute.context)) != null) {
                    output.append(item.formattedName());
                    handled = true;
                }
                if (val.startsWith("m@") && (material = object.asType(MaterialTag.class, attribute.context)) != null) {
                    output.append(material.name());
                    handled = true;
                }
                if (!handled) {
                    if (object instanceof ElementTag) {
                        output.append(val.replaceAll("\\w+@", ""));
                    } else {
                        output.append(ChatColor.stripColor((String)Debug.cleanTextForDebugOutput(object.debuggable())));
                    }
                }
                if (i == list.size() - 2) {
                    output.append(i == 0 ? " and " : ", and ");
                    continue;
                }
                output.append(", ");
            }
            return new ElementTag(output.toString().substring(0, output.length() - 2));
        }, new String[0]);
        PropertyParser.registerTag(PolygonTag.class, "to_polygon", (attribute, listObj) -> {
            List<LocationTag> locations = listObj.list.filter(LocationTag.class, attribute.context);
            if (locations == null || locations.isEmpty()) {
                return null;
            }
            if (locations.size() > Settings.blockTagsMaxBlocks()) {
                return null;
            }
            PolygonTag polygon = new PolygonTag(new WorldTag(locations.get(0).getWorldName()));
            polygon.yMax = polygon.yMin = locations.get(0).getY();
            for (LocationTag location : locations) {
                polygon.yMin = Math.min(polygon.yMin, location.getY());
                polygon.yMax = Math.max(polygon.yMax, location.getY());
                polygon.corners.add(new PolygonTag.Corner(location.getX(), location.getZ()));
            }
            polygon.recalculateBox();
            return polygon;
        }, new String[0]);
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "BukkitListProperties";
    }

    @Override
    public void adjust(Mechanism mechanism) {
    }
}

