/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events;

import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ScriptEventCouldMatcher {
    public static HashMap<String, PathArgumentValidator> knownValidatorTypes = new HashMap();
    public String format;
    public PathArgumentValidator[] validators;
    public int[] argOrder;

    public ScriptEventCouldMatcher(String format) {
        int i;
        this.format = format;
        ArrayList<PathArgumentValidator> validatorList = new ArrayList<PathArgumentValidator>();
        List<String> args = CoreUtilities.split(format, ' ');
        for (String arg : args) {
            if (arg.isEmpty()) {
                Debug.echoError("Event matcher format error: '" + format + "' has a double space?");
                continue;
            }
            if (arg.startsWith("<")) {
                if (!arg.endsWith(">")) {
                    Debug.echoError("Event matcher format error: '" + format + "' has an unclosed fill-in part.");
                    continue;
                }
                String toUse = arg.substring(1, arg.length() - 1);
                if (toUse.startsWith("'") && toUse.endsWith("'")) {
                    validatorList.add(word -> true);
                    continue;
                }
                PathArgumentValidator validator = knownValidatorTypes.get(toUse);
                if (validator == null) {
                    Debug.echoError("Event matcher format error: '" + format + "' has an unrecognized input type '" + toUse + "'");
                    continue;
                }
                validatorList.add(validator);
                continue;
            }
            if (CoreUtilities.contains(arg, '|')) {
                validatorList.add(new StringSetBasedValidator(CoreUtilities.split(arg, '|')));
                continue;
            }
            validatorList.add(new StringBasedValidator(arg));
        }
        this.validators = validatorList.toArray(new PathArgumentValidator[0]);
        this.argOrder = new int[this.validators.length];
        int index = 0;
        for (i = 0; i < this.validators.length; ++i) {
            if (!ScriptEventCouldMatcher.shouldPrioritize(this.validators[i])) continue;
            this.argOrder[index++] = i;
        }
        for (i = 0; i < this.validators.length; ++i) {
            if (ScriptEventCouldMatcher.shouldPrioritize(this.validators[i])) continue;
            this.argOrder[index++] = i;
        }
    }

    private static boolean shouldPrioritize(PathArgumentValidator valid) {
        return valid instanceof StringBasedValidator || valid instanceof StringSetBasedValidator;
    }

    public boolean doesMatch(ScriptEvent.ScriptPath path) {
        if (path.eventArgsLower.length != this.validators.length) {
            return false;
        }
        for (int i : this.argOrder) {
            if (this.validators[i].doesMatch(path.eventArgsLower[i])) continue;
            return false;
        }
        return true;
    }

    public static class StringSetBasedValidator
    implements PathArgumentValidator {
        public HashSet<String> words;

        public StringSetBasedValidator(Collection<String> words) {
            this.words = new HashSet<String>(words);
        }

        @Override
        public final boolean doesMatch(String arg) {
            return this.words.contains(arg);
        }
    }

    public static class StringBasedValidator
    implements PathArgumentValidator {
        public String word;

        public StringBasedValidator(String word) {
            this.word = word;
        }

        @Override
        public final boolean doesMatch(String arg) {
            return arg.equals(this.word);
        }
    }

    @FunctionalInterface
    public static interface PathArgumentValidator {
        public boolean doesMatch(String var1);
    }
}

