/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;

public class PlayerStatisticIncrementsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerStatisticIncrementsScriptEvent instance;
    public Statistic statistic;
    public PlayerStatisticIncrementEvent event;

    public PlayerStatisticIncrementsScriptEvent() {
        instance = this;
        this.registerCouldMatcher("player statistic increments");
        this.registerCouldMatcher("player statistic <'statistic'> increments");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        return path.eventArgLowerAt(2).equals("increments") || path.eventArgLowerAt(3).equals("increments") && PlayerStatisticIncrementsScriptEvent.couldMatchEnum(path.eventArgLowerAt(2), Statistic.values());
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String stat = path.eventArgLowerAt(2);
        if (!stat.equals("increments") && !stat.equals(CoreUtilities.toLowerCase(this.statistic.toString()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerStatisticIncrements";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "statistic": {
                return new ElementTag(this.statistic.toString());
            }
            case "previous_value": {
                return new ElementTag(this.event.getPreviousValue());
            }
            case "new_value": {
                return new ElementTag(this.event.getNewValue());
            }
            case "qualifier": {
                if (this.statistic.getType() == Statistic.Type.BLOCK || this.statistic.getType() == Statistic.Type.ITEM) {
                    return new MaterialTag(this.event.getMaterial());
                }
                if (this.statistic.getType() != Statistic.Type.ENTITY) break;
                return new EntityTag(this.event.getEntityType());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerStatisticIncrements(PlayerStatisticIncrementEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.statistic = event.getStatistic();
        this.event = event;
        this.fire((Event)event);
    }
}

