/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.citizensnpcs.api.event.NPCTraitCommandAttachEvent;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public class MobproxTrait
extends Trait {
    int checkTimer = 0;
    int timerBounce = 0;
    LivingEntity liveEnt;
    NPCTag dnpc;
    List<Entity> inrange = new ArrayList<Entity>();

    public MobproxTrait() {
        super("mobprox");
    }

    public void run() {
        ++this.checkTimer;
        if (this.checkTimer == 10) {
            this.checkTimer = 0;
            ++this.timerBounce;
            if (this.timerBounce >= this.getTimer()) {
                this.timerBounce = 0;
                if (this.getNPC().isSpawned()) {
                    int range = this.getRange();
                    boolean acceptnpc = this.acceptNpcs();
                    List nearby = this.liveEnt.getNearbyEntities((double)range, (double)range, (double)range);
                    ArrayList<Entity> removeme = new ArrayList<Entity>(this.inrange);
                    for (Entity ent : nearby) {
                        if (!(ent instanceof LivingEntity) || ent instanceof Player && !EntityTag.isCitizensNPC(ent) || !acceptnpc && EntityTag.isCitizensNPC(ent)) continue;
                        removeme.remove(ent);
                        if (!this.inrange.contains(ent)) {
                            this.inrange.add(ent);
                            this.callAction("enter", ent);
                            continue;
                        }
                        this.callAction("move", ent);
                    }
                    for (Entity ent : removeme) {
                        this.inrange.remove(ent);
                        this.callAction("exit", ent);
                    }
                }
            }
        }
    }

    private void callAction(String act, Entity ent) {
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        context.put("entity", new EntityTag(ent).getDenizenObject());
        this.dnpc.action("mob " + act + " proximity", null, context);
        this.dnpc.action(ent.getType().name() + " " + act + " proximity", null, context);
    }

    @EventHandler
    public void onTraitAttachEvent(NPCTraitCommandAttachEvent event) {
        if (!event.getTraitClass().equals(MobproxTrait.class)) {
            return;
        }
        if (event.getNPC() != this.getNPC()) {
            return;
        }
        this.onSpawn();
        if (!this.dnpc.getCitizen().hasTrait(AssignmentTrait.class)) {
            event.getCommandSender().sendMessage(ChatColor.RED + "Warning: This NPC doesn't have a script assigned! Mobprox only works with scripted Denizen NPCs!");
        }
    }

    public int getRange() {
        ObjectTag range = this.dnpc.getFlagTracker().getFlagValue("mobprox_range");
        if (range == null) {
            return 10;
        }
        return new ElementTag(range.toString()).asInt();
    }

    public int getTimer() {
        ObjectTag range = this.dnpc.getFlagTracker().getFlagValue("mobprox_timer");
        if (range == null) {
            return 4;
        }
        return new ElementTag(range.toString()).asInt();
    }

    public boolean acceptNpcs() {
        ObjectTag range = this.dnpc.getFlagTracker().getFlagValue("mobprox_acceptnpcs");
        if (range == null) {
            return false;
        }
        return new ElementTag(range.toString()).asBoolean();
    }

    public void onSpawn() {
        this.liveEnt = (LivingEntity)this.getNPC().getEntity();
        this.dnpc = new NPCTag(this.getNPC());
    }
}

