/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;

public class ItemMap
implements Property {
    public static Material MAP_MATERIAL = Material.FILLED_MAP;
    public static final String[] handledTags = new String[]{"map", "map_scale", "map_locked"};
    public static final String[] handledMechs = new String[]{"map", "full_render", "map_locked"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getBukkitMaterial() == MAP_MATERIAL;
    }

    public static ItemMap getFrom(ObjectTag _item) {
        if (!ItemMap.describes(_item)) {
            return null;
        }
        return new ItemMap((ItemTag)_item);
    }

    private ItemMap(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("map")) {
            if (!this.hasMapId()) {
                return null;
            }
            return new ElementTag(this.getMapId()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("map_scale")) {
            if (!this.hasMapId()) {
                return null;
            }
            MapMeta map = (MapMeta)this.item.getItemMeta();
            if (!map.hasMapView()) {
                return null;
            }
            return new ElementTag(map.getMapView().getScale().getValue()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("map_locked")) {
            if (!this.hasMapId()) {
                return null;
            }
            MapMeta map = (MapMeta)this.item.getItemMeta();
            if (!map.hasMapView()) {
                return null;
            }
            return new ElementTag(map.getMapView().isLocked()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public boolean hasMapId() {
        MapMeta map = (MapMeta)this.item.getItemMeta();
        return map.hasMapId();
    }

    public int getMapId() {
        MapMeta map = (MapMeta)this.item.getItemMeta();
        if (!map.hasMapId()) {
            return 0;
        }
        return map.getMapId();
    }

    public void setMapId(int id) {
        MapMeta map = (MapMeta)this.item.getItemMeta();
        map.setMapId(id);
        this.item.setItemMeta((ItemMeta)map);
    }

    @Override
    public String getPropertyString() {
        if (!this.hasMapId()) {
            return null;
        }
        return String.valueOf(this.getMapId());
    }

    @Override
    public String getPropertyId() {
        return "map";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("map") && mechanism.requireInteger()) {
            this.setMapId(mechanism.getValue().asInt());
        }
        if (mechanism.matches("full_render")) {
            boolean worked;
            int xMin = 0;
            int zMin = 0;
            int xMax = 128;
            int zMax = 128;
            if (mechanism.hasValue()) {
                List<String> input = CoreUtilities.split(mechanism.getValue().asString(), ',');
                if (input.size() != 4) {
                    mechanism.echoError("Invalid input to 'full_render' - must be a set of 4 comma separated integers.");
                    return;
                }
                try {
                    xMin = Math.max(Integer.parseInt(input.get(0)), 0);
                    zMin = Math.max(Integer.parseInt(input.get(1)), 0);
                    xMax = Math.min(Integer.parseInt(input.get(2)), 128);
                    zMax = Math.min(Integer.parseInt(input.get(3)), 128);
                }
                catch (NumberFormatException ex) {
                    mechanism.echoError("Invalid input to 'full_render' - found comma separated list of 4 values, but not all values are integers: " + ex.getMessage());
                }
            }
            if (!(worked = NMSHandler.getItemHelper().renderEntireMap(this.getMapId(), xMin, zMin, xMax, zMax))) {
                mechanism.echoError("Cannot render map: ID doesn't exist. Has the map never been displayed?");
            }
        }
        if (mechanism.matches("map_locked") && mechanism.requireBoolean()) {
            MapMeta meta = (MapMeta)this.item.getItemMeta();
            if (!meta.hasMapView()) {
                Debug.echoError("Map is yet loaded/rendered.");
                return;
            }
            meta.getMapView().setLocked(mechanism.getValue().asBoolean());
        }
    }
}

