/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.blocks.MaterialCompat;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemPatterns
implements Property {
    public static final String[] handledTags = new String[]{"patterns"};
    public static final String[] handledMechs = new String[]{"patterns"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        if (item instanceof ItemTag) {
            Material material = ((ItemTag)item).getBukkitMaterial();
            return MaterialCompat.isBannerOrShield(material);
        }
        return false;
    }

    public static ItemPatterns getFrom(ObjectTag item) {
        if (!ItemPatterns.describes(item)) {
            return null;
        }
        return new ItemPatterns((ItemTag)item);
    }

    private ItemPatterns(ItemTag item) {
        this.item = item;
    }

    private ListTag listPatterns() {
        ListTag list = new ListTag();
        for (Pattern pattern : this.getPatterns()) {
            list.add(pattern.getColor().name() + "/" + pattern.getPattern().name());
        }
        return list;
    }

    private List<Pattern> getPatterns() {
        ItemMeta itemMeta = this.item.getItemMeta();
        if (itemMeta instanceof BannerMeta) {
            return ((BannerMeta)itemMeta).getPatterns();
        }
        if (itemMeta instanceof BlockStateMeta) {
            return ((Banner)((BlockStateMeta)itemMeta).getBlockState()).getPatterns();
        }
        return new ArrayList<Pattern>();
    }

    private void setPatterns(List<Pattern> patterns) {
        ItemMeta itemMeta = this.item.getItemMeta();
        if (itemMeta instanceof BannerMeta) {
            ((BannerMeta)itemMeta).setPatterns(patterns);
        } else if (itemMeta instanceof BlockStateMeta) {
            try {
                Banner banner = (Banner)((BlockStateMeta)itemMeta).getBlockState();
                banner.setPatterns(patterns);
                banner.update();
                ((BlockStateMeta)itemMeta).setBlockState((BlockState)banner);
            }
            catch (Exception ex) {
                Debug.echoError("Banner setPatterns failed!");
                Debug.echoError(ex);
            }
        }
        this.item.setItemMeta(itemMeta);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("patterns")) {
            return this.listPatterns().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ListTag list = this.listPatterns();
        if (list.isEmpty()) {
            return null;
        }
        return list.identify();
    }

    @Override
    public String getPropertyId() {
        return "patterns";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("patterns")) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            ListTag list = mechanism.valueAsType(ListTag.class);
            for (String string : list) {
                try {
                    List<String> split = CoreUtilities.split(string, '/', 2);
                    patterns.add(new Pattern(DyeColor.valueOf((String)split.get(0).toUpperCase()), PatternType.valueOf((String)split.get(1).toUpperCase())));
                }
                catch (Exception e) {
                    Debug.echoError("Could not apply pattern to banner: " + string);
                }
            }
            this.setPatterns(patterns);
        }
    }
}

