/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizencore.flags.SavableMapFlagTracker;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.Map;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;

public class DenizenFlagsTrait
extends Trait {
    @Persist(value="full_flag_data")
    public SavableMapFlagTracker fullFlagData = new SavableMapFlagTracker();

    public DenizenFlagsTrait() {
        super("denizen_flags");
    }

    static {
        PersistenceLoader.registerPersistDelegate(SavableMapFlagTracker.class, MapTagFlagTrackerPersister.class);
    }

    public static class MapTagFlagTrackerPersister
    implements Persister<SavableMapFlagTracker> {
        public SavableMapFlagTracker create(DataKey dataKey) {
            SavableMapFlagTracker toRet = new SavableMapFlagTracker();
            for (DataKey key : dataKey.getSubKeys()) {
                SavableMapFlagTracker.SaveOptimizedFlag flag = new SavableMapFlagTracker.SaveOptimizedFlag();
                flag.string = key.getString("");
                flag.canExpire = flag.string.startsWith("map@");
                toRet.map.put(new StringHolder(key.name()), flag);
            }
            toRet.doTotalClean();
            return toRet;
        }

        public void save(SavableMapFlagTracker o, DataKey dataKey) {
            for (Map.Entry<StringHolder, SavableMapFlagTracker.SaveOptimizedFlag> flag : o.map.entrySet()) {
                dataKey.setString(flag.getKey().str, flag.getValue().getString());
            }
        }
    }
}

