/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.shaded.redis.clients.jedis.params;

import com.denizenscript.shaded.redis.clients.jedis.Protocol;
import com.denizenscript.shaded.redis.clients.jedis.params.Params;
import com.denizenscript.shaded.redis.clients.jedis.util.SafeEncoder;
import java.util.ArrayList;
import java.util.Collections;

public class XTrimParams
extends Params {
    private Long maxLen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private String minId;
    private Long limit;

    public static XTrimParams xTrimParams() {
        return new XTrimParams();
    }

    public XTrimParams maxLen(long maxLen) {
        this.maxLen = maxLen;
        return this;
    }

    public XTrimParams minId(String minId) {
        this.minId = minId;
        return this;
    }

    public XTrimParams approximateTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XTrimParams exactTrimming() {
        this.exactTrimming = true;
        return this;
    }

    public XTrimParams limit(long limit) {
        this.limit = limit;
        return this;
    }

    public byte[][] getByteParams(byte[] key, byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(key);
        if (this.maxLen != null) {
            byteParams.add(Protocol.Keyword.MAXLEN.getRaw());
            if (this.approximateTrimming) {
                byteParams.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                byteParams.add(Protocol.BYTES_EQUAL);
            }
            byteParams.add(Protocol.toByteArray(this.maxLen));
        } else if (this.minId != null) {
            byteParams.add(Protocol.Keyword.MINID.getRaw());
            if (this.approximateTrimming) {
                byteParams.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                byteParams.add(Protocol.BYTES_EQUAL);
            }
            byteParams.add(SafeEncoder.encode(this.minId));
        }
        if (this.limit != null) {
            byteParams.add(Protocol.Keyword.LIMIT.getRaw());
            byteParams.add(Protocol.toByteArray(this.limit));
        }
        Collections.addAll(byteParams, args);
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

