/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class RomanNumerals {
    public static int romanToArabic(String input) {
        String romanNumeral = input.toUpperCase();
        int result = 0;
        int i = 0;
        List<RomanNumeral> romanNumerals = RomanNumeral.reverseSortedValues;
        while (romanNumeral.length() > 0 && i < romanNumerals.size()) {
            RomanNumeral symbol = romanNumerals.get(i);
            if (romanNumeral.startsWith(symbol.name())) {
                result += symbol.getValue();
                romanNumeral = romanNumeral.substring(symbol.name().length());
                continue;
            }
            ++i;
        }
        if (romanNumeral.length() > 0) {
            return -1;
        }
        return result;
    }

    public static String arabicToRoman(int number) {
        List<RomanNumeral> romanNumerals = RomanNumeral.reverseSortedValues;
        int i = 0;
        StringBuilder sb = new StringBuilder();
        while (number > 0 && i < romanNumerals.size()) {
            RomanNumeral currentSymbol = romanNumerals.get(i);
            if (currentSymbol.getValue() <= number) {
                sb.append(currentSymbol.name());
                number -= currentSymbol.getValue();
                continue;
            }
            ++i;
        }
        return sb.toString();
    }

    static enum RomanNumeral {
        I(1),
        IV(4),
        V(5),
        IX(9),
        X(10),
        XL(40),
        L(50),
        XC(90),
        C(100),
        CD(400),
        D(500),
        CM(900),
        M(1000);

        private final int value;
        public static List<RomanNumeral> reverseSortedValues;

        private RomanNumeral(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            reverseSortedValues = Arrays.stream(RomanNumeral.values()).sorted(Comparator.comparing(e -> e.value).reversed()).collect(Collectors.toList());
        }
    }
}

