/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.blocks;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.flags.MapTagBasedFlagTracker;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.Map;
import org.bukkit.Axis;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rail;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.block.data.type.Wall;

public class FullBlockData {
    public BlockData data;
    public CompoundTag tileEntityData;
    public MapTag flags;

    public FullBlockData(Block block, boolean copyFlags) {
        this(block);
        if (copyFlags) {
            MapTagBasedFlagTracker flagMap = (MapTagBasedFlagTracker)new LocationTag(block.getLocation()).getFlagTracker();
            this.flags = new MapTag();
            for (String flag : flagMap.listAllFlags()) {
                this.flags.putObject(flag, flagMap.getRootMap(flag));
            }
            if (this.flags.map.isEmpty()) {
                this.flags = null;
            }
        }
    }

    public FullBlockData(Block block) {
        this(block.getBlockData());
        this.tileEntityData = NMSHandler.getBlockHelper().getNbtData(block);
    }

    public FullBlockData(BlockData data) {
        this.data = data;
    }

    public FullBlockData(BlockData data, CompoundTag tileEntityData, MapTag flags) {
        this.data = data;
        this.tileEntityData = tileEntityData;
        this.flags = flags;
    }

    public static BlockFace rotateFaceOne(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case NORTH_EAST: {
                return BlockFace.NORTH_WEST;
            }
            case NORTH_WEST: {
                return BlockFace.SOUTH_WEST;
            }
            case SOUTH_WEST: {
                return BlockFace.SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return BlockFace.NORTH_EAST;
            }
            case NORTH_NORTH_EAST: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case NORTH_NORTH_WEST: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case SOUTH_SOUTH_WEST: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case SOUTH_SOUTH_EAST: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case EAST_NORTH_EAST: {
                return BlockFace.NORTH_NORTH_WEST;
            }
            case WEST_NORTH_WEST: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case WEST_SOUTH_WEST: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case EAST_SOUTH_EAST: {
                return BlockFace.NORTH_NORTH_EAST;
            }
        }
        return face;
    }

    public static Rail.Shape rotateRailShapeOne(Rail.Shape shape) {
        switch (shape) {
            case NORTH_SOUTH: {
                return Rail.Shape.EAST_WEST;
            }
            case EAST_WEST: {
                return Rail.Shape.NORTH_SOUTH;
            }
            case ASCENDING_EAST: {
                return Rail.Shape.ASCENDING_NORTH;
            }
            case ASCENDING_WEST: {
                return Rail.Shape.ASCENDING_SOUTH;
            }
            case ASCENDING_NORTH: {
                return Rail.Shape.ASCENDING_WEST;
            }
            case ASCENDING_SOUTH: {
                return Rail.Shape.ASCENDING_EAST;
            }
            case SOUTH_EAST: {
                return Rail.Shape.NORTH_EAST;
            }
            case SOUTH_WEST: {
                return Rail.Shape.SOUTH_EAST;
            }
            case NORTH_WEST: {
                return Rail.Shape.SOUTH_WEST;
            }
            case NORTH_EAST: {
                return Rail.Shape.NORTH_WEST;
            }
        }
        return shape;
    }

    public FullBlockData rotateOne() {
        if (this.data instanceof Orientable) {
            BlockData newData = this.data.clone();
            switch (((Orientable)this.data).getAxis()) {
                case X: {
                    ((Orientable)newData).setAxis(Axis.Z);
                    break;
                }
                case Z: {
                    ((Orientable)newData).setAxis(Axis.X);
                }
            }
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Rotatable) {
            BlockData newData = this.data.clone();
            ((Rotatable)newData).setRotation(FullBlockData.rotateFaceOne(((Rotatable)this.data).getRotation()));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Directional) {
            BlockData newData = this.data.clone();
            ((Directional)newData).setFacing(FullBlockData.rotateFaceOne(((Directional)this.data).getFacing()));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Rail) {
            BlockData newData = this.data.clone();
            ((Rail)newData).setShape(FullBlockData.rotateRailShapeOne(((Rail)this.data).getShape()));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof MultipleFacing) {
            MultipleFacing newData = (MultipleFacing)this.data.clone();
            for (BlockFace face : ((MultipleFacing)this.data).getFaces()) {
                newData.setFace(face, false);
            }
            for (BlockFace face : ((MultipleFacing)this.data).getFaces()) {
                newData.setFace(FullBlockData.rotateFaceOne(face), true);
            }
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof RedstoneWire) {
            RedstoneWire newData = (RedstoneWire)this.data.clone();
            newData.setFace(BlockFace.NORTH, ((RedstoneWire)this.data).getFace(BlockFace.EAST));
            newData.setFace(BlockFace.WEST, ((RedstoneWire)this.data).getFace(BlockFace.NORTH));
            newData.setFace(BlockFace.EAST, ((RedstoneWire)this.data).getFace(BlockFace.SOUTH));
            newData.setFace(BlockFace.SOUTH, ((RedstoneWire)this.data).getFace(BlockFace.WEST));
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_16) && this.data instanceof Wall) {
            Wall newData = (Wall)this.data.clone();
            newData.setHeight(BlockFace.NORTH, ((Wall)this.data).getHeight(BlockFace.EAST));
            newData.setHeight(BlockFace.WEST, ((Wall)this.data).getHeight(BlockFace.NORTH));
            newData.setHeight(BlockFace.EAST, ((Wall)this.data).getHeight(BlockFace.SOUTH));
            newData.setHeight(BlockFace.SOUTH, ((Wall)this.data).getHeight(BlockFace.WEST));
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        return this;
    }

    public void set(Block block, boolean physics) {
        block.setBlockData(this.data, physics);
        if (this.tileEntityData != null) {
            NMSHandler.getBlockHelper().setNbtData(block, this.tileEntityData);
        }
        if (this.flags != null) {
            MapTagBasedFlagTracker flagMap = (MapTagBasedFlagTracker)new LocationTag(block.getLocation()).getFlagTracker();
            for (Map.Entry<StringHolder, ObjectTag> entry : this.flags.map.entrySet()) {
                flagMap.setRootMap(entry.getKey().str, entry.getValue().asType(MapTag.class, CoreUtilities.noDebugContext));
            }
        }
    }
}

