/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;

public interface ObjectTag {
    public String getPrefix();

    default public String debuggable() {
        return this.identify();
    }

    public boolean isUnique();

    public String getObjectType();

    public String identify();

    default public String savable() {
        return this.identify();
    }

    public String identifySimple();

    default public ObjectTag duplicate() {
        return this;
    }

    default public ObjectTag fixAfterProperties() {
        return this;
    }

    public ObjectTag setPrefix(String var1);

    default public Class<? extends ObjectTag> getObjectTagClass() {
        return this.getClass();
    }

    default public <T extends ObjectTag> T asType(Class<T> type, TagContext context) {
        return CoreUtilities.asType(this, type, context);
    }

    default public boolean canBeType(Class<? extends ObjectTag> type) {
        return CoreUtilities.canPossiblyBeType(this, type);
    }

    default public ElementTag asElement() {
        return new ElementTag(this.toString());
    }

    default public ObjectTag getObjectAttribute(Attribute attribute) {
        String res = this.getAttribute(attribute);
        return res == null ? null : new ElementTag(res);
    }

    default public String getAttribute(Attribute attribute) {
        return CoreUtilities.stringifyNullPass(this.getObjectAttribute(attribute));
    }

    default public ObjectTag getNextObjectTypeDown() {
        return new ElementTag(this.identify());
    }

    default public ObjectTag specialTagProcessing(Attribute attribute) {
        return null;
    }

    default public boolean isTruthy() {
        return true;
    }

    default public boolean advancedMatches(String matcher) {
        return ScriptEvent.runGenericCheck(matcher, this.identify());
    }
}

