/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.flags.DataPersistenceFlagTracker;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.MapTagFlagTracker;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import java.util.Collection;

public class EntityFlags
implements Property {
    public static final String[] handledTags = new String[0];
    public static final String[] handledMechs = new String[]{"flag_map"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag;
    }

    public static EntityFlags getFrom(ObjectTag entity) {
        if (!EntityFlags.describes(entity)) {
            return null;
        }
        return new EntityFlags((EntityTag)entity);
    }

    private EntityFlags(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        AbstractFlagTracker tracker = this.entity.getFlagTracker();
        if (!(tracker instanceof DataPersistenceFlagTracker)) {
            return null;
        }
        Collection<String> flagNames = tracker.listAllFlags();
        if (flagNames.isEmpty()) {
            return null;
        }
        MapTag flags = new MapTag();
        for (String name : flagNames) {
            flags.putObject(name, ((DataPersistenceFlagTracker)tracker).getRootMap(name));
        }
        return flags.toString();
    }

    @Override
    public String getPropertyId() {
        return "flag_map";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("flag_map") && mechanism.requireObject(MapTag.class)) {
            MapTagFlagTracker flags = new MapTagFlagTracker(mechanism.valueAsType(MapTag.class));
            AbstractFlagTracker tracker = this.entity.getFlagTracker();
            if (!(tracker instanceof DataPersistenceFlagTracker)) {
                return;
            }
            for (String flagName : flags.map.keys()) {
                ((DataPersistenceFlagTracker)tracker).setRootMap(flagName, flags.getRootMap(flagName));
            }
            this.entity.reapplyTracker(tracker);
        }
    }
}

