/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.MultiVersionHelper1_17;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.BigDripleaf;
import org.bukkit.block.data.type.BubbleColumn;
import org.bukkit.block.data.type.CommandBlock;
import org.bukkit.block.data.type.Comparator;
import org.bukkit.block.data.type.DaylightDetector;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.block.data.type.SculkSensor;
import org.bukkit.block.data.type.StructureBlock;

public class MaterialMode
implements Property {
    public static final String[] handledMechs = new String[]{"mode"};
    public MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData();
        return data instanceof Comparator || data instanceof PistonHead || data instanceof BubbleColumn || data instanceof StructureBlock || data instanceof DaylightDetector || data instanceof CommandBlock || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && (data instanceof SculkSensor || data instanceof BigDripleaf);
    }

    public static MaterialMode getFrom(ObjectTag _material) {
        if (!MaterialMode.describes(_material)) {
            return null;
        }
        return new MaterialMode((MaterialTag)_material);
    }

    private MaterialMode(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(ElementTag.class, "mode", (attribute, material) -> new ElementTag(material.getPropertyString()), new String[0]);
    }

    public boolean isComparator() {
        return this.material.getModernData() instanceof Comparator;
    }

    public boolean isPistonHead() {
        return this.material.getModernData() instanceof PistonHead;
    }

    public boolean isBubbleColumn() {
        return this.material.getModernData() instanceof BubbleColumn;
    }

    public boolean isStructureBlock() {
        return this.material.getModernData() instanceof StructureBlock;
    }

    public boolean isSculkSensor() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && this.material.getModernData() instanceof SculkSensor;
    }

    public boolean isDaylightDetector() {
        return this.material.getModernData() instanceof DaylightDetector;
    }

    public boolean isCommandBlock() {
        return this.material.getModernData() instanceof CommandBlock;
    }

    public boolean isBigDripleaf() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && this.material.getModernData() instanceof BigDripleaf;
    }

    public Comparator getComparator() {
        return (Comparator)this.material.getModernData();
    }

    public PistonHead getPistonHead() {
        return (PistonHead)this.material.getModernData();
    }

    public BubbleColumn getBubbleColumn() {
        return (BubbleColumn)this.material.getModernData();
    }

    public StructureBlock getStructureBlock() {
        return (StructureBlock)this.material.getModernData();
    }

    public DaylightDetector getDaylightDetector() {
        return (DaylightDetector)this.material.getModernData();
    }

    public CommandBlock getCommandBlock() {
        return (CommandBlock)this.material.getModernData();
    }

    @Override
    public String getPropertyString() {
        if (this.isComparator()) {
            return this.getComparator().getMode().name();
        }
        if (this.isBubbleColumn()) {
            return this.getBubbleColumn().isDrag() ? "DRAG" : "NORMAL";
        }
        if (this.isPistonHead()) {
            return this.getPistonHead().isShort() ? "SHORT" : "NORMAL";
        }
        if (this.isStructureBlock()) {
            return this.getStructureBlock().getMode().name();
        }
        if (this.isDaylightDetector()) {
            return this.getDaylightDetector().isInverted() ? "INVERTED" : "NORMAL";
        }
        if (this.isCommandBlock()) {
            return this.getCommandBlock().isConditional() ? "CONDITIONAL" : "NORMAL";
        }
        if (this.isSculkSensor()) {
            return ((SculkSensor)this.material.getModernData()).getPhase().name();
        }
        if (this.isBigDripleaf()) {
            return ((BigDripleaf)this.material.getModernData()).getTilt().name();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "mode";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("mode")) {
            if (this.isComparator() && mechanism.requireEnum(false, (Enum<?>[])Comparator.Mode.values())) {
                this.getComparator().setMode(Comparator.Mode.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (this.isBubbleColumn()) {
                this.getBubbleColumn().setDrag(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "drag"));
            } else if (this.isPistonHead()) {
                this.getPistonHead().setShort(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "short"));
            } else if (this.isStructureBlock() && mechanism.requireEnum(false, (Enum<?>[])StructureBlock.Mode.values())) {
                this.getStructureBlock().setMode(StructureBlock.Mode.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (this.isDaylightDetector()) {
                this.getDaylightDetector().setInverted(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "inverted"));
            } else if (this.isCommandBlock()) {
                this.getCommandBlock().setConditional(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "conditional"));
            } else if (this.isSculkSensor() || this.isBigDripleaf()) {
                MultiVersionHelper1_17.materialModeRunMech(mechanism, this);
            }
        }
    }
}

