/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.interfaces;

import com.denizenscript.denizen.nms.util.BoundingBox;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public abstract class EntityHelper {
    public void setInvisible(Entity entity, boolean invisible) {
    }

    public abstract double getAbsorption(LivingEntity var1);

    public abstract void setAbsorption(LivingEntity var1, double var2);

    public abstract void setSneaking(Entity var1, boolean var2);

    public void setSleeping(Entity player, boolean sleep) {
        throw new UnsupportedOperationException();
    }

    public abstract double getDamageTo(LivingEntity var1, Entity var2);

    public abstract String getRawHoverText(Entity var1);

    public List<String> getDiscoveredRecipes(Player player) {
        throw new UnsupportedOperationException();
    }

    public void setRiptide(Entity entity, boolean state) {
        Debug.echoError("Riptide control not available on this server version.");
    }

    public int getBodyArrows(Entity entity) {
        return ((LivingEntity)entity).getArrowsInBody();
    }

    public void setBodyArrows(Entity entity, int numArrows) {
        ((LivingEntity)entity).setArrowsInBody(numArrows);
    }

    public abstract double getArrowDamage(Entity var1);

    public abstract void setArrowDamage(Entity var1, double var2);

    public abstract String getArrowPickupStatus(Entity var1);

    public abstract void setArrowPickupStatus(Entity var1, String var2);

    public abstract Entity getFishHook(PlayerFishEvent var1);

    public abstract ItemStack getItemFromTrident(Entity var1);

    public abstract void setItemForTrident(Entity var1, ItemStack var2);

    public abstract void forceInteraction(Player var1, Location var2);

    public abstract Entity getEntity(World var1, UUID var2);

    public abstract void setTarget(Creature var1, LivingEntity var2);

    public abstract CompoundTag getNbtData(Entity var1);

    public abstract void setNbtData(Entity var1, CompoundTag var2);

    public abstract void stopFollowing(Entity var1);

    public abstract void stopWalking(Entity var1);

    public abstract double getSpeed(Entity var1);

    public abstract void setSpeed(Entity var1, double var2);

    public abstract void follow(Entity var1, Entity var2, double var3, double var5, double var7, boolean var9, boolean var10);

    public abstract void walkTo(LivingEntity var1, Location var2, Double var3, Runnable var4);

    public abstract void sendHidePacket(Player var1, Entity var2);

    public abstract void sendShowPacket(Player var1, Entity var2);

    public abstract void rotate(Entity var1, float var2, float var3);

    public abstract float getBaseYaw(Entity var1);

    public abstract void look(Entity var1, float var2, float var3);

    public abstract boolean canTrace(World var1, Vector var2, Vector var3);

    public abstract MapTraceResult mapTrace(LivingEntity var1, double var2);

    public Location faceLocation(Location from, Location at) {
        Vector direction = from.toVector().subtract(at.toVector()).normalize();
        Location newLocation = from.clone();
        newLocation.setYaw(180.0f - (float)Math.toDegrees(Math.atan2(direction.getX(), direction.getZ())));
        newLocation.setPitch(90.0f - (float)Math.toDegrees(Math.acos(direction.getY())));
        return newLocation;
    }

    public void faceLocation(Entity from, Location at) {
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        Location origin = from instanceof LivingEntity ? ((LivingEntity)from).getEyeLocation() : new LocationTag(from.getLocation()).getBlockLocation().add(0.5, 0.5, 0.5);
        Location rotated = this.faceLocation(origin, at);
        this.rotate(from, rotated.getYaw(), rotated.getPitch());
    }

    public boolean isFacingLocation(Location from, Location at, float yawLimitDegrees, float pitchLimitDegrees) {
        Vector direction = from.toVector().subtract(at.toVector()).normalize();
        float pitch = 90.0f - (float)Math.toDegrees(Math.acos(direction.getY()));
        if (from.getPitch() > pitch + pitchLimitDegrees || from.getPitch() < pitch - pitchLimitDegrees) {
            return false;
        }
        return this.isFacingLocation(from, at, yawLimitDegrees);
    }

    public boolean isFacingLocation(Location from, Location at, float degreeLimit) {
        double currentYaw = EntityHelper.normalizeYaw(from.getYaw());
        double requiredYaw = EntityHelper.normalizeYaw(this.getYaw(at.toVector().subtract(from.toVector()).normalize()));
        return Math.abs(requiredYaw - currentYaw) < (double)degreeLimit || Math.abs(requiredYaw + 360.0 - currentYaw) < (double)degreeLimit || Math.abs(currentYaw + 360.0 - requiredYaw) < (double)degreeLimit;
    }

    public boolean isFacingLocation(Entity from, Location at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at, degreeLimit);
    }

    public boolean isFacingEntity(Entity from, Entity at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at.getLocation(), degreeLimit);
    }

    public static float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw = (float)((double)yaw + 360.0);
        }
        return yaw;
    }

    public float getYaw(Vector vector) {
        double dx = vector.getX();
        double dz = vector.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI);
    }

    public String getCardinal(float yaw) {
        if (0.0f <= (yaw = EntityHelper.normalizeYaw(yaw)) && (double)yaw < 22.5) {
            return "south";
        }
        if (22.5 <= (double)yaw && (double)yaw < 67.5) {
            return "southwest";
        }
        if (67.5 <= (double)yaw && (double)yaw < 112.5) {
            return "west";
        }
        if (112.5 <= (double)yaw && (double)yaw < 157.5) {
            return "northwest";
        }
        if (157.5 <= (double)yaw && (double)yaw < 202.5) {
            return "north";
        }
        if (202.5 <= (double)yaw && (double)yaw < 247.5) {
            return "northeast";
        }
        if (247.5 <= (double)yaw && (double)yaw < 292.5) {
            return "east";
        }
        if (292.5 <= (double)yaw && (double)yaw < 337.5) {
            return "southeast";
        }
        if (337.5 <= (double)yaw && (double)yaw < 360.0) {
            return "south";
        }
        return null;
    }

    public abstract void snapPositionTo(Entity var1, Vector var2);

    public abstract void move(Entity var1, Vector var2);

    public abstract void teleport(Entity var1, Location var2);

    public abstract BoundingBox getBoundingBox(Entity var1);

    public abstract void setBoundingBox(Entity var1, BoundingBox var2);

    public abstract boolean isChestedHorse(Entity var1);

    public abstract boolean isCarryingChest(Entity var1);

    public abstract void setCarryingChest(Entity var1, boolean var2);

    public List<Player> getPlayersThatSee(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public void setTicksLived(Entity entity, int ticks) {
        entity.setTicksLived(ticks);
    }

    public int getShulkerPeek(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public void setShulkerPeek(Entity entity, int peek) {
        throw new UnsupportedOperationException();
    }

    public void setHeadAngle(Entity entity, float angle) {
        throw new UnsupportedOperationException();
    }

    public void setGhastAttacking(Entity entity, boolean attacking) {
        throw new UnsupportedOperationException();
    }

    public void setEndermanAngry(Entity entity, boolean angry) {
        throw new UnsupportedOperationException();
    }

    public static EntityDamageEvent fireFakeDamageEvent(Entity target, Entity source, EntityDamageEvent.DamageCause cause, float amount) {
        EntityDamageEvent ede = source == null ? new EntityDamageEvent(target, cause, (double)amount) : new EntityDamageByEntityEvent(source, target, cause, (double)amount);
        Bukkit.getPluginManager().callEvent((Event)ede);
        return ede;
    }

    public void damage(LivingEntity target, float amount, Entity source, EntityDamageEvent.DamageCause cause) {
        if (cause == null) {
            if (source == null) {
                target.damage((double)amount);
            } else {
                target.damage((double)amount, source);
            }
        } else {
            EntityDamageEvent ede = EntityHelper.fireFakeDamageEvent((Entity)target, source, cause, amount);
            if (!ede.isCancelled()) {
                target.setLastDamageCause(ede);
                if (source == null) {
                    target.damage(ede.getFinalDamage());
                } else {
                    target.damage(ede.getFinalDamage(), source);
                }
                target.setLastDamageCause(ede);
            }
        }
    }

    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        throw new UnsupportedOperationException();
    }

    public void setFallingBlockType(FallingBlock entity, BlockData block) {
        throw new UnsupportedOperationException();
    }

    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        throw new UnsupportedOperationException();
    }

    public void setFireworkLifetime(Firework firework, int ticks) {
        throw new UnsupportedOperationException();
    }

    public int getFireworkLifetime(Firework firework) {
        throw new UnsupportedOperationException();
    }

    public int getInWaterTime(Zombie zombie) {
        throw new UnsupportedOperationException();
    }

    public void setInWaterTime(Zombie zombie, int ticks) {
        throw new UnsupportedOperationException();
    }

    public static class MapTraceResult {
        public Location hitLocation;
        public BlockFace angle;
    }
}

