/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InteractScriptContainer
extends ScriptContainer {
    private String defaultStep = null;
    private List<String> steps = new ArrayList<String>();

    public InteractScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        try {
            Set<StringHolder> keys = this.getConfigurationSection("steps").getKeys(false);
            if (this.contains("requirements", Object.class)) {
                Debug.echoError("Interact script '" + this.getName() + "' is outdated: 'requirements' do not exist in modern Denizen!");
            }
            if (keys.isEmpty()) {
                throw new ExceptionInInitializerError("Could not find any STEPS in " + this.getName() + "! Is the type on this script correct?");
            }
            for (StringHolder step1 : keys) {
                String step = step1.str;
                if (step.contains("*")) {
                    YamlConfiguration defaultStepSection = this.getConfigurationSection("steps." + step);
                    step = step.replace("*", "");
                    this.set("steps." + step, defaultStepSection);
                    this.set("steps." + step + "*", null);
                    this.defaultStep = step;
                }
                if (step.equalsIgnoreCase("1")) {
                    this.defaultStep = step;
                }
                if (step.equalsIgnoreCase("default")) {
                    this.defaultStep = step;
                }
                this.steps.add(step);
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        if (this.defaultStep == null && this.steps.size() == 1) {
            this.defaultStep = this.steps.get(0);
        }
        if (this.defaultStep == null) {
            throw new ExceptionInInitializerError("Must specify a default step in '" + this.getName() + "'!");
        }
    }

    public String getDefaultStepName() {
        return this.defaultStep;
    }

    public boolean containsTriggerInStep(String step, Class<? extends AbstractTrigger> trigger) {
        String triggerName = Denizen.getInstance().triggerRegistry.get(trigger).getName();
        return this.contains("steps." + step + "." + triggerName + " trigger", Map.class);
    }

    public List<ScriptEntry> getEntriesFor(Class<? extends AbstractTrigger> trigger, PlayerTag player, NPCTag npc, String id, boolean quiet) {
        String triggerName = Denizen.getInstance().triggerRegistry.get(trigger).getName();
        String key = "steps." + InteractScriptHelper.getCurrentStep(player, this.getName()) + "." + triggerName + " trigger." + (id == null ? "script" : id + ".script");
        if (this.containsScriptSection(key)) {
            return this.getEntries(new BukkitScriptEntryData(player, npc), key);
        }
        if (!quiet) {
            Debug.echoDebug((Debuggable)this, "No entries in script for " + key);
        }
        return Collections.emptyList();
    }

    public Map<String, String> getIdMapFor(Class<? extends AbstractTrigger> trigger, PlayerTag player) {
        String triggerName = Denizen.getInstance().triggerRegistry.get(trigger).getName();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        String keyBase = "steps." + step + "." + triggerName + " trigger";
        if (this.contains(keyBase, Map.class)) {
            LinkedHashMap<String, String> idMap = new LinkedHashMap<String, String>();
            try {
                for (StringHolder id : this.getConfigurationSection(keyBase).getKeys(false)) {
                    if (id.str.equalsIgnoreCase("script")) continue;
                    idMap.put(id.str, this.getString(keyBase + "." + id.str + ".trigger", ""));
                }
            }
            catch (Exception ex) {
                Debug.echoError("Warning: improperly defined " + trigger.getSimpleName() + " trigger for script '" + this.getName() + "' (basic formatting error?)!");
                Debug.echoError(ex);
            }
            return idMap;
        }
        return Collections.emptyMap();
    }
}

