/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.item.ItemPotion;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.entity.Arrow;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EntityPotionEffects
implements Property {
    public static final String[] handledTags = new String[]{"list_effects", "has_effect"};
    public static final String[] handledMechs = new String[]{"potion_effects"};
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        if (!(object instanceof EntityTag)) {
            return false;
        }
        return ((EntityTag)object).isLivingEntity() || ((EntityTag)object).getBukkitEntity() instanceof Arrow;
    }

    public static EntityPotionEffects getFrom(ObjectTag object) {
        if (!EntityPotionEffects.describes(object)) {
            return null;
        }
        return new EntityPotionEffects((EntityTag)object);
    }

    private EntityPotionEffects(EntityTag entity) {
        this.entity = entity;
    }

    public Collection<PotionEffect> getEffectsList() {
        if (this.entity.isLivingEntity()) {
            return this.entity.getLivingEntity().getActivePotionEffects();
        }
        if (this.entity.getBukkitEntity() instanceof Arrow) {
            return ((Arrow)this.entity.getBukkitEntity()).getCustomEffects();
        }
        return new ArrayList<PotionEffect>();
    }

    @Override
    public String getPropertyString() {
        Collection<PotionEffect> effects = this.getEffectsList();
        if (effects.isEmpty()) {
            return null;
        }
        ListTag returnable = new ListTag();
        for (PotionEffect effect : effects) {
            returnable.add(ItemPotion.stringifyEffect(effect));
        }
        return returnable.identify();
    }

    @Override
    public String getPropertyId() {
        return "potion_effects";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("list_effects")) {
            ListTag effects = new ListTag();
            for (PotionEffect effect : this.getEffectsList()) {
                effects.add(ItemPotion.stringifyEffect(effect));
            }
            return effects.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_effect")) {
            boolean returnElement = false;
            if (attribute.hasParam()) {
                PotionEffectType effectType = PotionEffectType.getByName((String)attribute.getParam());
                for (PotionEffect effect : this.getEffectsList()) {
                    if (!effect.getType().equals((Object)effectType)) continue;
                    returnElement = true;
                }
            } else if (!this.getEffectsList().isEmpty()) {
                returnElement = true;
            }
            return new ElementTag(returnElement).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("potion_effects")) {
            ListTag effects = ListTag.valueOf(mechanism.getValue().asString(), mechanism.context);
            for (String effectStr : effects) {
                PotionEffect effect = ItemPotion.parseEffect(effectStr, mechanism.context);
                if (effect == null) {
                    mechanism.echoError("Invalid potion effect '" + effectStr + "'");
                    continue;
                }
                if (this.entity.isLivingEntity()) {
                    this.entity.getLivingEntity().addPotionEffect(effect);
                    continue;
                }
                if (!(this.entity.getBukkitEntity() instanceof Arrow)) continue;
                ((Arrow)this.entity.getBukkitEntity()).addCustomEffect(effect, true);
            }
        }
    }
}

