/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.triggers.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ProximityTrigger
extends AbstractTrigger
implements Listener {
    private static int maxProximityDistance = 75;
    int taskID = -1;
    private static Map<UUID, Set<Integer>> proximityTracker = new HashMap<UUID, Set<Integer>>();

    @Override
    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
        ProximityTrigger trigger = this;
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Denizen.getInstance(), () -> {
            Collection allPlayers = Bukkit.getOnlinePlayers();
            for (NPC citizensNPC : CitizensAPI.getNPCRegistry()) {
                if (citizensNPC == null || !citizensNPC.isSpawned() || !citizensNPC.hasTrait(TriggerTrait.class) || !((TriggerTrait)citizensNPC.getOrAddTrait(TriggerTrait.class)).isEnabled(this.name)) continue;
                NPCTag npc = new NPCTag(citizensNPC);
                TriggerTrait triggerTrait = npc.getTriggerTrait();
                for (Player bukkitPlayer : allPlayers) {
                    if (!npc.getWorld().equals(bukkitPlayer.getWorld()) && this.hasExitedProximityOf(bukkitPlayer, npc) || !this.isCloseEnough(bukkitPlayer, npc) && this.hasExitedProximityOf(bukkitPlayer, npc)) continue;
                    PlayerTag player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)bukkitPlayer);
                    double entryRadius = triggerTrait.getRadius(this.name);
                    double exitRadius = triggerTrait.getRadius(this.name);
                    double moveRadius = triggerTrait.getRadius(this.name);
                    LocationTag npcLocation = npc.getLocation();
                    boolean playerChangedWorlds = false;
                    if (npcLocation.getWorld() != player.getWorld()) {
                        playerChangedWorlds = true;
                    }
                    boolean exitedProximity = this.hasExitedProximityOf(bukkitPlayer, npc);
                    double distance = 0.0;
                    if (!playerChangedWorlds) {
                        distance = npcLocation.distance(player.getLocation());
                    }
                    if (!exitedProximity && (playerChangedWorlds || distance >= exitRadius)) {
                        if (!triggerTrait.triggerCooldownOnly(trigger, player)) continue;
                        this.exitProximityOf(bukkitPlayer, npc);
                        npc.action("exit proximity", player);
                        this.parseAll(npc, player, "EXIT");
                        continue;
                    }
                    if (exitedProximity && distance <= entryRadius) {
                        if (!triggerTrait.triggerCooldownOnly(trigger, player)) continue;
                        this.enterProximityOf(bukkitPlayer, npc);
                        npc.action("enter proximity", player);
                        this.parseAll(npc, player, "ENTRY");
                        continue;
                    }
                    if (exitedProximity || !(distance <= moveRadius)) continue;
                    npc.action("move proximity", player);
                    this.parseAll(npc, player, "MOVE");
                }
            }
        }, 5L, 5L);
    }

    public void parseAll(NPCTag npc, PlayerTag player, String id) {
        List<InteractScriptContainer> scripts = npc.getInteractScriptsQuietly(player, ProximityTrigger.class);
        if (scripts != null) {
            for (InteractScriptContainer container : scripts) {
                this.parse(npc, player, container, id);
            }
        }
    }

    @Override
    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.taskID);
    }

    private boolean isCloseEnough(Player player, NPCTag npc) {
        Location pLoc = player.getLocation();
        LocationTag nLoc = npc.getLocation();
        if (Math.abs(pLoc.getX() - nLoc.getX()) > (double)maxProximityDistance) {
            return false;
        }
        if (Math.abs(pLoc.getY() - nLoc.getY()) > (double)maxProximityDistance) {
            return false;
        }
        return !(Math.abs(pLoc.getZ() - nLoc.getZ()) > (double)maxProximityDistance);
    }

    private boolean hasExitedProximityOf(Player player, NPCTag npc) {
        Set<Integer> existing = proximityTracker.get(player.getUniqueId());
        if (existing == null) {
            return true;
        }
        return !existing.contains(npc.getId());
    }

    private void enterProximityOf(Player player, NPCTag npc) {
        Set npcs = proximityTracker.computeIfAbsent(player.getUniqueId(), k -> new HashSet());
        npcs.add(npc.getId());
    }

    private void exitProximityOf(Player player, NPCTag npc) {
        Set npcs = proximityTracker.computeIfAbsent(player.getUniqueId(), k -> new HashSet());
        npcs.remove(npc.getId());
    }
}

