/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemPotion
implements Property {
    public static final String[] handledMechs = new String[]{"potion_effects"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemMeta() instanceof PotionMeta;
    }

    public static ItemPotion getFrom(ObjectTag _item) {
        if (!ItemPotion.describes(_item)) {
            return null;
        }
        return new ItemPotion((ItemTag)_item);
    }

    private ItemPotion(ItemTag item) {
        this.item = item;
    }

    public static String stringifyEffect(PotionEffect effect) {
        return effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration() + "," + effect.isAmbient() + "," + effect.hasParticles() + "," + effect.hasIcon();
    }

    public static MapTag effectToMap(PotionEffect effect) {
        MapTag map = new MapTag();
        map.putObject("type", new ElementTag(effect.getType().getName()));
        map.putObject("amplifier", new ElementTag(effect.getAmplifier()));
        map.putObject("duration", new DurationTag((long)effect.getDuration()));
        map.putObject("ambient", new ElementTag(effect.isAmbient()));
        map.putObject("particles", new ElementTag(effect.hasParticles()));
        map.putObject("icon", new ElementTag(effect.hasIcon()));
        return map;
    }

    public ListTag getMapTagData() {
        ListTag result = new ListTag();
        MapTag base = new MapTag();
        PotionMeta meta = this.getMeta();
        base.putObject("type", new ElementTag(meta.getBasePotionData().getType().name()));
        base.putObject("upgraded", new ElementTag(meta.getBasePotionData().isUpgraded()));
        base.putObject("extended", new ElementTag(meta.getBasePotionData().isExtended()));
        if (meta.hasColor()) {
            base.putObject("color", new ColorTag(meta.getColor()));
        }
        result.addObject(base);
        for (PotionEffect effect : meta.getCustomEffects()) {
            result.addObject(ItemPotion.effectToMap(effect));
        }
        return result;
    }

    public static PotionEffect parseEffect(String str, TagContext context) {
        ElementTag check;
        PotionEffectType type;
        String[] d2 = str.split(",");
        try {
            type = PotionEffectType.getByName((String)d2[0].toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            if (context.showErrors()) {
                Debug.echoError("Invalid potion effect type '" + d2[0] + "'");
            }
            return null;
        }
        if (d2.length < 3) {
            return null;
        }
        int duration = new ElementTag(d2[2]).asInt();
        int amplifier = new ElementTag(d2[1]).asInt();
        boolean ambient = true;
        boolean particles = true;
        if (d2.length > 3) {
            ambient = new ElementTag(d2[3]).asBoolean();
            particles = new ElementTag(d2[4]).asBoolean();
        }
        boolean icon = false;
        if (d2.length > 5 && (check = new ElementTag(d2[5])).isBoolean()) {
            icon = check.asBoolean();
        }
        return new PotionEffect(type, duration, amplifier, ambient, particles, icon);
    }

    public static PotionEffect parseEffect(MapTag effectMap, TagContext context) {
        PotionEffectType type;
        DurationTag duration = new DurationTag(0);
        int amplifier = 0;
        boolean ambient = true;
        boolean particles = true;
        boolean icon = false;
        if (effectMap.getObject("type") != null) {
            String typeString = effectMap.getObject("type").toString();
            type = PotionEffectType.getByName((String)typeString);
            if (type == null) {
                if (context.showErrors()) {
                    Debug.echoError("Invalid potion effect type '" + typeString + "': effect type is required.");
                }
                return null;
            }
        } else {
            if (context.showErrors()) {
                Debug.echoError("Invalid potion effect type: effect type is required.");
            }
            return null;
        }
        if (effectMap.getObject("amplifier") != null) {
            ElementTag amplifierElement = effectMap.getObject("amplifier").asElement();
            if (amplifierElement.isInt()) {
                amplifier = amplifierElement.asInt();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid amplifier '" + amplifierElement + "': must be an integer.");
            }
        }
        if (effectMap.getObject("duration") != null) {
            ObjectTag durationObj = effectMap.getObject("duration");
            if (durationObj.canBeType(DurationTag.class)) {
                duration = durationObj.asType(DurationTag.class, context);
            } else if (context.showErrors()) {
                Debug.echoError("Invalid duration '" + durationObj + "': must be a valid DurationTag");
            }
        }
        if (effectMap.getObject("ambient") != null) {
            ElementTag ambientElement = effectMap.getObject("ambient").asElement();
            if (ambientElement.isBoolean()) {
                ambient = ambientElement.asBoolean();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid ambient state '" + ambientElement + "': must be a boolean.");
            }
        }
        if (effectMap.getObject("particles") != null) {
            ElementTag particlesElement = effectMap.getObject("particles").asElement();
            if (particlesElement.isBoolean()) {
                particles = particlesElement.asBoolean();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid particles state '" + particlesElement + "': must be a boolean.");
            }
        }
        if (effectMap.getObject("icon") != null) {
            ElementTag iconElement = effectMap.getObject("icon").asElement();
            if (iconElement.isBoolean()) {
                icon = iconElement.asBoolean();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid icon state '" + iconElement + "': must be a boolean.");
            }
        }
        return new PotionEffect(type, duration.getTicksAsInt(), amplifier, ambient, particles, icon);
    }

    public PotionMeta getMeta() {
        return (PotionMeta)this.item.getItemMeta();
    }

    @Override
    public String getPropertyString() {
        return this.getMapTagData().identify();
    }

    @Override
    public String getPropertyId() {
        return "potion_effects";
    }

    public static void registerTags() {
        PropertyParser.registerTag(ElementTag.class, "potion_base_type", (attribute, object) -> new ElementTag(object.getMeta().getBasePotionData().getType().name()), new String[0]);
        PropertyParser.registerTag(ElementTag.class, "potion_base", (attribute, object) -> {
            PotionMeta meta = object.getMeta();
            return new ElementTag(meta.getBasePotionData().getType().name() + "," + (meta.getBasePotionData().isUpgraded() ? 2 : 1) + "," + meta.getBasePotionData().isExtended() + "," + (object.item.getBukkitMaterial() == Material.SPLASH_POTION) + (meta.hasColor() ? "," + new ColorTag(meta.getColor()).identify() : ""));
        }, new String[0]);
        PropertyParser.registerTag(ListTag.class, "potion_effects", (attribute, object) -> {
            ListTag result = new ListTag();
            for (PotionEffect pot : object.getMeta().getCustomEffects()) {
                result.add(ItemPotion.stringifyEffect(pot));
            }
            return result;
        }, new String[0]);
        PropertyParser.registerTag(ElementTag.class, "has_potion_effect", (attribute, object) -> new ElementTag(object.getMeta().hasCustomEffects()), new String[0]);
        PropertyParser.registerTag(ElementTag.class, "potion_effect", (attribute, object) -> {
            int potN;
            PotionMeta meta = object.getMeta();
            int n = potN = attribute.hasParam() ? attribute.getIntParam() - 1 : 0;
            if (potN < 0 || potN > meta.getCustomEffects().size()) {
                return null;
            }
            if (attribute.startsWith("is_splash", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.item.getBukkitMaterial() == Material.SPLASH_POTION);
            }
            if (attribute.startsWith("is_extended", 2)) {
                attribute.fulfill(1);
                return new ElementTag(meta.getBasePotionData().isExtended());
            }
            if (attribute.startsWith("level", 2)) {
                attribute.fulfill(1);
                return new ElementTag(meta.getBasePotionData().isUpgraded() ? 2 : 1);
            }
            if (attribute.startsWith("is_ambient", 2)) {
                attribute.fulfill(1);
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).isAmbient());
            }
            if (attribute.startsWith("icon", 2)) {
                attribute.fulfill(1);
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).hasIcon());
            }
            if (attribute.startsWith("has_particles", 2)) {
                attribute.fulfill(1);
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).hasParticles());
            }
            if (attribute.startsWith("duration", 2)) {
                attribute.fulfill(1);
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).getDuration());
            }
            if (attribute.startsWith("amplifier", 2)) {
                attribute.fulfill(1);
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).getAmplifier());
            }
            if (attribute.startsWith("type", 2)) {
                attribute.fulfill(1);
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).getType().getName());
            }
            if (attribute.startsWith("data", 2)) {
                attribute.fulfill(1);
                return new ElementTag(0);
            }
            PotionData data = meta.getBasePotionData();
            return new ElementTag(data.getType().name() + "," + (data.isUpgraded() ? 2 : 1) + "," + data.isExtended() + "," + (object.item.getBukkitMaterial() == Material.SPLASH_POTION));
        }, new String[0]);
        PropertyParser.registerTag(ListTag.class, "effects_data", (attribute, object) -> object.getMapTagData(), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("potion_effects")) {
            PotionType type;
            ArrayList<ObjectTag> data = new ArrayList<ObjectTag>(CoreUtilities.objectToList(mechanism.value, mechanism.context));
            ObjectTag firstObj = (ObjectTag)data.remove(0);
            PotionMeta meta = this.getMeta();
            boolean upgraded = false;
            boolean extended = false;
            ColorTag color = null;
            if (firstObj.canBeType(MapTag.class)) {
                ElementTag typeElement;
                MapTag baseEffect = firstObj.asType(MapTag.class, mechanism.context);
                if (baseEffect.getObject("type") != null) {
                    typeElement = baseEffect.getObject("type").asElement();
                    if (!typeElement.matchesEnum(PotionType.class)) {
                        mechanism.echoError("Invalid base potion type '" + typeElement + "': type is required");
                        return;
                    }
                } else {
                    mechanism.echoError("No base potion type specified: type is required");
                    return;
                }
                type = PotionType.valueOf((String)typeElement.asString().toUpperCase());
                if (baseEffect.getObject("upgraded") != null) {
                    ElementTag upgradedElement = baseEffect.getObject("upgraded").asElement();
                    if (upgradedElement.isBoolean()) {
                        upgraded = upgradedElement.asBoolean();
                    } else {
                        mechanism.echoError("Invalid upgraded state '" + upgradedElement + "': must be a boolean");
                    }
                }
                if (baseEffect.getObject("extended") != null) {
                    ElementTag extendedElement = baseEffect.getObject("extended").asElement();
                    if (extendedElement.isBoolean()) {
                        extended = extendedElement.asBoolean();
                    } else {
                        mechanism.echoError("Invalid extended state '" + extendedElement + "': must be a boolean");
                    }
                }
                if (baseEffect.getObject("color") != null) {
                    ObjectTag colorObj = baseEffect.getObject("color");
                    if (colorObj.canBeType(ColorTag.class)) {
                        color = colorObj.asType(ColorTag.class, mechanism.context);
                    } else {
                        mechanism.echoError("Invalid color '" + colorObj + "': must be a valid ColorTag");
                    }
                }
            } else {
                String[] d1 = firstObj.toString().split(",");
                try {
                    type = PotionType.valueOf((String)d1[0].toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    mechanism.echoError("Invalid base potion type '" + d1[0] + "': type is required");
                    return;
                }
                upgraded = CoreUtilities.equalsIgnoreCase(d1[1], "true");
                extended = CoreUtilities.equalsIgnoreCase(d1[2], "true");
                if (d1.length > 3) {
                    ColorTag temp = ColorTag.valueOf(d1[3].replace("&comma", ","), mechanism.context);
                    if (temp == null) {
                        mechanism.echoError("Invalid color '" + d1[3] + "': must be a valid ColorTag");
                    } else {
                        color = temp;
                    }
                }
            }
            if (upgraded && !type.isUpgradeable()) {
                mechanism.echoError("Cannot upgrade potion of type '" + type.name() + "'");
                upgraded = false;
            }
            if (extended && !type.isExtendable()) {
                mechanism.echoError("Cannot extend potion of type '" + type.name() + "'");
                extended = false;
            }
            if (upgraded && extended) {
                mechanism.echoError("Cannot both upgrade and extend a potion");
                extended = false;
            }
            if (color != null) {
                meta.setColor(color.getColor());
            }
            meta.setBasePotionData(new PotionData(type, extended, upgraded));
            meta.clearCustomEffects();
            for (ObjectTag effectObj : data) {
                PotionEffect effect = effectObj.canBeType(MapTag.class) ? ItemPotion.parseEffect(effectObj.asType(MapTag.class, mechanism.context), mechanism.context) : ItemPotion.parseEffect(effectObj.toString(), mechanism.context);
                if (effect != null) {
                    meta.addCustomEffect(effect, false);
                    continue;
                }
                mechanism.echoError("Invalid potion effect '" + effectObj + "'");
            }
            this.item.setItemMeta((ItemMeta)meta);
        }
    }
}

