/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.impl.network.handlers;

import com.denizenscript.denizen.events.player.PlayerHearsSoundScriptEvent;
import com.denizenscript.denizen.events.player.PlayerReceivesActionbarScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.v1_18.Handler;
import com.denizenscript.denizen.nms.v1_18.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_18.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_18.impl.blocks.BlockLightImpl;
import com.denizenscript.denizen.nms.v1_18.impl.entities.EntityFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_18.impl.network.handlers.DenizenPacketListenerImpl;
import com.denizenscript.denizen.nms.v1_18.impl.network.handlers.FakeBlockHelper;
import com.denizenscript.denizen.nms.v1_18.impl.network.packets.PacketOutChatImpl;
import com.denizenscript.denizen.nms.v1_18.impl.network.packets.PacketOutEntityMetadataImpl;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.entity.FakeEquipCommand;
import com.denizenscript.denizen.scripts.commands.entity.RenameCommand;
import com.denizenscript.denizen.scripts.commands.entity.SneakCommand;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.blocks.ChunkCoordinate;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizen.utilities.entity.HideEntitiesHelper;
import com.denizenscript.denizen.utilities.packets.DenizenPacketHandler;
import com.denizenscript.denizen.utilities.packets.HideParticles;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreak;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutChat;
import net.minecraft.network.protocol.game.PacketPlayOutCustomSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityPainting;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DenizenNetworkManagerImpl
extends NetworkManager {
    public final NetworkManager oldManager;
    public final DenizenPacketListenerImpl packetListener;
    public final EntityPlayer player;
    public int packetsSent;
    public int packetsReceived;
    public static Field ENTITY_ID_PACKVELENT = ReflectionHelper.getFields(PacketPlayOutEntityVelocity.class).get(ReflectionMappingsInfo.ClientboundSetEntityMotionPacket_id);
    public static Field ENTITY_ID_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_id);
    public static Field POS_X_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_x);
    public static Field POS_Y_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_y);
    public static Field POS_Z_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_z);
    public static Field YAW_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_yRot);
    public static Field PITCH_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_xRot);
    public static Field POS_X_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_xa);
    public static Field POS_Y_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_ya);
    public static Field POS_Z_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_za);
    public static Field YAW_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_yRot);
    public static Field PITCH_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_xRot);
    public static Field SECTIONPOS_MULTIBLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get(ReflectionMappingsInfo.ClientboundSectionBlocksUpdatePacket_sectionPos);
    public static Field OFFSETARRAY_MULTIBLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get(ReflectionMappingsInfo.ClientboundSectionBlocksUpdatePacket_positions);
    public static Field BLOCKARRAY_MULTIBLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get(ReflectionMappingsInfo.ClientboundSectionBlocksUpdatePacket_states);
    public static Field ENTITY_METADATA_LIST = ReflectionHelper.getFields(PacketPlayOutEntityMetadata.class).get(ReflectionMappingsInfo.ClientboundSetEntityDataPacket_packedItems);
    private boolean antiDuplicate = false;
    public static Vector VECTOR_ZERO = new Vector(0, 0, 0);
    private static final Field protocolDirectionField;
    private static final MethodHandle networkManagerField;

    public static PacketDataSerializer copyPacket(Packet<?> original) {
        try {
            PacketDataSerializer copier = new PacketDataSerializer(Unpooled.buffer());
            original.a(copier);
            return copier;
        }
        catch (Throwable ex) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError(ex);
            return null;
        }
    }

    public DenizenNetworkManagerImpl(EntityPlayer entityPlayer, NetworkManager oldManager) {
        super(DenizenNetworkManagerImpl.getProtocolDirection(oldManager));
        this.oldManager = oldManager;
        this.k = oldManager.k;
        this.packetListener = new DenizenPacketListenerImpl(this, entityPlayer);
        oldManager.a((PacketListener)this.packetListener);
        this.player = this.packetListener.b;
    }

    public static void setNetworkManager(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        PlayerConnection playerConnection = entityPlayer.b;
        DenizenNetworkManagerImpl.setNetworkManager(playerConnection, new DenizenNetworkManagerImpl(entityPlayer, playerConnection.a));
    }

    public static void enableNetworkManager() {
        for (World w : Bukkit.getWorlds()) {
            for (PlayerChunkMap.EntityTracker tracker : ((CraftWorld)w).getHandle().k().a.I.values()) {
                ArrayList connections = new ArrayList(tracker.f);
                tracker.f.clear();
                for (ServerPlayerConnection connection : connections) {
                    tracker.f.add(connection.d().b);
                }
            }
        }
    }

    public int hashCode() {
        return this.oldManager.hashCode();
    }

    public boolean equals(Object c2) {
        return this.oldManager.equals(c2);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelUnregistered(ctx);
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelActive(channelhandlercontext);
    }

    public void a(EnumProtocol enumprotocol) {
        this.oldManager.a(enumprotocol);
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.oldManager.channelInactive(channelhandlercontext);
    }

    public boolean isSharable() {
        return this.oldManager.isSharable();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.handlerRemoved(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        this.oldManager.exceptionCaught(channelhandlercontext, throwable);
    }

    protected void a(ChannelHandlerContext channelhandlercontext, Packet packet) {
        if (this.oldManager.k.isOpen()) {
            try {
                packet.a((PacketListener)this.packetListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void a(PacketListener packetlistener) {
        this.oldManager.a(packetlistener);
    }

    public void a(Packet<?> packet) {
        this.a(packet, null);
    }

    public static void doPacketOutput(String text) {
        if (!NMSHandler.debugPackets) {
            return;
        }
        if (NMSHandler.debugPacketFilter == null || NMSHandler.debugPacketFilter.trim().isEmpty() || CoreUtilities.toLowerCase(text).contains(NMSHandler.debugPacketFilter)) {
            Debug.log(text);
        }
    }

    public void debugOutputPacket(Packet<?> packet) {
        if (packet instanceof PacketPlayOutEntityMetadata) {
            StringBuilder output = new StringBuilder(128);
            output.append("Packet: ClientboundSetEntityDataPacket sent to ").append(this.player.co()).append(" for entity ID: ").append(((PacketPlayOutEntityMetadata)packet).c()).append(": ");
            List list = ((PacketPlayOutEntityMetadata)packet).b();
            if (list == null) {
                output.append("None");
            } else {
                for (DataWatcher.Item data : list) {
                    output.append('[').append(data.a().a()).append(": ").append(data.b()).append("], ");
                }
            }
            DenizenNetworkManagerImpl.doPacketOutput(output.toString());
        } else if (packet instanceof PacketPlayOutEntityVelocity) {
            PacketPlayOutEntityVelocity velPacket = (PacketPlayOutEntityVelocity)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundSetEntityMotionPacket sent to " + this.player.co() + " for entity ID: " + velPacket.b() + ": " + velPacket.c() + "," + velPacket.d() + "," + velPacket.e());
        } else if (packet instanceof PacketPlayOutSpawnEntity) {
            PacketPlayOutSpawnEntity addEntityPacket = (PacketPlayOutSpawnEntity)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundAddEntityPacket sent to " + this.player.co() + " for entity ID: " + addEntityPacket.b() + ": uuid: " + addEntityPacket.c() + ", type: " + addEntityPacket.l() + ", at: " + addEntityPacket.d() + "," + addEntityPacket.e() + "," + addEntityPacket.f() + ", data: " + addEntityPacket.m());
        } else if (packet instanceof PacketPlayOutMap) {
            PacketPlayOutMap mapPacket = (PacketPlayOutMap)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundMapItemDataPacket sent to " + this.player.co() + " for map ID: " + mapPacket.b() + ", scale: " + mapPacket.c() + ", locked: " + mapPacket.d());
        } else if (packet instanceof PacketPlayOutEntityDestroy) {
            PacketPlayOutEntityDestroy removePacket = (PacketPlayOutEntityDestroy)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundRemoveEntitiesPacket sent to " + this.player.co() + " for entities: " + removePacket.b().stream().map(Object::toString).collect(Collectors.joining(", ")));
        } else {
            DenizenNetworkManagerImpl.doPacketOutput("Packet: " + packet.getClass().getCanonicalName() + " sent to " + this.player.co());
        }
    }

    public void a(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (!Bukkit.isPrimaryThread()) {
            if (Settings.cache_warnOnAsyncPackets && !(packet instanceof PacketPlayOutChat) && !(packet instanceof PacketPlayOutTabComplete)) {
                Debug.echoError("Warning: packet sent off main thread! This is completely unsupported behavior! Denizen network interceptor ignoring packet to avoid crash. Packet class: " + packet.getClass().getCanonicalName() + " sent to " + this.player.co() + " identify the sender of the packet from the stack trace:");
                try {
                    throw new RuntimeException("Trace");
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                }
            }
            this.oldManager.a(packet, genericfuturelistener);
            return;
        }
        if (NMSHandler.debugPackets) {
            this.debugOutputPacket(packet);
        }
        ++this.packetsSent;
        if (this.processAttachToForPacket(packet) || this.processHiddenEntitiesForPacket(packet) || this.processPacketHandlerForPacket(packet) || this.processMirrorForPacket(packet) || this.processParticlesForPacket(packet) || this.processSoundPacket(packet) || this.processActionbarPacket(packet, genericfuturelistener) || this.processDisguiseForPacket(packet, genericfuturelistener) || this.processMetadataChangesForPacket(packet, genericfuturelistener) || this.processEquipmentForPacket(packet, genericfuturelistener) || this.processShowFakeForPacket(packet, genericfuturelistener)) {
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DENIED PACKET " + packet.getClass().getCanonicalName() + " DENIED FROM SEND TO " + this.player.co());
            }
            return;
        }
        this.processBlockLightForPacket(packet);
        this.oldManager.a(packet, genericfuturelistener);
    }

    public boolean processActionbarPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (!PlayerReceivesActionbarScriptEvent.instance.loaded) {
            return false;
        }
        if (packet instanceof ClientboundSetActionBarTextPacket) {
            ClientboundSetActionBarTextPacket actionbarPacket = (ClientboundSetActionBarTextPacket)packet;
            PlayerReceivesActionbarScriptEvent event = PlayerReceivesActionbarScriptEvent.instance;
            IChatBaseComponent baseComponent = actionbarPacket.b();
            event.message = new ElementTag(FormattedTextHelper.stringify(Handler.componentToSpigot(baseComponent), ChatColor.WHITE));
            event.rawJson = new ElementTag(IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)baseComponent));
            event.system = new ElementTag(false);
            event.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.player.getBukkitEntity());
            event.modifyMessage = msg -> {
                event.message = new ElementTag((String)msg);
                event.modified = true;
            };
            event.modifyRawJson = json -> {
                event.message = new ElementTag(FormattedTextHelper.stringify(ComponentSerializer.parse((String)json), ChatColor.WHITE));
                event.modified = true;
            };
            event.modifyCancellation = c2 -> {
                event.cancelled = c2;
            };
            event.cancelled = false;
            event.modified = false;
            event.fire();
            if (event.cancelled) {
                return true;
            }
            if (event.modified) {
                IChatMutableComponent component = Handler.componentToNMS(FormattedTextHelper.parse(event.message.asString(), ChatColor.WHITE));
                ClientboundSetActionBarTextPacket newPacket = new ClientboundSetActionBarTextPacket((IChatBaseComponent)component);
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
        }
        return false;
    }

    public boolean processSoundPacket(Packet<?> packet) {
        if (!PlayerHearsSoundScriptEvent.enabled) {
            return false;
        }
        if (packet instanceof PacketPlayOutNamedSoundEffect) {
            PacketPlayOutNamedSoundEffect spacket = (PacketPlayOutNamedSoundEffect)packet;
            return PlayerHearsSoundScriptEvent.instance.run((Player)this.player.getBukkitEntity(), spacket.b().a().a(), spacket.c().name(), false, null, new Location(this.player.getBukkitEntity().getWorld(), spacket.d(), spacket.e(), spacket.f()), spacket.g(), spacket.h());
        }
        if (packet instanceof PacketPlayOutEntitySound) {
            PacketPlayOutEntitySound spacket = (PacketPlayOutEntitySound)packet;
            net.minecraft.world.entity.Entity entity = this.player.x().a(spacket.d());
            if (entity == null) {
                return false;
            }
            return PlayerHearsSoundScriptEvent.instance.run((Player)this.player.getBukkitEntity(), spacket.b().a().a(), spacket.c().name(), false, (Entity)entity.getBukkitEntity(), null, spacket.e(), spacket.f());
        }
        if (packet instanceof PacketPlayOutCustomSoundEffect) {
            PacketPlayOutCustomSoundEffect spacket = (PacketPlayOutCustomSoundEffect)packet;
            return PlayerHearsSoundScriptEvent.instance.run((Player)this.player.getBukkitEntity(), spacket.b().toString(), spacket.c().name(), true, null, new Location(this.player.getBukkitEntity().getWorld(), spacket.d(), spacket.e(), spacket.f()), spacket.g(), spacket.h());
        }
        return false;
    }

    public boolean processEquipmentForPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (FakeEquipCommand.overrides.isEmpty()) {
            return false;
        }
        try {
            if (packet instanceof PacketPlayOutEntityEquipment) {
                int eid = ((PacketPlayOutEntityEquipment)packet).b();
                net.minecraft.world.entity.Entity ent = this.player.t.a(eid);
                if (ent == null) {
                    return false;
                }
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor(ent.cm(), (Player)this.player.getBukkitEntity());
                if (override == null) {
                    return false;
                }
                ArrayList<Pair> equipment = new ArrayList<Pair>(((PacketPlayOutEntityEquipment)packet).c());
                PacketPlayOutEntityEquipment newPacket = new PacketPlayOutEntityEquipment(eid, equipment);
                for (int i = 0; i < equipment.size(); ++i) {
                    Pair pair = (Pair)equipment.get(i);
                    net.minecraft.world.item.ItemStack use = (net.minecraft.world.item.ItemStack)pair.getSecond();
                    switch ((EnumItemSlot)pair.getFirst()) {
                        case a: {
                            use = override.hand == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack());
                            break;
                        }
                        case b: {
                            use = override.offhand == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack());
                            break;
                        }
                        case e: {
                            use = override.chest == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.chest.getItemStack());
                            break;
                        }
                        case f: {
                            use = override.head == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.head.getItemStack());
                            break;
                        }
                        case d: {
                            use = override.legs == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.legs.getItemStack());
                            break;
                        }
                        case c: {
                            use = override.boots == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.boots.getItemStack());
                        }
                    }
                    equipment.set(i, new Pair((Object)((EnumItemSlot)pair.getFirst()), (Object)use));
                }
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutEntityStatus) {
                net.minecraft.world.entity.Entity ent = ((PacketPlayOutEntityStatus)packet).a(this.player.t);
                if (!(ent instanceof EntityLiving)) {
                    return false;
                }
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor(ent.cm(), (Player)this.player.getBukkitEntity());
                if (override == null || override.hand == null && override.offhand == null) {
                    return false;
                }
                if (((PacketPlayOutEntityStatus)packet).b() != 55) {
                    return false;
                }
                ArrayList<Pair> equipment = new ArrayList<Pair>();
                net.minecraft.world.item.ItemStack hand = override.hand != null ? CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack()) : ((EntityLiving)ent).er();
                net.minecraft.world.item.ItemStack offhand = override.offhand != null ? CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack()) : ((EntityLiving)ent).es();
                equipment.add(new Pair((Object)EnumItemSlot.a, (Object)hand));
                equipment.add(new Pair((Object)EnumItemSlot.b, (Object)offhand));
                PacketPlayOutEntityEquipment newPacket = new PacketPlayOutEntityEquipment(ent.ae(), equipment);
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutWindowItems) {
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor(this.player.cm(), (Player)this.player.getBukkitEntity());
                if (override == null) {
                    return false;
                }
                int window = ((PacketPlayOutWindowItems)packet).b();
                if (window != 0) {
                    return false;
                }
                NonNullList items = (NonNullList)((PacketPlayOutWindowItems)packet).c();
                if (override.head != null) {
                    items.set(5, (Object)CraftItemStack.asNMSCopy((ItemStack)override.head.getItemStack()));
                }
                if (override.chest != null) {
                    items.set(6, (Object)CraftItemStack.asNMSCopy((ItemStack)override.chest.getItemStack()));
                }
                if (override.legs != null) {
                    items.set(7, (Object)CraftItemStack.asNMSCopy((ItemStack)override.legs.getItemStack()));
                }
                if (override.boots != null) {
                    items.set(8, (Object)CraftItemStack.asNMSCopy((ItemStack)override.boots.getItemStack()));
                }
                if (override.offhand != null) {
                    items.set(45, (Object)CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack()));
                }
                if (override.hand != null) {
                    items.set(this.player.fq().k + 36, (Object)CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack()));
                }
                PacketPlayOutWindowItems newPacket = new PacketPlayOutWindowItems(window, ((PacketPlayOutWindowItems)packet).e(), items, ((PacketPlayOutWindowItems)packet).d());
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutSetSlot) {
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor(this.player.cm(), (Player)this.player.getBukkitEntity());
                if (override == null) {
                    return false;
                }
                int window = ((PacketPlayOutSetSlot)packet).b();
                if (window != 0) {
                    return false;
                }
                int slot = ((PacketPlayOutSetSlot)packet).c();
                ItemStack item = null;
                if (slot == 5 && override.head != null) {
                    item = override.head.getItemStack();
                } else if (slot == 6 && override.chest != null) {
                    item = override.chest.getItemStack();
                } else if (slot == 7 && override.legs != null) {
                    item = override.legs.getItemStack();
                } else if (slot == 8 && override.boots != null) {
                    item = override.boots.getItemStack();
                } else if (slot == 45 && override.offhand != null) {
                    item = override.offhand.getItemStack();
                } else if (slot == this.player.fq().k + 36 && override.hand != null) {
                    item = override.hand.getItemStack();
                }
                if (item == null) {
                    return false;
                }
                PacketPlayOutSetSlot newPacket = new PacketPlayOutSetSlot(window, ((PacketPlayOutSetSlot)packet).e(), slot, CraftItemStack.asNMSCopy((ItemStack)item));
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public boolean processParticlesForPacket(Packet<?> packet) {
        if (HideParticles.hidden.isEmpty()) {
            return false;
        }
        try {
            if (packet instanceof PacketPlayOutWorldParticles) {
                HashSet<Particle> hidden = HideParticles.hidden.get(this.player.cm());
                if (hidden == null) {
                    return false;
                }
                ParticleParam particle = ((PacketPlayOutWorldParticles)packet).k();
                Particle bukkitParticle = CraftParticle.toBukkit((ParticleParam)particle);
                return hidden.contains(bukkitParticle);
            }
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public boolean processDisguiseForPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (DisguiseCommand.disguises.isEmpty() || this.antiDuplicate) {
            return false;
        }
        try {
            int ider = -1;
            if (packet instanceof PacketPlayOutEntityMetadata) {
                ider = ((PacketPlayOutEntityMetadata)packet).c();
            }
            if (packet instanceof PacketPlayOutUpdateAttributes) {
                ider = ((PacketPlayOutUpdateAttributes)packet).b();
            }
            if (packet instanceof PacketPlayOutNamedEntitySpawn) {
                ider = ((PacketPlayOutNamedEntitySpawn)packet).b();
            } else if (packet instanceof PacketPlayOutSpawnEntity) {
                ider = ((PacketPlayOutSpawnEntity)packet).b();
            } else if (packet instanceof PacketPlayOutSpawnEntityLiving) {
                ider = ((PacketPlayOutSpawnEntityLiving)packet).b();
            }
            if (ider != -1) {
                net.minecraft.world.entity.Entity e2 = this.player.x().a(ider);
                if (e2 == null) {
                    return false;
                }
                HashMap<UUID, DisguiseCommand.TrackedDisguise> playerMap = DisguiseCommand.disguises.get(e2.cm());
                if (playerMap == null) {
                    return false;
                }
                DisguiseCommand.TrackedDisguise disguise = playerMap.get(this.player.cm());
                if (disguise == null && (disguise = playerMap.get(null)) == null) {
                    return false;
                }
                if (!disguise.isActive) {
                    return false;
                }
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("DISGUISED packet " + packet.getClass().getName() + " for entity " + ider + " to player " + this.player.co());
                }
                if (packet instanceof PacketPlayOutEntityMetadata) {
                    PacketPlayOutEntityMetadata metadataPacket = (PacketPlayOutEntityMetadata)packet;
                    if (e2.ae() == this.player.ae()) {
                        if (!disguise.shouldFake) {
                            return false;
                        }
                        ArrayList<DataWatcher.Item> data = metadataPacket.b();
                        for (DataWatcher.Item item : data) {
                            DataWatcherObject watcherObject = item.a();
                            int watcherId = watcherObject.a();
                            if (watcherId != 0) continue;
                            PacketPlayOutEntityMetadata altPacket = new PacketPlayOutEntityMetadata(DenizenNetworkManagerImpl.copyPacket(metadataPacket));
                            data = new ArrayList<DataWatcher.Item>(data);
                            ENTITY_METADATA_LIST.set(altPacket, data);
                            data.remove(item);
                            byte flags = (Byte)item.b();
                            flags = (byte)(flags | 0x20);
                            data.add(new DataWatcher.Item(watcherObject, (Object)flags));
                            PacketPlayOutEntityMetadata updatedPacket = this.getModifiedMetadataFor(altPacket);
                            this.oldManager.a((Packet)(updatedPacket == null ? altPacket : updatedPacket), genericfuturelistener);
                            return true;
                        }
                    } else {
                        PacketPlayOutEntityMetadata altPacket = new PacketPlayOutEntityMetadata(e2.ae(), ((CraftEntity)disguise.toOthers.entity.entity).getHandle().ai(), true);
                        this.oldManager.a((Packet)altPacket, genericfuturelistener);
                        return true;
                    }
                    return false;
                }
                if (packet instanceof PacketPlayOutUpdateAttributes) {
                    FakeEntity fake;
                    FakeEntity fakeEntity = fake = ider == this.player.ae() ? disguise.fakeToSelf : disguise.toOthers;
                    if (fake == null) {
                        return false;
                    }
                    return !(fake.entity.entity instanceof LivingEntity);
                }
                this.antiDuplicate = true;
                disguise.sendTo(Collections.singletonList(new PlayerTag((Player)this.player.getBukkitEntity())));
                this.antiDuplicate = false;
                return true;
            }
        }
        catch (Throwable ex) {
            this.antiDuplicate = false;
            Debug.echoError(ex);
        }
        return false;
    }

    public PacketPlayOutEntityMetadata getModifiedMetadataFor(PacketPlayOutEntityMetadata metadataPacket) {
        if (!RenameCommand.hasAnyDynamicRenames() && SneakCommand.forceSetSneak.isEmpty()) {
            return null;
        }
        try {
            int eid = metadataPacket.c();
            net.minecraft.world.entity.Entity ent = this.player.t.a(eid);
            if (ent == null) {
                return null;
            }
            String nameToApply = RenameCommand.getCustomNameFor(ent.cm(), (Player)this.player.getBukkitEntity(), false);
            Boolean forceSneak = SneakCommand.shouldSneak(ent.cm(), this.player.cm());
            if (nameToApply == null && forceSneak == null) {
                return null;
            }
            ArrayList<DataWatcher.Item> data = new ArrayList<DataWatcher.Item>(metadataPacket.b());
            boolean any = false;
            for (int i = 0; i < data.size(); ++i) {
                DataWatcher.Item item = (DataWatcher.Item)data.get(i);
                DataWatcherObject watcherObject = item.a();
                int watcherId = watcherObject.a();
                if (watcherId == 0 && forceSneak != null) {
                    byte val = (Byte)item.b();
                    val = forceSneak != false ? (byte)(val | 2) : (byte)(val & 0xFFFFFFFD);
                    data.set(i, new DataWatcher.Item(watcherObject, (Object)val));
                    any = true;
                    continue;
                }
                if (watcherId == 2 && nameToApply != null) {
                    Optional<IChatMutableComponent> name = Optional.of(Handler.componentToNMS(FormattedTextHelper.parse(nameToApply, ChatColor.WHITE)));
                    data.set(i, new DataWatcher.Item(watcherObject, name));
                    any = true;
                    continue;
                }
                if (watcherId != 3 || nameToApply == null) continue;
                data.set(i, new DataWatcher.Item(watcherObject, (Object)true));
                any = true;
            }
            if (!any) {
                return null;
            }
            PacketPlayOutEntityMetadata altPacket = new PacketPlayOutEntityMetadata(DenizenNetworkManagerImpl.copyPacket(metadataPacket));
            ENTITY_METADATA_LIST.set(altPacket, data);
            return altPacket;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public boolean processMetadataChangesForPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (!(packet instanceof PacketPlayOutEntityMetadata)) {
            return false;
        }
        PacketPlayOutEntityMetadata altPacket = this.getModifiedMetadataFor((PacketPlayOutEntityMetadata)packet);
        if (altPacket == null) {
            return false;
        }
        this.oldManager.a((Packet)altPacket, genericfuturelistener);
        return true;
    }

    public void tryProcessMovePacketForAttach(PacketPlayOutEntity packet, net.minecraft.world.entity.Entity e2) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = EntityAttachmentHelper.toEntityToData.get(e2.cm());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                PacketPlayOutEntity.PacketPlayOutRelEntityMove pNew;
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(this.player.cm());
                if (!attMap.attached.isValid() || att == null) continue;
                int newId = att.attached.getBukkitEntity().getEntityId();
                if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMove) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(newId, packet.b(), packet.c(), packet.d(), packet.i());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutEntityLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutEntityLook(newId, packet.e(), packet.f(), packet.i());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(newId, packet.b(), packet.c(), packet.d(), packet.e(), packet.f(), packet.i());
                } else {
                    if (Debug.verbose) {
                        Debug.echoError("Impossible move-entity packet class: " + packet.getClass().getCanonicalName());
                    }
                    return;
                }
                if (att.positionalOffset != null && (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMove || packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook)) {
                    byte pitch;
                    byte yaw;
                    net.minecraft.world.entity.Entity attachedEntity;
                    boolean isRotate = packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook;
                    if (att.noRotate) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = EntityAttachmentHelper.compressAngle(attachedEntity.dm());
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dn());
                    } else if (isRotate) {
                        yaw = packet.e();
                        pitch = packet.f();
                    } else {
                        yaw = EntityAttachmentHelper.compressAngle(e2.dm());
                        pitch = EntityAttachmentHelper.compressAngle(e2.dn());
                    }
                    if (att.noPitch) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dn());
                    }
                    byte newYaw = yaw;
                    if (isRotate) {
                        newYaw = EntityAttachmentHelper.adaptedCompressedAngle(newYaw, att.positionalOffset.getYaw());
                        pitch = EntityAttachmentHelper.adaptedCompressedAngle(pitch, att.positionalOffset.getPitch());
                    }
                    Vector goalPosition = att.fixedForOffset(new Vector(e2.dc(), e2.de(), e2.di()), e2.dm(), e2.dn());
                    Vector oldPos = att.visiblePositions.get(this.player.cm());
                    boolean forceTele = false;
                    if (oldPos == null) {
                        oldPos = att.attached.getLocation().toVector();
                        forceTele = true;
                    }
                    Vector moveNeeded = goalPosition.clone().subtract(oldPos);
                    att.visiblePositions.put(this.player.cm(), goalPosition.clone());
                    int offX = (int)(moveNeeded.getX() * 4096.0);
                    int offY = (int)(moveNeeded.getY() * 4096.0);
                    int offZ = (int)(moveNeeded.getZ() * 4096.0);
                    if (forceTele || offX < Short.MIN_VALUE || offX > Short.MAX_VALUE || offY < Short.MIN_VALUE || offY > Short.MAX_VALUE || offZ < Short.MIN_VALUE || offZ > Short.MAX_VALUE) {
                        PacketPlayOutEntityTeleport newTeleportPacket = new PacketPlayOutEntityTeleport(e2);
                        ENTITY_ID_PACKTELENT.setInt(newTeleportPacket, att.attached.getBukkitEntity().getEntityId());
                        POS_X_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getX());
                        POS_Y_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getY());
                        POS_Z_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getZ());
                        YAW_PACKTELENT.setByte(newTeleportPacket, newYaw);
                        PITCH_PACKTELENT.setByte(newTeleportPacket, pitch);
                        if (NMSHandler.debugPackets) {
                            DenizenNetworkManagerImpl.doPacketOutput("Attach Move-Tele Packet: " + newTeleportPacket.getClass().getCanonicalName() + " for " + att.attached.getUUID() + " sent to " + this.player.co() + " with original yaw " + yaw + " adapted to " + newYaw);
                        }
                        this.oldManager.a((Packet)newTeleportPacket);
                        continue;
                    }
                    POS_X_PACKENT.setShort(pNew, (short)MathHelper.a((int)offX, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Y_PACKENT.setShort(pNew, (short)MathHelper.a((int)offY, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Z_PACKENT.setShort(pNew, (short)MathHelper.a((int)offZ, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    if (isRotate) {
                        YAW_PACKENT.setByte(pNew, yaw);
                        PITCH_PACKENT.setByte(pNew, pitch);
                    }
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("Attach Move Packet: " + pNew.getClass().getCanonicalName() + " for " + att.attached.getUUID() + " sent to " + this.player.co() + " with original yaw " + yaw + " adapted to " + newYaw);
                    }
                    this.oldManager.a((Packet)pNew);
                    continue;
                }
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Attach Replica-Move Packet: " + pNew.getClass().getCanonicalName() + " for " + att.attached.getUUID() + " sent to " + this.player.co());
                }
                this.oldManager.a((Packet)pNew);
            }
        }
        if (e2.au != null && !e2.au.isEmpty()) {
            for (net.minecraft.world.entity.Entity ent : e2.au) {
                this.tryProcessMovePacketForAttach(packet, ent);
            }
        }
    }

    public void tryProcessVelocityPacketForAttach(PacketPlayOutEntityVelocity packet, net.minecraft.world.entity.Entity e2) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = EntityAttachmentHelper.toEntityToData.get(e2.cm());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(this.player.cm());
                if (!attMap.attached.isValid() || att == null) continue;
                PacketPlayOutEntityVelocity pNew = new PacketPlayOutEntityVelocity(DenizenNetworkManagerImpl.copyPacket(packet));
                ENTITY_ID_PACKVELENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Attach Velocity Packet: " + pNew.getClass().getCanonicalName() + " for " + att.attached.getUUID() + " sent to " + this.player.co());
                }
                this.oldManager.a((Packet)pNew);
            }
        }
        if (e2.au != null && !e2.au.isEmpty()) {
            for (net.minecraft.world.entity.Entity ent : e2.au) {
                this.tryProcessVelocityPacketForAttach(packet, ent);
            }
        }
    }

    public void tryProcessTeleportPacketForAttach(PacketPlayOutEntityTeleport packet, net.minecraft.world.entity.Entity e2, Vector relative) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = EntityAttachmentHelper.toEntityToData.get(e2.cm());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(this.player.cm());
                if (!attMap.attached.isValid() || att == null) continue;
                PacketPlayOutEntityTeleport pNew = new PacketPlayOutEntityTeleport(DenizenNetworkManagerImpl.copyPacket(packet));
                ENTITY_ID_PACKTELENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                Vector resultPos = new Vector(POS_X_PACKTELENT.getDouble(pNew), POS_Y_PACKTELENT.getDouble(pNew), POS_Z_PACKTELENT.getDouble(pNew)).add(relative);
                if (att.positionalOffset != null) {
                    byte pitch;
                    byte yaw;
                    net.minecraft.world.entity.Entity attachedEntity;
                    resultPos = att.fixedForOffset(resultPos, e2.dm(), e2.dn());
                    if (att.noRotate) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = EntityAttachmentHelper.compressAngle(attachedEntity.dm());
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dn());
                    } else {
                        yaw = packet.f();
                        pitch = packet.g();
                    }
                    if (att.noPitch) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dn());
                    }
                    byte newYaw = EntityAttachmentHelper.adaptedCompressedAngle(yaw, att.positionalOffset.getYaw());
                    pitch = EntityAttachmentHelper.adaptedCompressedAngle(pitch, att.positionalOffset.getPitch());
                    POS_X_PACKTELENT.setDouble(pNew, resultPos.getX());
                    POS_Y_PACKTELENT.setDouble(pNew, resultPos.getY());
                    POS_Z_PACKTELENT.setDouble(pNew, resultPos.getZ());
                    YAW_PACKTELENT.setByte(pNew, newYaw);
                    PITCH_PACKTELENT.setByte(pNew, pitch);
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("Attach Teleport Packet: " + pNew.getClass().getCanonicalName() + " for " + att.attached.getUUID() + " sent to " + this.player.co() + " with raw yaw " + yaw + " adapted to " + newYaw);
                    }
                }
                att.visiblePositions.put(this.player.cm(), resultPos.clone());
                this.oldManager.a((Packet)pNew);
            }
        }
        if (e2.au != null && !e2.au.isEmpty()) {
            for (net.minecraft.world.entity.Entity ent : e2.au) {
                this.tryProcessTeleportPacketForAttach(packet, ent, new Vector(ent.dc() - e2.dc(), ent.de() - e2.de(), ent.di() - e2.di()));
            }
        }
    }

    public boolean processAttachToForPacket(Packet<?> packet) {
        if (EntityAttachmentHelper.toEntityToData.isEmpty()) {
            return false;
        }
        try {
            if (packet instanceof PacketPlayOutEntity) {
                net.minecraft.world.entity.Entity e2 = ((PacketPlayOutEntity)packet).a((net.minecraft.world.level.World)this.player.x());
                if (e2 == null) {
                    return false;
                }
                if (!e2.bF()) {
                    this.tryProcessMovePacketForAttach((PacketPlayOutEntity)packet, e2);
                }
                return EntityAttachmentHelper.denyOriginalPacketSend(this.player.cm(), e2.cm());
            }
            if (packet instanceof PacketPlayOutEntityVelocity) {
                int ider = ((PacketPlayOutEntityVelocity)packet).b();
                net.minecraft.world.entity.Entity e3 = this.player.x().a(ider);
                if (e3 == null) {
                    return false;
                }
                this.tryProcessVelocityPacketForAttach((PacketPlayOutEntityVelocity)packet, e3);
                return EntityAttachmentHelper.denyOriginalPacketSend(this.player.cm(), e3.cm());
            }
            if (packet instanceof PacketPlayOutEntityTeleport) {
                int ider = ((PacketPlayOutEntityTeleport)packet).b();
                net.minecraft.world.entity.Entity e4 = this.player.x().a(ider);
                if (e4 == null) {
                    return false;
                }
                this.tryProcessTeleportPacketForAttach((PacketPlayOutEntityTeleport)packet, e4, VECTOR_ZERO);
                return EntityAttachmentHelper.denyOriginalPacketSend(this.player.cm(), e4.cm());
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public boolean isHidden(net.minecraft.world.entity.Entity entity) {
        return entity != null && HideEntitiesHelper.playerShouldHide(this.player.getBukkitEntity().getUniqueId(), (Entity)entity.getBukkitEntity());
    }

    public boolean processHiddenEntitiesForPacket(Packet<?> packet) {
        if (!HideEntitiesHelper.hasAnyHides()) {
            return false;
        }
        try {
            int ider = -1;
            net.minecraft.world.entity.Entity e2 = null;
            if (packet instanceof PacketPlayOutNamedEntitySpawn) {
                ider = ((PacketPlayOutNamedEntitySpawn)packet).b();
            } else if (packet instanceof PacketPlayOutSpawnEntity) {
                ider = ((PacketPlayOutSpawnEntity)packet).b();
            } else if (packet instanceof PacketPlayOutSpawnEntityLiving) {
                ider = ((PacketPlayOutSpawnEntityLiving)packet).b();
            } else if (packet instanceof PacketPlayOutSpawnEntityPainting) {
                ider = ((PacketPlayOutSpawnEntityPainting)packet).b();
            } else if (packet instanceof PacketPlayOutSpawnEntityExperienceOrb) {
                ider = ((PacketPlayOutSpawnEntityExperienceOrb)packet).b();
            } else if (packet instanceof PacketPlayOutEntity) {
                e2 = ((PacketPlayOutEntity)packet).a((net.minecraft.world.level.World)this.player.x());
            } else if (packet instanceof PacketPlayOutEntityMetadata) {
                ider = ((PacketPlayOutEntityMetadata)packet).c();
            } else if (packet instanceof PacketPlayOutEntityVelocity) {
                ider = ((PacketPlayOutEntityVelocity)packet).b();
            } else if (packet instanceof PacketPlayOutEntityTeleport) {
                ider = ((PacketPlayOutEntityTeleport)packet).b();
            }
            if (e2 == null && ider != -1) {
                e2 = this.player.x().a(ider);
            }
            if (e2 != null) {
                if (this.isHidden(e2)) {
                    return true;
                }
                if (packet instanceof PacketPlayOutNamedEntitySpawn || packet instanceof PacketPlayOutSpawnEntity || packet instanceof PacketPlayOutSpawnEntityLiving || packet instanceof PacketPlayOutSpawnEntityPainting || packet instanceof PacketPlayOutSpawnEntityExperienceOrb) {
                    this.processFakePlayerSpawn(e2);
                }
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public void processFakePlayerSpawn(net.minecraft.world.entity.Entity entity) {
        if (entity instanceof EntityFakePlayerImpl) {
            EntityFakePlayerImpl fakePlayer = (EntityFakePlayerImpl)entity;
            this.a((Packet<?>)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, new EntityPlayer[]{fakePlayer}));
            Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), () -> this.a((Packet<?>)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, new EntityPlayer[]{fakePlayer})), 5L);
        }
    }

    public boolean processMirrorForPacket(Packet<?> packet) {
        if (packet instanceof PacketPlayOutPlayerInfo) {
            PacketPlayOutPlayerInfo playerInfo = (PacketPlayOutPlayerInfo)packet;
            ProfileEditorImpl.updatePlayerProfiles(playerInfo);
            if (!ProfileEditorImpl.handleAlteredProfiles(playerInfo, this)) {
                return true;
            }
        }
        return false;
    }

    public boolean processPacketHandlerForPacket(Packet<?> packet) {
        if (packet instanceof PacketPlayOutChat && DenizenPacketHandler.instance.shouldInterceptChatPacket()) {
            return DenizenPacketHandler.instance.sendPacket((Player)this.player.getBukkitEntity(), new PacketOutChatImpl((PacketPlayOutChat)packet));
        }
        if (packet instanceof PacketPlayOutEntityMetadata && DenizenPacketHandler.instance.shouldInterceptMetadata()) {
            return DenizenPacketHandler.instance.sendPacket((Player)this.player.getBukkitEntity(), new PacketOutEntityMetadataImpl((PacketPlayOutEntityMetadata)packet));
        }
        return false;
    }

    public boolean processShowFakeForPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (FakeBlock.blocks.isEmpty()) {
            return false;
        }
        try {
            if (packet instanceof ClientboundLevelChunkWithLightPacket) {
                FakeBlock.FakeBlockMap map = FakeBlock.blocks.get(this.player.cm());
                if (map == null) {
                    return false;
                }
                int chunkX = ((ClientboundLevelChunkWithLightPacket)packet).b();
                int chunkZ = ((ClientboundLevelChunkWithLightPacket)packet).c();
                ChunkCoordinate chunkCoord = new ChunkCoordinate(chunkX, chunkZ, this.player.x().getWorld().getName());
                List<FakeBlock> blocks = FakeBlock.getFakeBlocksFor(this.player.cm(), chunkCoord);
                if (blocks == null || blocks.isEmpty()) {
                    return false;
                }
                ClientboundLevelChunkWithLightPacket newPacket = FakeBlockHelper.handleMapChunkPacket(this.player.getBukkitEntity().getWorld(), (ClientboundLevelChunkWithLightPacket)packet, chunkX, chunkZ, blocks);
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutMultiBlockChange) {
                FakeBlock.FakeBlockMap map = FakeBlock.blocks.get(this.player.cm());
                if (map == null) {
                    return false;
                }
                SectionPosition coord = (SectionPosition)SECTIONPOS_MULTIBLOCKCHANGE.get(packet);
                ChunkCoordinate coordinateDenizen = new ChunkCoordinate(coord.u(), coord.w(), this.player.x().getWorld().getName());
                if (!map.byChunk.containsKey(coordinateDenizen)) {
                    return false;
                }
                PacketPlayOutMultiBlockChange newPacket = new PacketPlayOutMultiBlockChange(DenizenNetworkManagerImpl.copyPacket(packet));
                LocationTag location = new LocationTag((World)this.player.x().getWorld(), 0.0, 0.0, 0.0);
                short[] originalOffsetArray = (short[])OFFSETARRAY_MULTIBLOCKCHANGE.get(newPacket);
                IBlockData[] originalDataArray = (IBlockData[])BLOCKARRAY_MULTIBLOCKCHANGE.get(newPacket);
                short[] offsetArray = Arrays.copyOf(originalOffsetArray, originalOffsetArray.length);
                IBlockData[] dataArray = Arrays.copyOf(originalDataArray, originalDataArray.length);
                OFFSETARRAY_MULTIBLOCKCHANGE.set(newPacket, offsetArray);
                BLOCKARRAY_MULTIBLOCKCHANGE.set(newPacket, dataArray);
                for (int i = 0; i < offsetArray.length; ++i) {
                    short offset = offsetArray[i];
                    BlockPosition pos = coord.g(offset);
                    location.setX(pos.u());
                    location.setY(pos.v());
                    location.setZ(pos.w());
                    FakeBlock block = map.byLocation.get(location);
                    if (block == null) continue;
                    dataArray[i] = FakeBlockHelper.getNMSState(block);
                }
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutBlockChange) {
                BlockPosition pos = ((PacketPlayOutBlockChange)packet).c();
                LocationTag loc = new LocationTag((World)this.player.x().getWorld(), (double)pos.u(), (double)pos.v(), pos.w());
                FakeBlock block = FakeBlock.getFakeBlockFor(this.player.cm(), loc);
                if (block != null) {
                    PacketPlayOutBlockChange newPacket = new PacketPlayOutBlockChange(((PacketPlayOutBlockChange)packet).c(), FakeBlockHelper.getNMSState(block));
                    this.oldManager.a((Packet)newPacket, genericfuturelistener);
                    return true;
                }
            } else if (packet instanceof PacketPlayOutBlockBreak) {
                PacketPlayOutBlockBreak origPack = (PacketPlayOutBlockBreak)packet;
                BlockPosition pos = origPack.b();
                LocationTag loc = new LocationTag((World)this.player.x().getWorld(), (double)pos.u(), (double)pos.v(), pos.w());
                FakeBlock block = FakeBlock.getFakeBlockFor(this.player.cm(), loc);
                if (block != null) {
                    PacketPlayOutBlockBreak newPacket = new PacketPlayOutBlockBreak(origPack.b(), FakeBlockHelper.getNMSState(block), origPack.d(), false);
                    this.oldManager.a((Packet)newPacket, genericfuturelistener);
                    return true;
                }
            }
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public void processBlockLightForPacket(Packet<?> packet) {
        if (BlockLight.lightsByChunk.isEmpty()) {
            return;
        }
        if (packet instanceof PacketPlayOutLightUpdate) {
            BlockLightImpl.checkIfLightsBrokenByPacket((PacketPlayOutLightUpdate)packet, this.player.t);
        } else if (packet instanceof PacketPlayOutBlockChange) {
            BlockLightImpl.checkIfLightsBrokenByPacket((PacketPlayOutBlockChange)packet, this.player.t);
        }
    }

    public void a() {
        this.oldManager.a();
    }

    public SocketAddress c() {
        return this.oldManager.c();
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        if (!this.player.getBukkitEntity().isOnline()) {
            return;
        }
        this.oldManager.a(ichatbasecomponent);
    }

    public boolean d() {
        return this.oldManager.d();
    }

    public EnumProtocolDirection e() {
        return this.oldManager.e();
    }

    public EnumProtocolDirection f() {
        return this.oldManager.f();
    }

    public void a(Cipher cipher, Cipher cipher1) {
        this.oldManager.a(cipher, cipher1);
    }

    public boolean g() {
        return this.oldManager.g();
    }

    public boolean h() {
        return this.oldManager.h();
    }

    public boolean i() {
        return this.oldManager.i();
    }

    public PacketListener j() {
        return this.oldManager.j();
    }

    public IChatBaseComponent k() {
        return this.oldManager.k();
    }

    public void l() {
        this.oldManager.l();
    }

    public void a(int i, boolean b) {
        this.oldManager.a(i, b);
    }

    public void m() {
        this.oldManager.m();
    }

    public float n() {
        return this.oldManager.n();
    }

    public float o() {
        return this.oldManager.o();
    }

    public SocketAddress getRawAddress() {
        return this.oldManager.getRawAddress();
    }

    private static EnumProtocolDirection getProtocolDirection(NetworkManager networkManager) {
        EnumProtocolDirection direction = null;
        try {
            direction = (EnumProtocolDirection)protocolDirectionField.get(networkManager);
        }
        catch (Exception e2) {
            Debug.echoError(e2);
        }
        return direction;
    }

    private static void setNetworkManager(PlayerConnection playerConnection, NetworkManager networkManager) {
        try {
            networkManagerField.invoke(playerConnection, networkManager);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.oldManager.acceptInboundMessage(msg);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.oldManager.channelRead(ctx, msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelReadComplete(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.oldManager.userEventTriggered(ctx, evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelWritabilityChanged(ctx);
    }

    static {
        Field directionField = null;
        MethodHandle managerField = null;
        try {
            directionField = ReflectionHelper.getFields(NetworkManager.class).get(ReflectionMappingsInfo.Connection_receiving);
            directionField.setAccessible(true);
            managerField = ReflectionHelper.getFinalSetter(PlayerConnection.class, ReflectionMappingsInfo.ServerGamePacketListenerImpl_connection);
        }
        catch (Exception e2) {
            Debug.echoError(e2);
        }
        protocolDirectionField = directionField;
        networkManagerField = managerField;
    }
}

