/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_17.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_17.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.FurnaceRecipe;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeBlasting;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSmithing;
import net.minecraft.world.item.crafting.RecipeSmoking;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.item.crafting.ShapelessRecipes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ItemHelperImpl
extends ItemHelper {
    public static IRecipe<?> getNMSRecipe(NamespacedKey key) {
        MinecraftKey nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().c.values()) {
            IRecipe recipe = (IRecipe)recipeMap.get((Object)nmsKey);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, "maxStack").invoke(material, size);
            ReflectionHelper.getFinalSetter(Item.class, ReflectionMappingsInfo.Item_maxStackSize).invoke((Item)IRegistry.Z.get(MinecraftKey.a((String)material.getKey().getKey())), size);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public Integer burnTime(Material material) {
        return (Integer)TileEntityFurnace.f().get(CraftMagicNumbers.getItem((Material)material));
    }

    @Override
    public Recipe getRecipeById(NamespacedKey key) {
        IRecipe<?> recipe = ItemHelperImpl.getNMSRecipe(key);
        if (recipe == null) {
            return null;
        }
        return recipe.toBukkitRecipe();
    }

    @Override
    public void removeRecipe(NamespacedKey key) {
        MinecraftKey nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().c.values()) {
            recipeMap.remove((Object)nmsKey);
        }
    }

    @Override
    public void clearDenizenRecipes() {
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().c.values()) {
            for (MinecraftKey key : new ArrayList(recipeMap.keySet())) {
                if (!key.getNamespace().equalsIgnoreCase("denizen")) continue;
                recipeMap.remove((Object)key);
            }
        }
    }

    @Override
    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static RecipeItemStack itemArrayToRecipe(ItemStack[] items, boolean exact) {
        RecipeItemStack.StackProvider[] stacks = new RecipeItemStack.StackProvider[items.length];
        for (int i = 0; i < items.length; ++i) {
            stacks[i] = new RecipeItemStack.StackProvider(CraftItemStack.asNMSCopy((ItemStack)items[i]));
        }
        RecipeItemStack itemRecipe = new RecipeItemStack(Arrays.stream(stacks));
        itemRecipe.exact = exact;
        return itemRecipe;
    }

    @Override
    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        RecipeItemStack itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        Object recipe = type.equalsIgnoreCase("smoker") ? new RecipeSmoking(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new RecipeBlasting(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new RecipeCampfire(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new FurnaceRecipe(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().addRecipe((IRecipe)recipe);
    }

    @Override
    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        RecipeItemStack itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        RecipeStonecutting recipe = new RecipeStonecutting(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().addRecipe((IRecipe)recipe);
    }

    @Override
    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        RecipeItemStack baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        RecipeItemStack upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
        RecipeSmithing recipe = new RecipeSmithing(key, baseItemRecipe, upgradeItemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().addRecipe((IRecipe)recipe);
    }

    @Override
    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        ArrayList<RecipeItemStack> ingredientList = new ArrayList<RecipeItemStack>();
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        ShapelessRecipes recipe = new ShapelessRecipes(key, group, CraftItemStack.asNMSCopy((ItemStack)result), NonNullList.a(null, (Object[])ingredientList.toArray(new RecipeItemStack[0])));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().addRecipe((IRecipe)recipe);
    }

    @Override
    public String getInternalNameFromMaterial(Material material) {
        return "minecraft:" + CoreUtilities.toLowerCase(material.name());
    }

    @Override
    public Material getMaterialFromInternalName(String internalName) {
        return Material.matchMaterial((String)internalName);
    }

    @Override
    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).G().getChatModifier().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    @Override
    public String getRawHoverText(ItemStack itemStack) {
        NBTTagCompound tag = CraftItemStack.asNMSCopy((ItemStack)itemStack).getTag();
        if (tag == null) {
            return null;
        }
        return tag.toString();
    }

    @Override
    public PlayerProfile getSkullSkin(ItemStack is) {
        GameProfile profile;
        NBTTagCompound tag;
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        if (itemStack.hasTag() && (tag = itemStack.getTag()).hasKeyOfType("SkullOwner", 10) && (profile = GameProfileSerializer.deserialize((NBTTagCompound)tag.getCompound("SkullOwner"))) != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            return new PlayerProfile(profile.getName(), profile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
        }
        return null;
    }

    @Override
    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        net.minecraft.world.item.ItemStack nmsItemStack;
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().get((Object)"textures").clear();
            if (playerProfile.getTextureSignature() != null) {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
            } else {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
            }
        }
        NBTTagCompound tag = (nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack)).hasTag() ? nmsItemStack.getTag() : new NBTTagCompound();
        tag.set("SkullOwner", (NBTBase)GameProfileSerializer.serialize((NBTTagCompound)new NBTTagCompound(), (GameProfile)gameProfile));
        nmsItemStack.setTag(tag);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.hasTag() ? nmsItemStack.getTag() : new NBTTagCompound();
        CompoundTag compound = CompoundTagImpl.fromNMSTag(tag).createBuilder().put(key, value).build();
        nmsItemStack.setTag(((CompoundTagImpl)compound).toNMSTag());
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public CompoundTag getNbtData(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && nmsItemStack.hasTag()) {
            return CompoundTagImpl.fromNMSTag(nmsItemStack.getTag());
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    @Override
    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.setTag(((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().l == null) {
            ((CraftInventoryPlayer)inventory).getInventory().setItem(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    @Override
    public IntArrayTag convertUuidToNbt(UUID id) {
        return new IntArrayTag(GameProfileSerializer.a((UUID)id).getInts());
    }

    @Override
    public UUID convertNbtToUuid(IntArrayTag id) {
        return GameProfileSerializer.a((NBTBase)new NBTTagIntArray(id.getValue()));
    }

    @Override
    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        String jsonText = ((NBTTagCompound)nmsItemStack.getTag().get("display")).getString("Name");
        BaseComponent[] nameComponent = ComponentSerializer.parse((String)jsonText);
        return FormattedTextHelper.stringify(nameComponent, ChatColor.WHITE);
    }

    @Override
    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        NBTTagList list = ((NBTTagCompound)nmsItemStack.getTag().get("display")).getList("Lore", 8);
        ArrayList<String> outList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            BaseComponent[] lineComponent = ComponentSerializer.parse((String)list.getString(i));
            outList.add(FormattedTextHelper.stringify(lineComponent, ChatColor.WHITE));
        }
        return outList;
    }

    @Override
    public void setDisplayName(ItemTag item, String name) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        NBTTagCompound tag = nmsItemStack.getOrCreateTag();
        NBTTagCompound display = tag.getCompound("display");
        if (!tag.hasKey("display")) {
            tag.set("display", (NBTBase)display);
        }
        if (name == null || name.isEmpty()) {
            display.set("Name", null);
            return;
        }
        BaseComponent[] components = FormattedTextHelper.parse(name, ChatColor.WHITE);
        display.set("Name", (NBTBase)NBTTagString.a((String)ComponentSerializer.toString((BaseComponent[])components)));
        item.setItemStack(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack));
    }

    @Override
    public void setLore(ItemTag item, List<String> lore) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        NBTTagCompound tag = nmsItemStack.getOrCreateTag();
        NBTTagCompound display = tag.getCompound("display");
        if (!tag.hasKey("display")) {
            tag.set("display", (NBTBase)display);
        }
        if (lore == null || lore.isEmpty()) {
            display.set("Lore", null);
        } else {
            NBTTagList tagList = new NBTTagList();
            for (String line : lore) {
                tagList.add((Object)NBTTagString.a((String)ComponentSerializer.toString((BaseComponent[])FormattedTextHelper.parse(line, ChatColor.WHITE))));
            }
            display.set("Lore", (NBTBase)tagList);
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack));
    }

    public static IBlockData getCorrectStateForFluidBlock(World world, IBlockData iblockdata, BlockPosition blockposition) {
        try {
            Object fluid = BlockHelperImpl.BLOCKSTATEBASE_GETFLUIDSTATE.invoke(iblockdata);
            boolean isEmpty = BlockHelperImpl.FLUIDSTATE_ISEMPTY.invoke(fluid);
            if (!isEmpty && !iblockdata.d((IBlockAccess)world, blockposition, EnumDirection.b)) {
                return BlockHelperImpl.FLUIDSTATE_CREATELEGACYBLOCK.invoke(fluid);
            }
            return iblockdata;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return iblockdata;
        }
    }

    public static boolean blockStateFluidIsEmpty(IBlockData iblockdata) {
        try {
            Object fluid = BlockHelperImpl.BLOCKSTATEBASE_GETFLUIDSTATE.invoke(iblockdata);
            return BlockHelperImpl.FLUIDSTATE_ISEMPTY.invoke(fluid);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return false;
        }
    }

    public static void renderFullMap(WorldMap worldmap, int xMin, int zMin, int xMax, int zMax) {
        WorldServer world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.f;
        int mapX = worldmap.c;
        int mapZ = worldmap.d;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                MaterialMapColor materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                Chunk chunk = world.getChunkAtWorldCoords(new BlockPosition(k2, 0, l2));
                if (chunk.isEmpty()) continue;
                ChunkCoordIntPair chunkcoordintpair = chunk.getPos();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.getDimensionManager().hasCeiling()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)Blocks.j.getBlockData().d((IBlockAccess)world, BlockPosition.b), 10);
                    } else {
                        multiset.add((Object)Blocks.b.getBlockData().d((IBlockAccess)world, BlockPosition.b), 100);
                    }
                    d1 = 100.0;
                } else {
                    BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
                    BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            IBlockData iblockdata;
                            int k4 = chunk.getHighestBlock(HeightMap.Type.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.getMinBuildHeight() + 1) {
                                iblockdata = Blocks.z.getBlockData();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.getType((BlockPosition)blockposition_mutableblockposition)).d((IBlockAccess)world, (BlockPosition)blockposition_mutableblockposition) == MaterialMapColor.b && k4 > world.getMinBuildHeight());
                                if (k4 > world.getMinBuildHeight() && !ItemHelperImpl.blockStateFluidIsEmpty(iblockdata)) {
                                    IBlockData iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((BaseBlockPosition)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.t(l4--);
                                        iblockdata1 = chunk.getType((BlockPosition)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.getMinBuildHeight() && !ItemHelperImpl.blockStateFluidIsEmpty(iblockdata1));
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((World)world, iblockdata, (BlockPosition)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((IBlockAccess)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.d((IBlockAccess)world, (BlockPosition)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (MaterialMapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialMapColor.b)) == MaterialMapColor.n) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.am * 4 + b0));
            }
        }
    }

    @Override
    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        WorldMap worldmap = ((CraftServer)Bukkit.getServer()).getServer().getWorldServer(World.f).a("map_" + mapId);
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }
}

