/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCookEvent;

public class BlockCooksSmeltsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockCooksSmeltsItemScriptEvent instance;
    public ItemTag source_item;
    public ItemTag result_item;
    public Block block;
    public BlockCookEvent event;

    public BlockCooksSmeltsItemScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<block> cooks|smelts <item> (into <item>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!BlockCooksSmeltsItemScriptEvent.tryMaterial(this.block.getType(), path.eventArgLowerAt(0))) {
            return false;
        }
        if (!BlockCooksSmeltsItemScriptEvent.tryItem(this.source_item, path.eventArgLowerAt(2))) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("into") && !BlockCooksSmeltsItemScriptEvent.tryItem(this.result_item, path.eventArgLowerAt(4))) {
            return false;
        }
        if (!this.runInCheck(path, this.block.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "BlockCooksSmelts";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj.canBeType(ItemTag.class)) {
            this.result_item = determinationObj.asType(ItemTag.class, this.getTagContext(path));
            this.event.setResult(this.result_item.getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return new LocationTag(this.block.getLocation());
            }
            case "source_item": {
                return this.source_item;
            }
            case "result_item": {
                return this.result_item;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockCooks(BlockCookEvent event) {
        this.block = event.getBlock();
        this.source_item = new ItemTag(event.getSource());
        this.result_item = new ItemTag(event.getResult());
        this.event = event;
        this.fire((Event)event);
    }
}

