/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;

public class PlayerClosesInvScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerClosesInvScriptEvent instance;
    public InventoryTag inventory;
    private PlayerTag player;
    public InventoryCloseEvent event;

    public PlayerClosesInvScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player closes ")) {
            return false;
        }
        return PlayerClosesInvScriptEvent.couldMatchInventory(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.inventory.tryAdvancedMatcher(path.eventArgLowerAt(2))) {
            return false;
        }
        LocationTag loc = this.inventory.getLocation();
        if (loc == null) {
            loc = this.player.getLocation();
        }
        if (!this.runInCheck(path, loc)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerClosesInventory";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("inventory")) {
            return this.inventory;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerClosesInv(InventoryCloseEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.inventory = InventoryTag.mirrorBukkitInventory(event.getInventory());
        this.player = new PlayerTag((Player)event.getPlayer());
        this.event = event;
        this.fire((Event)event);
    }
}

