/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.npc.traits.PushableTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class PushableCommand
extends AbstractCommand {
    public PushableCommand() {
        this.setName("pushable");
        this.setSyntax("pushable (state:true/false/{toggle}) (delay:<duration>) (returnable:true/false)");
        this.setRequiredArguments(0, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("state") && arg.matchesPrefix("state", "s") && arg.matchesEnum(Toggle.class)) {
                scriptEntry.addObject("state", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("delay") && arg.matchesPrefix("delay", "d") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("delay", arg.asType(DurationTag.class));
                continue;
            }
            if (scriptEntry.hasObject("return") || !arg.matchesPrefix("return", "r") || !arg.matchesBoolean()) continue;
            scriptEntry.addObject("return", arg.asElement());
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        NPCTag denizenNPC = Utilities.getEntryNPC(scriptEntry);
        if (denizenNPC == null) {
            Debug.echoError("No valid NPC attached to this queue!");
            return;
        }
        PushableTrait trait = denizenNPC.getPushableTrait();
        ElementTag state = scriptEntry.getElement("state");
        DurationTag delay = (DurationTag)scriptEntry.getObjectTag("delay");
        ElementTag returnable = scriptEntry.getElement("return");
        if (state == null && delay == null && returnable == null) {
            state = new ElementTag("TOGGLE");
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), denizenNPC, state, delay, returnable);
        }
        if (delay != null) {
            trait.setDelay(delay.getSecondsAsInt());
        }
        if (returnable != null) {
            trait.setReturnable(returnable.asBoolean());
        }
        if (state != null) {
            switch (Toggle.valueOf(state.asString().toUpperCase())) {
                case TRUE: 
                case ON: {
                    trait.setPushable(true);
                    break;
                }
                case FALSE: 
                case OFF: {
                    trait.setPushable(false);
                    break;
                }
                case TOGGLE: {
                    trait.setPushable(!trait.isPushable());
                }
            }
        }
    }

    private static enum Toggle {
        TOGGLE,
        TRUE,
        FALSE,
        ON,
        OFF;

    }
}

