/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_18.Handler;
import com.denizenscript.denizen.nms.v1_18.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_18.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.scripts.commands.entity.RenameCommand;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ProfileEditorImpl
extends ProfileEditor {
    public static final MethodHandle playerInfoData_gameProfile_Setter = ReflectionHelper.getFinalSetterForFirstOfType(PacketPlayOutPlayerInfo.PlayerInfoData.class, GameProfile.class);

    @Override
    protected void updatePlayer(Player player, final boolean isSkinChanging) {
        final EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        final UUID uuid = player.getUniqueId();
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{entityPlayer.ae()});
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (p.getUniqueId().equals(uuid)) continue;
            PacketHelperImpl.send(p, (Packet)destroyPacket);
        }
        new BukkitRunnable(){

            public void run() {
                PacketPlayOutPlayerInfo playerInfo = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, new EntityPlayer[]{entityPlayer});
                PacketPlayOutNamedEntitySpawn spawnPacket = new PacketPlayOutNamedEntitySpawn((EntityHuman)entityPlayer);
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    PacketHelperImpl.send(player, (Packet)playerInfo);
                    if (!player.getUniqueId().equals(uuid)) {
                        PacketHelperImpl.send(player, (Packet)spawnPacket);
                        continue;
                    }
                    if (isSkinChanging) {
                        ((CraftServer)Bukkit.getServer()).getHandle().respawn(entityPlayer, (WorldServer)entityPlayer.s, true, player.getLocation(), false);
                    }
                    player.updateInventory();
                }
            }
        }.runTaskLater((Plugin)NMSHandler.getJavaPlugin(), 5L);
    }

    public static boolean handleAlteredProfiles(PacketPlayOutPlayerInfo packet, DenizenNetworkManagerImpl manager) {
        if (ProfileEditor.mirrorUUIDs.isEmpty() && !RenameCommand.hasAnyDynamicRenames()) {
            return true;
        }
        PacketPlayOutPlayerInfo.EnumPlayerInfoAction action = packet.c();
        if (action != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a && action != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.d) {
            return true;
        }
        List dataList = packet.b();
        if (dataList == null) {
            return true;
        }
        try {
            boolean any = false;
            for (PacketPlayOutPlayerInfo.PlayerInfoData data : dataList) {
                if (!ProfileEditor.mirrorUUIDs.contains(data.a().getId()) && !RenameCommand.customNames.containsKey(data.a().getId())) continue;
                any = true;
            }
            if (!any) {
                return true;
            }
            GameProfile ownProfile = manager.player.fq();
            for (PacketPlayOutPlayerInfo.PlayerInfoData data : dataList) {
                if (!ProfileEditor.mirrorUUIDs.contains(data.a().getId()) && !RenameCommand.customNames.containsKey(data.a().getId())) {
                    PacketPlayOutPlayerInfo newPacket = new PacketPlayOutPlayerInfo(action, new EntityPlayer[0]);
                    List newPacketDataList = newPacket.b();
                    newPacketDataList.add(data);
                    manager.oldManager.a((Packet)newPacket);
                    continue;
                }
                String rename = RenameCommand.getCustomNameFor(data.a().getId(), (Player)manager.player.getBukkitEntity(), false);
                PacketPlayOutPlayerInfo newPacket = new PacketPlayOutPlayerInfo(action, new EntityPlayer[0]);
                List newPacketDataList = newPacket.b();
                GameProfile patchedProfile = new GameProfile(data.a().getId(), rename != null ? (rename.length() > 16 ? rename.substring(0, 16) : rename) : data.a().getName());
                if (ProfileEditor.mirrorUUIDs.contains(data.a().getId())) {
                    patchedProfile.getProperties().putAll((Multimap)ownProfile.getProperties());
                } else {
                    patchedProfile.getProperties().putAll((Multimap)data.a().getProperties());
                }
                String listRename = RenameCommand.getCustomNameFor(data.a().getId(), (Player)manager.player.getBukkitEntity(), true);
                IChatBaseComponent displayName = listRename != null ? Handler.componentToNMS(FormattedTextHelper.parse(listRename, ChatColor.WHITE)) : data.d();
                PacketPlayOutPlayerInfo.PlayerInfoData newData = new PacketPlayOutPlayerInfo.PlayerInfoData(patchedProfile, data.b(), data.c(), displayName);
                newPacketDataList.add(newData);
                manager.oldManager.a((Packet)newPacket);
            }
            return false;
        }
        catch (Exception e2) {
            Debug.echoError(e2);
            return true;
        }
    }

    public static void updatePlayerProfiles(PacketPlayOutPlayerInfo packet) {
        PacketPlayOutPlayerInfo.EnumPlayerInfoAction action = packet.c();
        if (action != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a) {
            return;
        }
        List dataList = packet.b();
        if (dataList != null) {
            try {
                for (PacketPlayOutPlayerInfo.PlayerInfoData data : dataList) {
                    GameProfile gameProfile = data.a();
                    if (!fakeProfiles.containsKey(gameProfile.getId())) continue;
                    playerInfoData_gameProfile_Setter.invoke(data, ProfileEditorImpl.getGameProfile((PlayerProfile)fakeProfiles.get(gameProfile.getId())));
                }
            }
            catch (Throwable e2) {
                Debug.echoError(e2);
            }
        }
    }

    private static GameProfile getGameProfile(PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        return gameProfile;
    }
}

