/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.item;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryPickupItemEvent;

public class InventoryPicksUpItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static InventoryPicksUpItemScriptEvent instance;
    public InventoryTag inventory;
    public ItemTag item;
    public InventoryPickupItemEvent event;

    public InventoryPicksUpItemScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<inventory> picks up <item>");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        return !InventoryPicksUpItemScriptEvent.couldMatchEntity(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.inventory.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.item.tryAdvancedMatcher(path.eventArgLowerAt(3))) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getItem().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "InventoryPicksUpItem";
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "item": {
                return this.item;
            }
            case "inventory": {
                return this.inventory;
            }
            case "entity": {
                return new EntityTag((Entity)this.event.getItem());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onInvPicksUpItem(InventoryPickupItemEvent event) {
        this.event = event;
        this.inventory = InventoryTag.mirrorBukkitInventory(event.getInventory());
        this.item = new ItemTag(event.getItem().getItemStack());
        this.fire((Event)event);
    }
}

