/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.SavableMapFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class CuboidTag
implements ObjectTag,
Cloneable,
Notable,
Adjustable,
AreaContainmentObject,
FlaggableObject {
    public List<LocationPair> pairs = new ArrayList<LocationPair>();
    public String noteName = null;
    public AbstractFlagTracker flagTracker = null;
    String prefix = "Cuboid";
    public static ObjectTagProcessor<CuboidTag> tagProcessor = new ObjectTagProcessor();

    public CuboidTag clone() {
        CuboidTag cuboid;
        try {
            cuboid = (CuboidTag)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Debug.echoError(ex);
            cuboid = new CuboidTag();
        }
        cuboid.noteName = null;
        cuboid.flagTracker = null;
        cuboid.pairs = new ArrayList<LocationPair>(this.pairs.size());
        for (LocationPair pair : this.pairs) {
            cuboid.pairs.add(new LocationPair(pair.low.clone(), pair.high.clone()));
        }
        return cuboid;
    }

    public static List<CuboidTag> getNotableCuboidsContaining(Location location) {
        ArrayList<CuboidTag> cuboids = new ArrayList<CuboidTag>();
        for (CuboidTag cuboid : NoteManager.getAllType(CuboidTag.class)) {
            if (!cuboid.isInsideCuboid(location)) continue;
            cuboids.add(cuboid);
        }
        return cuboids;
    }

    @Deprecated
    public static CuboidTag valueOf(String string) {
        return CuboidTag.valueOf(string, null);
    }

    @Fetchable(value="cu")
    public static CuboidTag valueOf(String string, TagContext context) {
        Notable noted;
        if (string == null) {
            return null;
        }
        if (CoreUtilities.toLowerCase(string).startsWith("cu@")) {
            string = string.substring("cu@".length());
        }
        if ((noted = NoteManager.getSavedObject(string)) instanceof CuboidTag) {
            return (CuboidTag)noted;
        }
        if (CoreUtilities.contains(string, '@')) {
            if (CoreUtilities.contains(string, '|') && string.contains("l@")) {
                Debug.echoError("Warning: likely improperly constructed CuboidTag '" + string + "' - use to_cuboid");
            } else {
                return null;
            }
        }
        if (CoreUtilities.contains(string, '|')) {
            ListTag positions = ListTag.valueOf(string, context);
            if (positions.size() > 1 && LocationTag.matches(positions.get(0)) && LocationTag.matches(positions.get(1))) {
                if (positions.size() % 2 != 0) {
                    if (context == null || context.showErrors()) {
                        Debug.echoError("valueOf CuboidTag returning null (Uneven number of locations): '" + string + "'.");
                    }
                    return null;
                }
                CuboidTag toReturn = new CuboidTag();
                for (int i = 0; i < positions.size(); i += 2) {
                    LocationTag pos_1 = LocationTag.valueOf(positions.get(i), context);
                    LocationTag pos_2 = LocationTag.valueOf(positions.get(i + 1), context);
                    if (pos_1 == null || pos_2 == null) {
                        if (context == null || context.showErrors()) {
                            Debug.echoError("valueOf in CuboidTag returning null (null locations): '" + string + "'.");
                        }
                        return null;
                    }
                    if (pos_1.getWorldName() == null || pos_2.getWorldName() == null) {
                        if (context == null || context.showErrors()) {
                            Debug.echoError("valueOf in CuboidTag returning null (null worlds): '" + string + "'.");
                        }
                        return null;
                    }
                    toReturn.addPair(pos_1, pos_2);
                }
                if (toReturn.pairs.size() > 0) {
                    return toReturn;
                }
            }
        } else if (CoreUtilities.contains(string, ',')) {
            List<String> subStrs = CoreUtilities.split(string, ',');
            if (subStrs.size() < 7 || (subStrs.size() - 1) % 6 != 0) {
                if (context == null || context.showErrors()) {
                    Debug.echoError("valueOf CuboidTag returning null (Improper number of commas): '" + string + "'.");
                }
                return null;
            }
            CuboidTag toReturn = new CuboidTag();
            String worldName = subStrs.get(0);
            if (worldName.startsWith("w@")) {
                worldName = worldName.substring("w@".length());
            }
            try {
                for (int i = 0; i < subStrs.size() - 1; i += 6) {
                    LocationTag locationOne = new LocationTag(CuboidTag.parseRoundDouble(subStrs.get(i + 1)), CuboidTag.parseRoundDouble(subStrs.get(i + 2)), CuboidTag.parseRoundDouble(subStrs.get(i + 3)), worldName);
                    LocationTag locationTwo = new LocationTag(CuboidTag.parseRoundDouble(subStrs.get(i + 4)), CuboidTag.parseRoundDouble(subStrs.get(i + 5)), CuboidTag.parseRoundDouble(subStrs.get(i + 6)), worldName);
                    toReturn.addPair(locationOne, locationTwo);
                }
            }
            catch (NumberFormatException ex) {
                if (context == null || context.showErrors()) {
                    Debug.echoError("valueOf CuboidTag returning null (Improper number value inputs): '" + ex.getMessage() + "'.");
                }
                return null;
            }
            if (toReturn.pairs.size() > 0) {
                return toReturn;
            }
        }
        if (context == null || context.showErrors()) {
            Debug.echoError("Minor: valueOf CuboidTag returning null: " + string);
        }
        return null;
    }

    public static double parseRoundDouble(String str) {
        return Math.floor(Double.parseDouble(str));
    }

    public static boolean matches(String string) {
        return CuboidTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    @Override
    public CuboidTag duplicate() {
        if (this.noteName != null) {
            return this;
        }
        return this.clone();
    }

    public int hashCode() {
        if (this.noteName != null) {
            return this.noteName.hashCode();
        }
        return this.pairs.size() + this.pairs.get((int)0).low.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CuboidTag)) {
            return false;
        }
        CuboidTag cuboid2 = (CuboidTag)other;
        if (cuboid2.pairs.size() != this.pairs.size()) {
            return false;
        }
        if (this.noteName == null != (cuboid2.noteName == null)) {
            return false;
        }
        if (this.noteName != null && !this.noteName.equals(cuboid2.noteName)) {
            return false;
        }
        for (int i = 0; i < this.pairs.size(); ++i) {
            LocationPair pair1 = this.pairs.get(i);
            LocationPair pair2 = cuboid2.pairs.get(i);
            if (!pair1.low.getWorldName().equals(pair2.low.getWorldName())) {
                return false;
            }
            if (pair1.low.distanceSquared(pair2.low) >= 0.5) {
                return false;
            }
            if (!(pair1.high.distanceSquared(pair2.high) >= 0.5)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getNoteName() {
        return this.noteName;
    }

    @Override
    public boolean doesContainLocation(Location loc) {
        return this.isInsideCuboid(loc);
    }

    @Override
    public CuboidTag getCuboidBoundary() {
        CuboidTag result = new CuboidTag(this.getLow(0), this.getHigh(0));
        for (int i = 1; i < this.pairs.size(); ++i) {
            result = result.including(this.getLow(i)).including(this.getHigh(i));
        }
        return result;
    }

    public CuboidTag() {
    }

    public CuboidTag(Location point_1, Location point_2) {
        this.addPair(new LocationTag(point_1), new LocationTag(point_2));
    }

    public void addPair(LocationTag point_1, LocationTag point_2) {
        if (point_1.getWorldName() == null) {
            Debug.echoError("Tried to make cuboid without a world!");
            return;
        }
        if (!point_1.getWorldName().equals(point_2.getWorldName())) {
            Debug.echoError("Tried to make cross-world cuboid!");
            return;
        }
        if (this.pairs.size() > 0 && !point_1.getWorldName().equals(this.getWorld().getName())) {
            Debug.echoError("Tried to make cross-world cuboid set!");
            return;
        }
        LocationPair pair = new LocationPair(point_1, point_2);
        this.pairs.add(pair);
    }

    private static boolean isBetween(int low, int high, int pos) {
        return pos >= low && pos <= high;
    }

    public boolean isInsideCuboid(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        for (LocationPair pair : this.pairs) {
            if (!location.getWorld().getName().equals(pair.low.getWorldName()) || !CuboidTag.isBetween(pair.low.getBlockX(), pair.high.getBlockX(), location.getBlockX()) || !CuboidTag.isBetween(pair.low.getBlockY(), pair.high.getBlockY(), location.getBlockY()) || !CuboidTag.isBetween(pair.low.getBlockZ(), pair.high.getBlockZ(), location.getBlockZ())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ListTag getShell() {
        int max = Settings.blockTagsMaxBlocks();
        int index = 0;
        ListTag list = new ListTag();
        for (LocationPair pair : this.pairs) {
            int z;
            LocationTag low = pair.low;
            LocationTag high = pair.high;
            int y_distance = pair.yDistance();
            int z_distance = pair.zDistance();
            int x_distance = pair.xDistance();
            for (int x = 0; x <= x_distance; ++x) {
                for (int y = 0; y <= y_distance; ++y) {
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)(low.getBlockY() + y), low.getBlockZ()));
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)(low.getBlockY() + y), high.getBlockZ()));
                    if (++index <= max) continue;
                    return list;
                }
                for (z = 1; z < z_distance; ++z) {
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)low.getBlockY(), low.getBlockZ() + z));
                    list.addObject(new LocationTag(low.getWorld(), (double)(low.getBlockX() + x), (double)high.getBlockY(), low.getBlockZ() + z));
                    if (++index <= max) continue;
                    return list;
                }
            }
            for (int y = 1; y < y_distance; ++y) {
                for (z = 1; z < z_distance; ++z) {
                    list.addObject(new LocationTag(low.getWorld(), (double)low.getBlockX(), (double)(low.getBlockY() + y), low.getBlockZ() + z));
                    list.addObject(new LocationTag(low.getWorld(), (double)high.getBlockX(), (double)(low.getBlockY() + y), low.getBlockZ() + z));
                    if (++index <= max) continue;
                    return list;
                }
            }
        }
        return list;
    }

    public ListTag getOutline2D(double y) {
        int max = Settings.blockTagsMaxBlocks();
        int index = 0;
        ListTag list = new ListTag();
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            LocationTag loc_2 = pair.high;
            int z_distance = pair.zDistance();
            int x_distance = pair.xDistance();
            list.addObject(new LocationTag(loc_2.getWorld(), (double)loc_2.getBlockX(), y, loc_2.getBlockZ()));
            for (int x = loc_1.getBlockX(); x < loc_1.getBlockX() + x_distance; ++x) {
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, y, loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, y, loc_1.getBlockZ()));
                if (++index <= max) continue;
                return list;
            }
            for (int z = loc_1.getBlockZ(); z < loc_1.getBlockZ() + z_distance; ++z) {
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), y, z));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), y, z));
                if (++index <= max) continue;
                return list;
            }
        }
        return list;
    }

    public ListTag getOutline() {
        int max = Settings.blockTagsMaxBlocks();
        int index = 0;
        ListTag list = new ListTag();
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            LocationTag loc_2 = pair.high;
            int y_distance = pair.yDistance();
            int z_distance = pair.zDistance();
            int x_distance = pair.xDistance();
            for (int y = loc_1.getBlockY(); y < loc_1.getBlockY() + y_distance; ++y) {
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)y, loc_1.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)y, loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)y, loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)y, loc_1.getBlockZ()));
                if (++index <= max) continue;
                return list;
            }
            for (int x = loc_1.getBlockX(); x < loc_1.getBlockX() + x_distance; ++x) {
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_1.getBlockY(), loc_1.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_1.getBlockY(), loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_2.getBlockY(), loc_2.getBlockZ()));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)x, (double)loc_2.getBlockY(), loc_1.getBlockZ()));
                if (++index <= max) continue;
                return list;
            }
            for (int z = loc_1.getBlockZ(); z < loc_1.getBlockZ() + z_distance; ++z) {
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)loc_1.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)loc_2.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_1.getBlockX(), (double)loc_2.getBlockY(), z));
                list.addObject(new LocationTag(loc_1.getWorld(), (double)loc_2.getBlockX(), (double)loc_1.getBlockY(), z));
                if (++index <= max) continue;
                return list;
            }
            list.addObject(pair.high);
        }
        return list;
    }

    @Override
    public ListTag getBlocks(Predicate<Location> test) {
        List<LocationTag> locs = this.getBlocks_internal(test);
        ListTag list = new ListTag();
        for (LocationTag loc : locs) {
            list.addObject(loc);
        }
        return list;
    }

    public List<LocationTag> getBlocks_internal(Predicate<Location> test) {
        if (test == null) {
            return this.getBlockLocationsUnfiltered(true);
        }
        int yMin = this.getWorld().getWorld().getMinHeight();
        int yMax = this.getWorld().getWorld().getMaxHeight();
        int max = Settings.blockTagsMaxBlocks();
        ArrayList<LocationTag> list = new ArrayList<LocationTag>();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.yDistance();
            int z_distance = pair.zDistance();
            int x_distance = pair.xDistance();
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    if (loc_1.getY() + (double)y < (double)yMin || loc_1.getY() + (double)y > (double)yMax) continue;
                    for (int z = 0; z != z_distance + 1; ++z) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        if (index++ > max) {
                            return list;
                        }
                        if (!test.test(loc)) continue;
                        list.add(loc);
                    }
                }
            }
        }
        return list;
    }

    public List<LocationTag> getBlockLocationsUnfiltered(boolean doMax) {
        int max = doMax ? Settings.blockTagsMaxBlocks() : Integer.MAX_VALUE;
        ArrayList<LocationTag> list = new ArrayList<LocationTag>();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            LocationTag loc_1 = pair.low;
            int y_distance = pair.yDistance();
            int z_distance = pair.zDistance();
            int x_distance = pair.xDistance();
            for (int x = 0; x <= x_distance; ++x) {
                for (int y = 0; y <= y_distance; ++y) {
                    for (int z = 0; z <= z_distance; ++z) {
                        LocationTag loc = new LocationTag(loc_1.clone().add(x, y, z));
                        list.add(loc);
                        if (index++ <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public final Collection<Entity> getEntitiesPossiblyWithin() {
        WorldTag world = this.getWorld();
        if (this.pairs.size() != 1) {
            return world.getEntities();
        }
        BoundingBox box = BoundingBox.of((Vector)this.getLow(0).toVector(), (Vector)this.getHigh(0).toVector().add(new Vector(1, 1, 1)));
        return world.getPossibleEntitiesForBoundary(box);
    }

    public Collection<Entity> getEntitiesPossiblyWithinForTag() {
        WorldTag world = this.getWorld();
        if (this.pairs.size() != 1) {
            return world.getEntitiesForTag();
        }
        BoundingBox box = BoundingBox.of((Vector)this.getLow(0).toVector(), (Vector)this.getHigh(0).toVector().add(new Vector(1, 1, 1)));
        return world.getPossibleEntitiesForBoundaryForTag(box);
    }

    @Override
    public WorldTag getWorld() {
        if (this.pairs.isEmpty()) {
            return null;
        }
        return new WorldTag(this.pairs.get((int)0).high.getWorldName());
    }

    public LocationTag getHigh(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.pairs.size()) {
            return null;
        }
        return this.pairs.get((int)index).high;
    }

    public LocationTag getLow(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.pairs.size()) {
            return null;
        }
        return this.pairs.get((int)index).low;
    }

    @Override
    public boolean isUnique() {
        return this.noteName != null;
    }

    @Override
    @Note(value="Cuboids")
    public Object getSaveObject() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("object", this.identifyFull());
        section.set("flags", this.flagTracker.toString());
        return section;
    }

    @Override
    public void makeUnique(String id) {
        CuboidTag toNote = this.clone();
        toNote.noteName = id;
        toNote.flagTracker = new SavableMapFlagTracker();
        NoteManager.saveAs(toNote, id);
    }

    @Override
    public void forget() {
        NoteManager.remove(this);
        this.noteName = null;
        this.flagTracker = null;
    }

    @Override
    public String getObjectType() {
        return "cuboid";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public CuboidTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isUnique()) {
            return "<LG>cu@<Y>" + this.noteName + " <GR>(" + this.identifyFull() + ")";
        }
        return this.identifyFull();
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "cu@" + this.noteName;
        }
        return this.identifyFull();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String identifyFull() {
        StringBuilder sb = new StringBuilder();
        sb.append("cu@").append(this.pairs.get((int)0).low.getWorldName());
        for (LocationPair pair : this.pairs) {
            sb.append(',').append(pair.low.getBlockX()).append(',').append(pair.low.getBlockY()).append(',').append(pair.low.getBlockZ()).append(',').append(pair.high.getBlockX()).append(',').append(pair.high.getBlockY()).append(',').append(pair.high.getBlockZ());
        }
        return sb.toString();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return this.flagTracker;
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
        if (this.noteName != null) {
            this.flagTracker = tracker;
        }
    }

    @Override
    public String getReasonNotFlaggable() {
        if (this.noteName == null) {
            return "the area is not noted - only noted areas can hold flags";
        }
        return "unknown reason - something went wrong";
    }

    @Override
    public CuboidTag withWorld(WorldTag world) {
        CuboidTag newCuboid = this.clone();
        for (LocationPair pair : newCuboid.pairs) {
            pair.low.setWorld(world.getWorld());
            pair.high.setWorld(world.getWorld());
        }
        return newCuboid;
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        AreaContainmentObject.registerTags(CuboidTag.class, tagProcessor);
        tagProcessor.registerTag(LocationTag.class, "random", (attribute, cuboid) -> {
            LocationPair pair = cuboid.pairs.get(CoreUtilities.getRandom().nextInt(cuboid.pairs.size()));
            Vector range = pair.high.toVector().subtract(pair.low.toVector()).add(new Vector(1, 1, 1));
            range.setX(CoreUtilities.getRandom().nextInt(range.getBlockX()));
            range.setY(CoreUtilities.getRandom().nextInt(range.getBlockY()));
            range.setZ(CoreUtilities.getRandom().nextInt(range.getBlockZ()));
            LocationTag out = pair.low.clone();
            out.add(range);
            return out;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "members_size", (attribute, cuboid) -> new ElementTag(cuboid.pairs.size()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "outline", (attribute, cuboid) -> cuboid.getOutline(), "get_outline");
        tagProcessor.registerTag(ListTag.class, "outline_2d", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("CuboidTag.outline_2d[...] tag must have an input.");
                return null;
            }
            double y = attribute.getDoubleParam();
            return cuboid.getOutline2D(y);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "intersects", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.intersects[...] must have a value.");
                return null;
            }
            CuboidTag cub2 = attribute.paramAsType(CuboidTag.class);
            if (cub2 != null) {
                boolean intersects = false;
                block0: for (LocationPair pair : cuboid.pairs) {
                    for (LocationPair pair2 : cub2.pairs) {
                        if (!pair.low.getWorld().getName().equalsIgnoreCase(pair2.low.getWorld().getName())) {
                            return new ElementTag("false");
                        }
                        if (!(pair2.low.getX() <= pair.high.getX()) || !(pair2.low.getY() <= pair.high.getY()) || !(pair2.low.getZ() <= pair.high.getZ()) || !(pair2.high.getX() >= pair.low.getX()) || !(pair2.high.getY() >= pair.low.getY()) || !(pair2.high.getZ() >= pair.low.getZ())) continue;
                        intersects = true;
                        break block0;
                    }
                }
                return new ElementTag(intersects);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "list_members", (attribute, cuboid) -> {
            List<LocationPair> pairs = cuboid.pairs;
            ListTag list = new ListTag();
            for (LocationPair pair : pairs) {
                list.addObject(new CuboidTag(pair.low.clone(), pair.high.clone()));
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "get", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.get[...] must have a value.");
                return null;
            }
            int member = attribute.getIntParam();
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            LocationPair pair = cuboid.pairs.get(member - 1);
            return new CuboidTag(pair.low.clone(), pair.high.clone());
        }, "member", "get_member");
        tagProcessor.registerTag(CuboidTag.class, "set", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.set[...] must have a value.");
                return null;
            }
            CuboidTag subCuboid = attribute.paramAsType(CuboidTag.class);
            if (!attribute.startsWith("at", 2)) {
                attribute.echoError("The tag CuboidTag.set[...] must be followed by an 'at'.");
                return null;
            }
            if (!attribute.hasContext(2)) {
                attribute.echoError("The tag CuboidTag.set[...].at[...] must have an 'at' value.");
                return null;
            }
            int member = attribute.getIntContext(2);
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            attribute.fulfill(1);
            LocationPair pair = subCuboid.pairs.get(0);
            CuboidTag cloned = cuboid.clone();
            cloned.pairs.set(member - 1, new LocationPair(pair.low.clone(), pair.high.clone()));
            return cloned;
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "add_member", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.add_member[...] must have a value.");
                return null;
            }
            cuboid = cuboid.clone();
            int member = cuboid.pairs.size() + 1;
            ObjectTag param = attribute.getParamObject();
            if (attribute.startsWith("at", 2)) {
                if (!attribute.hasContext(2)) {
                    attribute.echoError("The tag CuboidTag.add_member[...].at[...] must have an 'at' value.");
                    return null;
                }
                member = attribute.getIntContext(2);
                attribute.fulfill(1);
            }
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size() + 1) {
                member = cuboid.pairs.size() + 1;
            }
            if (!(param instanceof CuboidTag) && param.toString().startsWith("li@")) {
                for (CuboidTag subCuboid : param.asType(ListTag.class, attribute.context).filter(CuboidTag.class, attribute.context)) {
                    LocationPair pair = subCuboid.pairs.get(0);
                    cuboid.pairs.add(member - 1, new LocationPair(pair.low.clone(), pair.high.clone()));
                    ++member;
                }
            } else {
                CuboidTag subCuboid = param.asType(CuboidTag.class, attribute.context);
                LocationPair pair = subCuboid.pairs.get(0);
                cuboid.pairs.add(member - 1, new LocationPair(pair.low.clone(), pair.high.clone()));
            }
            return cuboid;
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "remove_member", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.remove_member[...] must have a value.");
                return null;
            }
            cuboid = cuboid.clone();
            int member = attribute.getIntParam();
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size() + 1) {
                member = cuboid.pairs.size() + 1;
            }
            cuboid.pairs.remove(member - 1);
            return cuboid;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "center", (attribute, cuboid) -> {
            LocationPair pair;
            if (!attribute.hasParam()) {
                pair = cuboid.pairs.get(0);
            } else {
                int member = attribute.getIntParam();
                if (member < 1) {
                    member = 1;
                }
                if (member > cuboid.pairs.size()) {
                    member = cuboid.pairs.size();
                }
                pair = cuboid.pairs.get(member - 1);
            }
            LocationTag base = pair.high.clone().add(pair.low).add(1.0, 1.0, 1.0);
            base.setX(base.getX() / 2.0);
            base.setY(base.getY() / 2.0);
            base.setZ(base.getZ() / 2.0);
            return base;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "volume", (attribute, cuboid) -> {
            LocationPair pair = cuboid.pairs.get(0);
            Location base = pair.high.clone().subtract(pair.low.clone()).add(1.0, 1.0, 1.0);
            return new ElementTag(base.getX() * base.getY() * base.getZ());
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "size", (attribute, cuboid) -> {
            LocationPair pair;
            if (!attribute.hasParam()) {
                pair = cuboid.pairs.get(0);
            } else {
                int member = attribute.getIntParam();
                if (member < 1) {
                    member = 1;
                }
                if (member > cuboid.pairs.size()) {
                    member = cuboid.pairs.size();
                }
                pair = cuboid.pairs.get(member - 1);
            }
            Location base = pair.high.clone().subtract(pair.low.clone()).add(1.0, 1.0, 1.0);
            return new LocationTag(base);
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "max", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                return cuboid.pairs.get((int)0).high;
            }
            int member = attribute.getIntParam();
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            return cuboid.pairs.get((int)(member - 1)).high;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "min", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                return cuboid.pairs.get((int)0).low;
            }
            int member = attribute.getIntParam();
            if (member < 1) {
                member = 1;
            }
            if (member > cuboid.pairs.size()) {
                member = cuboid.pairs.size();
            }
            return cuboid.pairs.get((int)(member - 1)).low;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "corners", (attribute, cuboid) -> {
            ListTag output = new ListTag();
            for (LocationPair pair : cuboid.pairs) {
                output.addObject(new LocationTag(pair.low.getX(), pair.low.getY(), pair.low.getZ(), pair.low.getWorldName()));
                output.addObject(new LocationTag(pair.high.getX(), pair.low.getY(), pair.low.getZ(), pair.low.getWorldName()));
                output.addObject(new LocationTag(pair.low.getX(), pair.low.getY(), pair.high.getZ(), pair.low.getWorldName()));
                output.addObject(new LocationTag(pair.high.getX(), pair.low.getY(), pair.high.getZ(), pair.low.getWorldName()));
                output.addObject(new LocationTag(pair.low.getX(), pair.high.getY(), pair.low.getZ(), pair.low.getWorldName()));
                output.addObject(new LocationTag(pair.high.getX(), pair.high.getY(), pair.low.getZ(), pair.low.getWorldName()));
                output.addObject(new LocationTag(pair.low.getX(), pair.high.getY(), pair.high.getZ(), pair.low.getWorldName()));
                output.addObject(new LocationTag(pair.high.getX(), pair.high.getY(), pair.high.getZ(), pair.low.getWorldName()));
            }
            return output;
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "shift", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.shift[...] must have a value.");
                return null;
            }
            LocationTag vector = attribute.paramAsType(LocationTag.class);
            if (vector != null) {
                return cuboid.shifted(vector);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "include", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.include[...] must have a value.");
                return null;
            }
            CuboidTag newCuboid = CuboidTag.valueOf(attribute.getParam(), CoreUtilities.noDebugContext);
            if (newCuboid != null) {
                return cuboid.including(newCuboid.getLow(0)).including(newCuboid.getHigh(0));
            }
            LocationTag loc = attribute.paramAsType(LocationTag.class);
            if (loc != null) {
                return cuboid.including(loc);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "include_x", (attribute, cuboid) -> {
            cuboid = cuboid.clone();
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.include_x[...] must have a value.");
                return null;
            }
            double x = attribute.getDoubleParam();
            if (x < cuboid.pairs.get((int)0).low.getX()) {
                cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), x, cuboid.pairs.get((int)0).low.getY(), cuboid.pairs.get((int)0).low.getZ());
            }
            if (x > cuboid.pairs.get((int)0).high.getX()) {
                cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), x, cuboid.pairs.get((int)0).high.getY(), cuboid.pairs.get((int)0).high.getZ());
            }
            return cuboid;
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "include_y", (attribute, cuboid) -> {
            cuboid = cuboid.clone();
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.include_y[...] must have a value.");
                return null;
            }
            double y = attribute.getDoubleParam();
            if (y < cuboid.pairs.get((int)0).low.getY()) {
                cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), y, cuboid.pairs.get((int)0).low.getZ());
            }
            if (y > cuboid.pairs.get((int)0).high.getY()) {
                cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), y, cuboid.pairs.get((int)0).high.getZ());
            }
            return cuboid;
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "include_z", (attribute, cuboid) -> {
            cuboid = cuboid.clone();
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.include_z[...] must have a value.");
                return null;
            }
            double z = attribute.getDoubleParam();
            if (z < cuboid.pairs.get((int)0).low.getZ()) {
                cuboid.pairs.get((int)0).low = new LocationTag(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), cuboid.pairs.get((int)0).low.getY(), z);
            }
            if (z > cuboid.pairs.get((int)0).high.getZ()) {
                cuboid.pairs.get((int)0).high = new LocationTag(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), cuboid.pairs.get((int)0).high.getY(), z);
            }
            return cuboid;
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "with_min", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.with_min[...] must have a value.");
                return null;
            }
            LocationTag location = attribute.paramAsType(LocationTag.class);
            return new CuboidTag(location, cuboid.pairs.get((int)0).high);
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "with_max", (attribute, cuboid) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.with_max[...] must have a value.");
                return null;
            }
            LocationTag location = attribute.paramAsType(LocationTag.class);
            return new CuboidTag(location, cuboid.pairs.get((int)0).low);
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "expand", (attribute, cuboid) -> {
            Vector expandBy;
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.expand[...] must have a value.");
                return null;
            }
            if (ArgumentHelper.matchesInteger(attribute.getParam())) {
                int val = attribute.getIntParam();
                expandBy = new Vector(val, val, val);
            } else {
                expandBy = attribute.paramAsType(LocationTag.class).toVector();
            }
            LocationPair pair = cuboid.pairs.get(0);
            return new CuboidTag(pair.low.clone().subtract(expandBy), pair.high.clone().add(expandBy));
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "expand_one_side", (attribute, cuboid) -> {
            Vector expandBy;
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.expand_one_side[...] must have a value.");
                return null;
            }
            if (ArgumentHelper.matchesInteger(attribute.getParam())) {
                int val = attribute.getIntParam();
                expandBy = new Vector(val, val, val);
            } else {
                expandBy = attribute.paramAsType(LocationTag.class).toVector();
            }
            LocationPair pair = cuboid.pairs.get(0);
            LocationTag low = pair.low.clone();
            LocationTag high = pair.high.clone();
            if (expandBy.getBlockX() < 0) {
                low.setX(low.getBlockX() + expandBy.getBlockX());
            } else {
                high.setX(high.getBlockX() + expandBy.getBlockX());
            }
            if (expandBy.getBlockY() < 0) {
                low.setY(low.getBlockY() + expandBy.getBlockY());
            } else {
                high.setY(high.getBlockY() + expandBy.getBlockY());
            }
            if (expandBy.getBlockZ() < 0) {
                low.setZ(low.getBlockZ() + expandBy.getBlockZ());
            } else {
                high.setZ(high.getBlockZ() + expandBy.getBlockZ());
            }
            return new CuboidTag(low, high);
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "shrink_one_side", (attribute, cuboid) -> {
            Vector expandBy;
            if (!attribute.hasParam()) {
                attribute.echoError("The tag CuboidTag.shrink_one_side[...] must have a value.");
                return null;
            }
            if (ArgumentHelper.matchesInteger(attribute.getParam())) {
                int val = attribute.getIntParam();
                expandBy = new Vector(val, val, val);
            } else {
                expandBy = attribute.paramAsType(LocationTag.class).toVector();
            }
            LocationPair pair = cuboid.pairs.get(0);
            LocationTag low = pair.low.clone();
            LocationTag high = pair.high.clone();
            if (expandBy.getBlockX() < 0) {
                low.setX(low.getBlockX() - expandBy.getBlockX());
            } else {
                high.setX(high.getBlockX() - expandBy.getBlockX());
            }
            if (expandBy.getBlockY() < 0) {
                low.setY(low.getBlockY() - expandBy.getBlockY());
            } else {
                high.setY(high.getBlockY() - expandBy.getBlockY());
            }
            if (expandBy.getBlockZ() < 0) {
                low.setZ(low.getBlockZ() - expandBy.getBlockZ());
            } else {
                high.setZ(high.getBlockZ() - expandBy.getBlockZ());
            }
            return new CuboidTag(low, high);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "chunks", (attribute, cuboid) -> {
            ListTag chunks = new ListTag();
            for (LocationPair pair : cuboid.pairs) {
                int minY = pair.low.getBlockY();
                ChunkTag minChunk = new ChunkTag(pair.low);
                int minX = minChunk.getX();
                int minZ = minChunk.getZ();
                if (!cuboid.isInsideCuboid(new Location(cuboid.getWorld().getWorld(), (double)(minChunk.getX() * 16), (double)minY, (double)(minChunk.getZ() * 16)))) {
                    ++minX;
                    ++minZ;
                }
                ChunkTag maxChunk = new ChunkTag(pair.high);
                int maxX = maxChunk.getX();
                int maxZ = maxChunk.getZ();
                if (cuboid.isInsideCuboid(new Location(cuboid.getWorld().getWorld(), (double)(maxChunk.getX() * 16 + 15), (double)minY, (double)(maxChunk.getZ() * 16 + 15)))) {
                    ++maxX;
                    ++maxZ;
                }
                for (int x = minX; x < maxX; ++x) {
                    for (int z = minZ; z < maxZ; ++z) {
                        chunks.addObject(new ChunkTag(cuboid.getWorld(), x, z));
                    }
                }
            }
            return chunks.deduplicate();
        }, "list_chunks");
        tagProcessor.registerTag(ListTag.class, "partial_chunks", (attribute, cuboid) -> {
            ListTag chunks = new ListTag();
            for (LocationPair pair : cuboid.pairs) {
                ChunkTag minChunk = new ChunkTag(pair.low);
                ChunkTag maxChunk = new ChunkTag(pair.high);
                for (int x = minChunk.getX(); x <= maxChunk.getX(); ++x) {
                    for (int z = minChunk.getZ(); z <= maxChunk.getZ(); ++z) {
                        chunks.addObject(new ChunkTag(cuboid.getWorld(), x, z));
                    }
                }
            }
            return chunks;
        }, "list_partial_chunks");
        tagProcessor.registerTag(ElementTag.class, "note_name", (attribute, cuboid) -> {
            String noteName = NoteManager.getSavedId(cuboid);
            if (noteName == null) {
                return null;
            }
            return new ElementTag(noteName);
        }, "notable_name");
        tagProcessor.registerTag(ElementTag.class, "full", (attribute, cuboid) -> {
            BukkitImplDeprecations.cuboidFullTag.warn(attribute.context);
            return new ElementTag(cuboid.identifyFull());
        }, new String[0]);
    }

    public CuboidTag shifted(LocationTag vec) {
        CuboidTag cuboid = this.clone();
        for (LocationPair pair : cuboid.pairs) {
            LocationTag low = pair.low.clone().add(vec.toVector());
            LocationTag high = pair.high.clone().add(vec.toVector());
            pair.regenerate(low, high);
        }
        return cuboid;
    }

    public CuboidTag including(Location loc) {
        loc = loc.clone();
        CuboidTag cuboid = this.clone();
        LocationTag low = cuboid.pairs.get((int)0).low;
        LocationTag high = cuboid.pairs.get((int)0).high;
        if (loc.getX() < low.getX()) {
            low = new LocationTag(low.getWorld(), loc.getX(), low.getY(), low.getZ());
        }
        if (loc.getY() < low.getY()) {
            low = new LocationTag(low.getWorld(), low.getX(), loc.getY(), low.getZ());
        }
        if (loc.getZ() < low.getZ()) {
            low = new LocationTag(low.getWorld(), low.getX(), low.getY(), loc.getZ());
        }
        if (loc.getX() > high.getX()) {
            high = new LocationTag(high.getWorld(), loc.getX(), high.getY(), high.getZ());
        }
        if (loc.getY() > high.getY()) {
            high = new LocationTag(high.getWorld(), high.getX(), loc.getY(), high.getZ());
        }
        if (loc.getZ() > high.getZ()) {
            high = new LocationTag(high.getWorld(), high.getX(), high.getY(), loc.getZ());
        }
        cuboid.pairs.get(0).regenerate(low, high);
        return cuboid;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (NoteManager.isExactSavedObject(this)) {
            mechanism.echoError("Cannot apply properties to noted objects.");
            return;
        }
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        LocationPair pair;
        CuboidTag subCuboid;
        int member;
        int comma;
        String value;
        if (mechanism.matches("set_member")) {
            value = mechanism.getValue().asString();
            comma = value.indexOf(44);
            member = 1;
            if (comma > 0 && !value.startsWith("cu@")) {
                member = new ElementTag(value.substring(0, comma)).asInt();
                value = value.substring(comma + 1);
            }
            subCuboid = CuboidTag.valueOf(value, mechanism.context);
            if (member < 1) {
                member = 1;
            }
            if (member > this.pairs.size()) {
                member = this.pairs.size();
            }
            pair = subCuboid.pairs.get(0);
            this.pairs.set(member - 1, new LocationPair(pair.low.clone(), pair.high.clone()));
        }
        if (mechanism.matches("add_member")) {
            value = mechanism.getValue().asString();
            comma = value.indexOf(44);
            member = this.pairs.size() + 1;
            if (comma > 0 && !value.startsWith("cu@")) {
                member = new ElementTag(value.substring(0, comma)).asInt();
                value = value.substring(comma + 1);
            }
            subCuboid = CuboidTag.valueOf(value, mechanism.context);
            if (member < 1) {
                member = 1;
            }
            if (member > this.pairs.size()) {
                member = this.pairs.size();
            }
            pair = subCuboid.pairs.get(0);
            this.pairs.add(member - 1, new LocationPair(pair.low.clone(), pair.high.clone()));
        }
        if (mechanism.matches("remove_member") && mechanism.requireInteger()) {
            int member2 = mechanism.getValue().asInt();
            if (member2 < 1) {
                member2 = 1;
            }
            if (member2 > this.pairs.size()) {
                member2 = this.pairs.size();
            }
            this.pairs.remove(member2 - 1);
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }

    @Override
    public boolean advancedMatches(String matcher) {
        String matcherLow = CoreUtilities.toLowerCase(matcher);
        if (matcherLow.equals("cuboid")) {
            return true;
        }
        return this.areaBaseAdvancedMatches(matcher);
    }

    public static class LocationPair {
        public LocationTag low;
        public LocationTag high;

        public int xDistance() {
            return this.high.getBlockX() - this.low.getBlockX();
        }

        public int yDistance() {
            return this.high.getBlockY() - this.low.getBlockY();
        }

        public int zDistance() {
            return this.high.getBlockZ() - this.low.getBlockZ();
        }

        public LocationPair(LocationTag point_1, LocationTag point_2) {
            this.regenerate(point_1, point_2);
        }

        public void regenerate(LocationTag point_1, LocationTag point_2) {
            String world = point_1.getWorldName();
            int x_high = Math.max(point_1.getBlockX(), point_2.getBlockX());
            int x_low = Math.min(point_1.getBlockX(), point_2.getBlockX());
            int y_high = Math.max(point_1.getBlockY(), point_2.getBlockY());
            int y_low = Math.min(point_1.getBlockY(), point_2.getBlockY());
            int z_high = Math.max(point_1.getBlockZ(), point_2.getBlockZ());
            int z_low = Math.min(point_1.getBlockZ(), point_2.getBlockZ());
            this.low = new LocationTag(x_low, (double)y_low, (double)z_low, world);
            this.high = new LocationTag(x_high, (double)y_high, (double)z_high, world);
        }
    }
}

