/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PotionSplashEvent;

public class PotionSplashScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PotionSplashScriptEvent instance;
    public ItemTag potion;
    public LocationTag location;
    public PotionSplashEvent event;

    public PotionSplashScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<item> splash|splashes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String iTest = path.eventArgLowerAt(0);
        if (!iTest.equals("potion") && !this.potion.tryAdvancedMatcher(iTest)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PotionSplash";
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return new EntityTag((Entity)this.event.getEntity());
            }
            case "entities": {
                ListTag entities = new ListTag();
                for (Entity e : this.event.getAffectedEntities()) {
                    entities.addObject(new EntityTag(e));
                }
                return entities;
            }
            case "location": {
                return this.location;
            }
            case "potion": {
                return this.potion;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPotionSplash(PotionSplashEvent event) {
        this.potion = new ItemTag(event.getPotion().getItem());
        this.location = new LocationTag(event.getEntity().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

