/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.BinaryTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.SecretTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.Schedulable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class WebGetCommand
extends AbstractCommand
implements Holdable {
    public static boolean patchAlreadyPatched = false;

    public WebGetCommand() {
        this.setName("webget");
        this.setSyntax("webget [<url>] (data:<data>) (method:<method>) (headers:<map>) (timeout:<duration>/{10s}) (savefile:<path>) (hide_failure)");
        this.setRequiredArguments(1, 7);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("url")) {
                scriptEntry.addObject("url", arg.getRawElement());
                continue;
            }
            if (!scriptEntry.hasObject("data") && arg.matchesPrefix("data", "post")) {
                scriptEntry.addObject("data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("method") && arg.matchesPrefix("method") && arg.matches("get", "post", "head", "options", "put", "delete", "trace", "patch")) {
                scriptEntry.addObject("method", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("hide_failure") && arg.matches("hide_failure")) {
                scriptEntry.addObject("hide_failure", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("timeout") && arg.matchesPrefix("timeout", "t") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("timeout", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("headers") && arg.matchesPrefix("headers") && arg.getValue().startsWith("map@")) {
                scriptEntry.addObject("headers", arg.asType(MapTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("headers") && arg.matchesPrefix("headers")) {
                MapTag map = new MapTag();
                for (String str : arg.asType(ListTag.class)) {
                    int ind = str.indexOf(47);
                    if (ind <= 0) continue;
                    map.putObject(str.substring(0, ind), new ElementTag(str.substring(ind + 1)));
                }
                scriptEntry.addObject("headers", map);
                continue;
            }
            if (!scriptEntry.hasObject("savefile") && arg.matchesPrefix("savefile")) {
                scriptEntry.addObject("savefile", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("url")) {
            throw new InvalidArgumentsException("Must have a valid URL!");
        }
        scriptEntry.defaultObject("timeout", new DurationTag(10));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        if (!CoreConfiguration.allowWebget) {
            Debug.echoError(scriptEntry, "WebGet disabled in config.yml!");
            return;
        }
        ElementTag originalUrl = scriptEntry.getElement("url");
        ElementTag data = scriptEntry.getElement("data");
        ElementTag method = scriptEntry.getElement("method");
        DurationTag timeout = (DurationTag)scriptEntry.getObjectTag("timeout");
        MapTag headers = (MapTag)scriptEntry.getObjectTag("headers");
        ElementTag saveFile = scriptEntry.getElement("savefile");
        ElementTag hideFailure = scriptEntry.getElement("hide_failure");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), originalUrl, data, method, timeout, saveFile, hideFailure, headers);
        }
        String urlText = originalUrl.asString();
        boolean urlIsSecret = originalUrl.canBeType(SecretTag.class);
        if (urlIsSecret) {
            SecretTag secret = originalUrl.asType(SecretTag.class, scriptEntry.context);
            if (secret == null) {
                Debug.echoError("Invalid URL SecretTag object '" + originalUrl.asString() + "' - secret not defined in 'secrets.secret'?");
                return;
            }
            urlText = secret.getValue();
        }
        MapTag newHeaders = null;
        if (headers != null) {
            newHeaders = new MapTag();
            for (Map.Entry<StringHolder, ObjectTag> entry : headers.map.entrySet()) {
                ObjectTag value = entry.getValue();
                if (value.canBeType(SecretTag.class)) {
                    SecretTag secret = value.asType(SecretTag.class, scriptEntry.context);
                    if (secret == null) {
                        Debug.echoError("Invalid header SecretTag object '" + value + "' - secret not defined in 'secrets.secret'?");
                        return;
                    }
                    value = new ElementTag(secret.getValue(), true);
                }
                newHeaders.map.put(entry.getKey(), value);
            }
        }
        MapTag headersFinal = newHeaders;
        String urlFinal = urlText;
        if (!urlFinal.startsWith("http://") && !urlFinal.startsWith("https://")) {
            Debug.echoError("Must have a valid (HTTP/HTTPS) URL! Attempted: " + originalUrl.asString());
            return;
        }
        Thread thr = new Thread(() -> this.webGet(scriptEntry, data, method, urlFinal, timeout, headersFinal, saveFile, hideFailure, urlIsSecret));
        thr.start();
    }

    public void writeToFile(InputStream in, ElementTag saveFile) throws Exception {
        int len;
        File file = new File(saveFile.asString());
        if (!DenizenCore.implementation.canWriteToFile(file)) {
            Debug.echoError("Cannot write to that file path due to security settings in Denizen/config.yml.");
            return;
        }
        FileOutputStream fout = new FileOutputStream(file);
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) > 0) {
            fout.write(buffer, 0, len);
        }
        fout.flush();
        fout.close();
    }

    public static void patchPatchMethodMethodsField() {
        if (patchAlreadyPatched) {
            return;
        }
        patchAlreadyPatched = true;
        String[] methods = (String[])ReflectionHelper.getFieldValue(HttpURLConnection.class, "methods", null);
        String[] outMethods = new String[methods.length + 1];
        System.arraycopy(methods, 0, outMethods, 0, methods.length);
        outMethods[methods.length] = "PATCH";
        ReflectionHelper.setFieldValue(HttpURLConnection.class, "methods", null, outMethods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webGet(final ScriptEntry scriptEntry, ElementTag data, ElementTag method, String urlText, DurationTag timeout, MapTag headers, final ElementTag saveFile, ElementTag hideFailure, boolean urlIsSecret) {
        BufferedReader buffIn = null;
        HttpURLConnection uc = null;
        try {
            Object buffer;
            final long timeStart = CoreUtilities.monotonicMillis();
            URL url = new URL(urlText.replace(" ", "%20"));
            uc = (HttpURLConnection)url.openConnection();
            uc.setDoInput(true);
            uc.setDoOutput(true);
            if (method != null) {
                if (CoreUtilities.equalsIgnoreCase(method.asString(), "patch")) {
                    WebGetCommand.patchPatchMethodMethodsField();
                }
                uc.setRequestMethod(method.asString().toUpperCase());
            } else if (data != null) {
                uc.setRequestMethod("POST");
            }
            if (headers != null) {
                for (Map.Entry<StringHolder, ObjectTag> pair : headers.map.entrySet()) {
                    uc.setRequestProperty(pair.getKey().str, pair.getValue().toString());
                }
            }
            uc.setConnectTimeout((int)timeout.getMillis());
            uc.connect();
            if (data != null) {
                uc.getOutputStream().write(data.asString().getBytes(StandardCharsets.UTF_8));
            }
            final int status = uc.getResponseCode();
            byte[] result = null;
            if (saveFile != null) {
                this.writeToFile(uc.getInputStream(), saveFile);
            } else {
                int len;
                InputStream stream = uc.getInputStream();
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                buffer = new byte[1024];
                while ((len = stream.read((byte[])buffer, 0, 1024)) != -1) {
                    bytesOut.write((byte[])buffer, 0, len);
                }
                result = bytesOut.toByteArray();
                bytesOut.close();
                stream.close();
            }
            final byte[] outResult = result;
            final MapTag resultHeaders = new MapTag();
            buffer = uc.getHeaderFields().entrySet().iterator();
            while (buffer.hasNext()) {
                Map.Entry header = (Map.Entry)buffer.next();
                String key = (String)header.getKey();
                if (key == null) {
                    key = "null";
                }
                resultHeaders.putObject(key, new ListTag((List)header.getValue()));
            }
            final long timeDone = CoreUtilities.monotonicMillis();
            DenizenCore.schedule(new Schedulable(){

                @Override
                public boolean tick(float seconds) {
                    scriptEntry.addObject("status", new ElementTag(status));
                    scriptEntry.addObject("failed", new ElementTag(status >= 200 && status < 400 ? "false" : "true"));
                    if (saveFile == null) {
                        if (outResult != null) {
                            scriptEntry.addObject("result", new ElementTag(new String(outResult, StandardCharsets.UTF_8)));
                            scriptEntry.addObject("result_binary", new BinaryTag(outResult));
                        }
                        scriptEntry.addObject("result_headers", resultHeaders);
                    }
                    scriptEntry.addObject("time_ran", new DurationTag((double)(timeDone - timeStart) / 1000.0));
                    scriptEntry.setFinished(true);
                    return false;
                }
            });
        }
        catch (Exception e) {
            byte[] result;
            int tempStatus;
            block39: {
                if (hideFailure == null || !hideFailure.asBoolean()) {
                    if (urlIsSecret) {
                        Debug.echoError("WebGet encountered an exception of type '" + e.getClass().getCanonicalName() + "' but hid the exception text due to secret URL presence.");
                    } else {
                        Debug.echoError(e);
                    }
                }
                tempStatus = -1;
                result = null;
                if (uc != null) {
                    try {
                        int len;
                        tempStatus = uc.getResponseCode();
                        InputStream errorStream = uc.getErrorStream();
                        if (errorStream == null) break block39;
                        if (saveFile != null) {
                            this.writeToFile(errorStream, saveFile);
                            break block39;
                        }
                        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        while ((len = errorStream.read(buffer, 0, 1024)) != -1) {
                            bytesOut.write(buffer, 0, len);
                        }
                        result = bytesOut.toByteArray();
                        bytesOut.close();
                        errorStream.close();
                    }
                    catch (Exception e2) {
                        if (urlIsSecret) {
                            Debug.echoError("WebGet encountered an exception of type '" + e2.getClass().getCanonicalName() + "' but hid the exception text due to secret URL presence.");
                            break block39;
                        }
                        Debug.echoError(e2);
                    }
                } else if (hideFailure != null && hideFailure.asBoolean()) {
                    if (urlIsSecret) {
                        Debug.echoError("WebGet encountered an exception of type '" + e.getClass().getCanonicalName() + "' but hid the exception text due to secret URL presence.");
                    } else {
                        Debug.echoError(e);
                    }
                }
            }
            final byte[] outResult = result;
            final int status = tempStatus;
            DenizenCore.schedule(new Schedulable(){

                @Override
                public boolean tick(float seconds) {
                    scriptEntry.addObject("failed", new ElementTag("true"));
                    if (status != -1) {
                        scriptEntry.addObject("status", new ElementTag(status));
                        if (saveFile == null && outResult != null) {
                            scriptEntry.addObject("result", new ElementTag(new String(outResult, StandardCharsets.UTF_8)));
                            scriptEntry.addObject("result_binary", new BinaryTag(outResult));
                        }
                    }
                    scriptEntry.setFinished(true);
                    return false;
                }
            });
        }
        finally {
            try {
                if (buffIn != null) {
                    buffIn.close();
                }
            }
            catch (Exception e) {
                if (urlIsSecret) {
                    Debug.echoError("WebGet encountered an exception of type '" + e.getClass().getCanonicalName() + "' but hid the exception text due to secret URL presence.");
                }
                Debug.echoError(e);
            }
        }
    }
}

