/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class EntityEquipment
implements Property {
    public static final String[] handledMechs = new String[]{"equipment"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).isLivingEntity();
    }

    public static EntityEquipment getFrom(ObjectTag entity) {
        if (!EntityEquipment.describes(entity)) {
            return null;
        }
        return new EntityEquipment((EntityTag)entity);
    }

    private EntityEquipment(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return this.entity.getEquipment().identify();
    }

    @Override
    public String getPropertyId() {
        return "equipment";
    }

    public static void registerTags() {
        PropertyParser.registerTag(ObjectTag.class, "equipment", (attribute, object) -> {
            org.bukkit.inventory.EntityEquipment equipment = object.entity.getLivingEntity().getEquipment();
            if (attribute.startsWith("equipment.boots")) {
                BukkitImplDeprecations.entityEquipmentSubtags.warn(attribute.context);
                attribute.fulfill(1);
                ItemStack boots = equipment.getBoots();
                return new ItemTag(boots != null ? boots : new ItemStack(Material.AIR));
            }
            if (attribute.startsWith("equipment.chestplate") || attribute.startsWith("equipment.chest")) {
                BukkitImplDeprecations.entityEquipmentSubtags.warn(attribute.context);
                attribute.fulfill(1);
                ItemStack chestplate = equipment.getChestplate();
                return new ItemTag(chestplate != null ? chestplate : new ItemStack(Material.AIR));
            }
            if (attribute.startsWith("equipment.helmet") || attribute.startsWith("equipment.head")) {
                BukkitImplDeprecations.entityEquipmentSubtags.warn(attribute.context);
                attribute.fulfill(1);
                ItemStack helmet = equipment.getHelmet();
                return new ItemTag(helmet != null ? helmet : new ItemStack(Material.AIR));
            }
            if (attribute.startsWith("equipment.leggings") || attribute.startsWith("equipment.legs")) {
                BukkitImplDeprecations.entityEquipmentSubtags.warn(attribute.context);
                attribute.fulfill(1);
                ItemStack leggings = equipment.getLeggings();
                return new ItemTag(leggings != null ? leggings : new ItemStack(Material.AIR));
            }
            return object.entity.getEquipment();
        }, new String[0]);
        PropertyParser.registerTag(MapTag.class, "equipment_map", (attribute, object) -> {
            MapTag output = new MapTag();
            org.bukkit.inventory.EntityEquipment equip = object.entity.getLivingEntity().getEquipment();
            InventoryTag.addToMapIfNonAir(output, "boots", equip.getBoots());
            InventoryTag.addToMapIfNonAir(output, "leggings", equip.getLeggings());
            InventoryTag.addToMapIfNonAir(output, "chestplate", equip.getChestplate());
            InventoryTag.addToMapIfNonAir(output, "helmet", equip.getHelmet());
            return output;
        }, new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("equipment") && mechanism.hasValue()) {
            org.bukkit.inventory.EntityEquipment equip = this.entity.getLivingEntity().getEquipment();
            if (mechanism.value.canBeType(MapTag.class)) {
                ItemTag helmet;
                ItemTag chestplate;
                ItemTag leggings;
                MapTag map = mechanism.valueAsType(MapTag.class);
                ItemTag boots = map.getObjectAs("boots", ItemTag.class, mechanism.context);
                if (boots != null) {
                    ItemStack bootsItem = boots.getItemStack();
                    if (this.entity.isCitizensNPC()) {
                        this.entity.getDenizenNPC().getEquipmentTrait().set(Equipment.EquipmentSlot.BOOTS, bootsItem);
                    } else {
                        equip.setBoots(bootsItem);
                    }
                }
                if ((leggings = map.getObjectAs("leggings", ItemTag.class, mechanism.context)) != null) {
                    ItemStack leggingsItem = leggings.getItemStack();
                    if (this.entity.isCitizensNPC()) {
                        this.entity.getDenizenNPC().getEquipmentTrait().set(Equipment.EquipmentSlot.LEGGINGS, leggingsItem);
                    } else {
                        equip.setLeggings(leggingsItem);
                    }
                }
                if ((chestplate = map.getObjectAs("chestplate", ItemTag.class, mechanism.context)) != null) {
                    ItemStack chestplateItem = chestplate.getItemStack();
                    if (this.entity.isCitizensNPC()) {
                        this.entity.getDenizenNPC().getEquipmentTrait().set(Equipment.EquipmentSlot.CHESTPLATE, chestplateItem);
                    } else {
                        equip.setChestplate(chestplateItem);
                    }
                }
                if ((helmet = map.getObjectAs("helmet", ItemTag.class, mechanism.context)) != null) {
                    ItemStack helmetItem = helmet.getItemStack();
                    if (this.entity.isCitizensNPC()) {
                        this.entity.getDenizenNPC().getEquipmentTrait().set(Equipment.EquipmentSlot.HELMET, helmetItem);
                    } else {
                        equip.setHelmet(helmetItem);
                    }
                }
            } else {
                ListTag list = mechanism.valueAsType(ListTag.class);
                ItemStack[] stacks = new ItemStack[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    stacks[i] = ItemTag.valueOf(list.get(i), mechanism.context).getItemStack();
                }
                equip.setArmorContents(stacks);
            }
        }
    }
}

