/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import net.citizensnpcs.trait.Age;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Breedable;

public class EntityAge
implements Property {
    public static final String[] handledMechs = new String[]{"age_lock", "age"};
    EntityTag ageable;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Ageable;
    }

    public static EntityAge getFrom(ObjectTag entity) {
        if (!EntityAge.describes(entity)) {
            return null;
        }
        return new EntityAge((EntityTag)entity);
    }

    private EntityAge(EntityTag entity) {
        this.ageable = entity;
    }

    public void setAge(int val) {
        if (this.ageable.isCitizensNPC()) {
            ((Age)this.ageable.getDenizenNPC().getCitizen().getOrAddTrait(Age.class)).setAge(val);
        } else {
            this.getAgeable().setAge(val);
        }
    }

    public void setLock(boolean bool) {
        if (this.isBreedable()) {
            this.getBreedable().setAgeLock(bool);
        }
    }

    public boolean getLock() {
        return !this.isBreedable() || this.getBreedable().getAgeLock();
    }

    public boolean isBreedable() {
        return this.ageable.getBukkitEntity() instanceof Breedable;
    }

    public Ageable getAgeable() {
        return (Ageable)this.ageable.getBukkitEntity();
    }

    public Breedable getBreedable() {
        return (Breedable)this.ageable.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        return this.getAgeable().getAge() + (this.getLock() ? "|locked" : "");
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    public static void registerTags() {
        PropertyParser.registerTag(ElementTag.class, "age", (attribute, object) -> new ElementTag(object.getAgeable().getAge()), new String[0]);
        PropertyParser.registerTag(ElementTag.class, "is_age_locked", (attribute, object) -> new ElementTag(object.getLock()), new String[0]);
        PropertyParser.registerTag(ElementTag.class, "is_baby", (attribute, object) -> new ElementTag(!object.getAgeable().isAdult()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("age_lock") && mechanism.requireBoolean()) {
            this.setLock(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("age") && mechanism.requireObject(ListTag.class)) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            if (list.isEmpty()) {
                mechanism.echoError("Missing value for 'age' mechanism!");
                return;
            }
            String input = list.get(0);
            if (input.equalsIgnoreCase("baby")) {
                this.setAge(-24000);
            } else if (input.equalsIgnoreCase("adult")) {
                this.setAge(0);
            } else if (ArgumentHelper.matchesInteger(input)) {
                this.setAge(new ElementTag(input).asInt());
            } else {
                mechanism.echoError("Invalid age '" + input + "': must be 'baby', 'adult', or a valid age number.");
            }
            if (list.size() > 1) {
                input = list.get(1);
                if (input.equalsIgnoreCase("locked")) {
                    this.setLock(true);
                } else if (input.equalsIgnoreCase("unlocked")) {
                    this.setLock(false);
                } else {
                    mechanism.echoError("Invalid lock state '" + input + "': must be 'locked' or 'unlocked'.");
                }
            }
        }
    }
}

