/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.Note;
import org.bukkit.block.data.type.NoteBlock;

public class MaterialNote
implements Property {
    public static final String[] handledMechs = new String[]{"note"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData() instanceof NoteBlock;
    }

    public static MaterialNote getFrom(ObjectTag _material) {
        if (!MaterialNote.describes(_material)) {
            return null;
        }
        return new MaterialNote((MaterialTag)_material);
    }

    private MaterialNote(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(MaterialNote.class, ElementTag.class, "note_octave", (attribute, material) -> new ElementTag(material.getNoteBlock().getNote().getOctave()), new String[0]);
        PropertyParser.registerStaticTag(MaterialNote.class, ElementTag.class, "note_tone", (attribute, material) -> {
            Note note = material.getNoteBlock().getNote();
            return new ElementTag(note.getTone().name() + (note.isSharped() ? "#" : ""));
        }, new String[0]);
        PropertyParser.registerStaticTag(MaterialNote.class, ElementTag.class, "note", (attribute, material) -> new ElementTag(material.getNoteBlock().getNote().getId()), new String[0]);
    }

    public NoteBlock getNoteBlock() {
        return (NoteBlock)this.material.getModernData();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getNoteBlock().getNote().getId());
    }

    @Override
    public String getPropertyId() {
        return "note";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("note") && mechanism.requireInteger()) {
            this.getNoteBlock().setNote(new Note(mechanism.getValue().asInt()));
        }
    }
}

