/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.Block;
import org.bukkit.entity.Raider;

public class EntityPatrolTarget
implements Property {
    public static final String[] handledMechs = new String[]{"patrol_target"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Raider;
    }

    public static EntityPatrolTarget getFrom(ObjectTag entity) {
        if (!EntityPatrolTarget.describes(entity)) {
            return null;
        }
        return new EntityPatrolTarget((EntityTag)entity);
    }

    private EntityPatrolTarget(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        Block target = ((Raider)this.entity.getBukkitEntity()).getPatrolTarget();
        if (target == null) {
            return null;
        }
        return new LocationTag(target.getLocation()).identify();
    }

    @Override
    public String getPropertyId() {
        return "patrol_target";
    }

    public static void registerTags() {
        PropertyParser.registerTag(EntityPatrolTarget.class, LocationTag.class, "patrol_target", (attribute, object) -> {
            Block target = ((Raider)object.entity.getBukkitEntity()).getPatrolTarget();
            if (target == null) {
                return null;
            }
            return new LocationTag(target.getLocation());
        }, new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("patrol_target")) {
            if (mechanism.hasValue() && mechanism.requireObject(LocationTag.class)) {
                ((Raider)this.entity.getBukkitEntity()).setPatrolTarget(mechanism.valueAsType(LocationTag.class).getBlock());
            } else {
                ((Raider)this.entity.getBukkitEntity()).setPatrolTarget(null);
            }
        }
    }
}

