/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.npc.traits.HungerTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class FeedCommand
extends AbstractCommand {
    public FeedCommand() {
        this.setName("feed");
        this.setSyntax("feed (<entity>) (amount:<#>) (saturation:<#.#>)");
        this.setRequiredArguments(0, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (arg.matchesInteger() && arg.matchesPrefix("amount", "amt", "quantity", "qty", "a", "q") && !scriptEntry.hasObject("amount")) {
                scriptEntry.addObject("amount", arg.asElement());
                continue;
            }
            if (arg.matchesInteger() && arg.matchesPrefix("saturation", "sat", "s") && !scriptEntry.hasObject("saturation")) {
                scriptEntry.addObject("saturation", arg.asElement());
                continue;
            }
            if (arg.matchesArgumentType(PlayerTag.class) && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc")) {
                scriptEntry.addObject("targetplayer", arg.asType(PlayerTag.class));
                continue;
            }
            if (Depends.citizens != null && arg.matchesArgumentType(NPCTag.class) && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc")) {
                scriptEntry.addObject("targetnpc", arg.asType(NPCTag.class));
                continue;
            }
            if (arg.matches("npc") && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc") && Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("targetnpc", Utilities.getEntryNPC(scriptEntry));
                continue;
            }
            if (arg.matches("player") && !scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc") && Utilities.entryHasPlayer(scriptEntry)) {
                scriptEntry.addObject("targetplayer", Utilities.getEntryPlayer(scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("targetplayer") && !scriptEntry.hasObject("targetnpc")) {
            if (Utilities.entryHasPlayer(scriptEntry)) {
                scriptEntry.addObject("targetplayer", Utilities.getEntryPlayer(scriptEntry));
            } else if (Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("targetnpc", Utilities.getEntryNPC(scriptEntry));
            } else {
                throw new InvalidArgumentsException("Must specify a player!");
            }
        }
        scriptEntry.defaultObject("amount", new ElementTag(20));
        scriptEntry.defaultObject("saturation", scriptEntry.getObject("amount"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        PlayerTag player = (PlayerTag)scriptEntry.getObjectTag("targetplayer");
        NPCTag npc = (NPCTag)scriptEntry.getObjectTag("targetnpc");
        ElementTag amount = scriptEntry.getElement("amount");
        ElementTag saturation = scriptEntry.getElement("saturation");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), player, npc, amount, saturation);
        }
        if (npc != null) {
            if (!npc.getCitizen().hasTrait(HungerTrait.class)) {
                Debug.echoError(scriptEntry, "This NPC does not have the HungerTrait enabled! Use /trait hunger");
                return;
            }
            ((HungerTrait)npc.getCitizen().getOrAddTrait(HungerTrait.class)).feed(amount.asInt());
        } else {
            int result = Math.max(0, Math.min(20, player.getPlayerEntity().getFoodLevel() + amount.asInt()));
            player.getPlayerEntity().setFoodLevel(result);
            float satResult = Math.max(0.0f, Math.min(20.0f, player.getPlayerEntity().getSaturation() + saturation.asFloat()));
            player.getPlayerEntity().setSaturation(satResult);
            Debug.echoDebug((Debuggable)scriptEntry, "Player food level updated to " + result + " food and " + satResult + " saturation.");
        }
    }
}

