/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgRaw;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;

public class GotoCommand
extends AbstractCommand {
    public GotoCommand() {
        this.setName("goto");
        this.setSyntax("goto [<name>]");
        this.setRequiredArguments(1, 1);
        this.isProcedural = true;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgRaw @ArgLinear @ArgName(value="mark_name") String markName) {
        boolean hasmark = false;
        for (int i = 0; i < scriptEntry.getResidingQueue().getQueueSize(); ++i) {
            ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(i);
            List<String> args = entry.getOriginalArguments();
            if (!CoreUtilities.equalsIgnoreCase(entry.getCommandName(), "mark") || args.size() <= 0 || !CoreUtilities.equalsIgnoreCase(args.get(0), markName)) continue;
            hasmark = true;
            break;
        }
        if (hasmark) {
            while (scriptEntry.getResidingQueue().getQueueSize() > 0) {
                ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(0);
                List<String> args = entry.getOriginalArguments();
                if (!CoreUtilities.equalsIgnoreCase(entry.getCommandName(), "mark") || args.size() <= 0 || !CoreUtilities.equalsIgnoreCase(args.get(0), markName)) {
                    scriptEntry.getResidingQueue().removeFirst();
                    continue;
                }
                break;
            }
        } else {
            Debug.echoError(scriptEntry, "Cannot go to that location - doesn't seem to exist!");
        }
    }
}

