/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.entity.AreaEffectCloudHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;

public class EntityAreaEffectCloud
implements Property {
    public static final String[] handledTags = new String[]{"base_potion", "particle", "duration", "radius", "reapplication_delay", "wait_time", "has_custom_effect", "source", "custom_effects"};
    public static final String[] handledMechs = new String[]{"clear_custom_effects", "remove_custom_effect", "custom_effects", "particle_color", "base_potion", "duration", "duration_on_use", "particle", "radius", "radius_on_use", "radius_per_tick", "reapplication_delay", "source", "wait_time"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntityType() == EntityType.AREA_EFFECT_CLOUD;
    }

    public static EntityAreaEffectCloud getFrom(ObjectTag entity) {
        if (!EntityAreaEffectCloud.describes(entity)) {
            return null;
        }
        return new EntityAreaEffectCloud((EntityTag)entity);
    }

    private EntityAreaEffectCloud(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "area_effect_cloud";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        ProjectileSource shooter;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("base_potion")) {
            if ((attribute = attribute.fulfill(1)).startsWith("type")) {
                return new ElementTag(this.getHelper().getBPName()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_upgraded")) {
                return new ElementTag(this.getHelper().getBPUpgraded()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_extended")) {
                return new ElementTag(this.getHelper().getBPExtended()).getObjectAttribute(attribute.fulfill(1));
            }
            return new ElementTag(this.getHelper().getBPName() + "," + this.getHelper().getBPUpgraded() + "," + this.getHelper().getBPExtended()).getObjectAttribute(attribute);
        }
        if (attribute.startsWith("particle")) {
            if ((attribute = attribute.fulfill(1)).startsWith("color")) {
                return new ColorTag(this.getHelper().getColor()).getObjectAttribute(attribute.fulfill(1));
            }
            return new ElementTag(this.getHelper().getParticle()).getObjectAttribute(attribute);
        }
        if (attribute.startsWith("duration")) {
            if ((attribute = attribute.fulfill(1)).startsWith("on_use")) {
                return new DurationTag(this.getHelper().getDurationOnUse()).getObjectAttribute(attribute.fulfill(1));
            }
            return new DurationTag(this.getHelper().getDuration()).getObjectAttribute(attribute);
        }
        if (attribute.startsWith("radius")) {
            if ((attribute = attribute.fulfill(1)).startsWith("on_use")) {
                return new ElementTag(this.getHelper().getRadiusOnUse()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("per_tick")) {
                return new ElementTag(this.getHelper().getRadiusPerTick()).getObjectAttribute(attribute.fulfill(1));
            }
            return new ElementTag(this.getHelper().getRadius()).getObjectAttribute(attribute);
        }
        if (attribute.startsWith("reapplication_delay")) {
            return new DurationTag(this.getHelper().getReappDelay()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("wait_time")) {
            return new DurationTag(this.getHelper().getWaitTime()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_custom_effect")) {
            if (attribute.hasParam()) {
                PotionEffectType effectType = PotionEffectType.getByName((String)attribute.getParam());
                for (PotionEffect effect : this.getHelper().getCustomEffects()) {
                    if (!effect.getType().equals((Object)effectType)) continue;
                    return new ElementTag(true).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(false).getObjectAttribute(attribute.fulfill(1));
            }
            return new ElementTag(this.getHelper().hasCustomEffects()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("source") && (shooter = this.getHelper().getSource()) instanceof LivingEntity) {
            return new EntityTag((Entity)((LivingEntity)shooter)).getDenizenObject().getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("custom_effects")) {
            List<PotionEffect> effects = this.getHelper().getCustomEffects();
            if (!attribute.hasParam()) {
                ListTag list = new ListTag();
                for (PotionEffect effect : effects) {
                    list.add(effect.getType().getName() + "," + effect.getAmplifier() + "," + new DurationTag((long)effect.getDuration()).identify() + "," + effect.isAmbient() + "," + effect.hasParticles());
                }
                return list.getObjectAttribute(attribute.fulfill(1));
            }
            int val = attribute.getIntParam() - 1;
            if (val < 0 || val >= effects.size()) {
                return null;
            }
            attribute = attribute.fulfill(1);
            PotionEffect effect = effects.get(val);
            if (attribute.startsWith("type")) {
                return new ElementTag(effect.getType().getName()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("amplifier")) {
                return new ElementTag(effect.getAmplifier()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("duration")) {
                return new DurationTag((long)effect.getDuration()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("has_particles")) {
                return new ElementTag(effect.hasParticles()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_ambient")) {
                return new ElementTag(effect.isAmbient()).getObjectAttribute(attribute.fulfill(1));
            }
            return new ElementTag(effect.getType().getName() + "," + effect.getAmplifier() + "," + new DurationTag((long)effect.getDuration()).identify() + "," + effect.isAmbient() + "," + effect.hasParticles()).getObjectAttribute(attribute);
        }
        return null;
    }

    public AreaEffectCloudHelper getHelper() {
        return new AreaEffectCloudHelper(this.entity.getBukkitEntity());
    }

    @Override
    public void adjust(Mechanism mechanism) {
        PotionEffectType type;
        if (mechanism.matches("clear_custom_effects")) {
            this.getHelper().clearEffects();
        }
        if (mechanism.matches("remove_custom_effect") && (type = PotionEffectType.getByName((String)mechanism.getValue().asString().toUpperCase())) != null) {
            this.getHelper().removeEffect(type);
        }
        if (mechanism.matches("custom_effects")) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            this.getHelper().clearEffects();
            for (String item : list) {
                List<String> potionData = CoreUtilities.split(item, ',', 5);
                if (potionData.size() >= 3) {
                    PotionEffectType type2 = PotionEffectType.getByName((String)potionData.get(0));
                    ElementTag amplifier = new ElementTag(potionData.get(1));
                    DurationTag duration = DurationTag.valueOf(potionData.get(2), mechanism.context);
                    ElementTag ambient = new ElementTag(potionData.size() > 3 ? potionData.get(3) : "false");
                    ElementTag particles = new ElementTag(potionData.size() > 4 ? potionData.get(4) : "true");
                    if (!(type2 != null && duration != null && amplifier.isInt() && ambient.isBoolean() && particles.isBoolean())) {
                        mechanism.echoError(item + " is not a valid potion effect!");
                        continue;
                    }
                    this.getHelper().addEffect(new PotionEffect(type2, duration.getTicksAsInt(), amplifier.asInt(), ambient.asBoolean(), particles.asBoolean()), true);
                    continue;
                }
                mechanism.echoError(item + " is not a valid potion effect!");
            }
        }
        if (mechanism.matches("particle_color") && mechanism.requireObject(ColorTag.class)) {
            this.getHelper().setColor(mechanism.valueAsType(ColorTag.class).getColor());
        }
        if (mechanism.matches("base_potion")) {
            List<String> data = CoreUtilities.split(mechanism.getValue().asString().toUpperCase(), ',');
            if (data.size() != 3) {
                mechanism.echoError(mechanism.getValue().asString() + " is not a valid base potion!");
            } else {
                try {
                    boolean upgraded;
                    PotionType type3 = PotionType.valueOf((String)data.get(0));
                    boolean extended = type3.isExtendable() && CoreUtilities.equalsIgnoreCase(data.get(1), "true");
                    boolean bl = upgraded = type3.isUpgradeable() && CoreUtilities.equalsIgnoreCase(data.get(2), "true");
                    if (extended && upgraded) {
                        mechanism.echoError("Potion cannot be both upgraded and extended");
                    } else {
                        this.getHelper().setBP(type3, extended, upgraded);
                    }
                }
                catch (Exception e) {
                    mechanism.echoError(mechanism.getValue().asString() + " is not a valid base potion!");
                }
            }
        }
        if (mechanism.matches("duration") && mechanism.requireObject(DurationTag.class)) {
            this.getHelper().setDuration(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("duration_on_use") && mechanism.requireObject(DurationTag.class)) {
            this.getHelper().setDurationOnUse(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("particle") && mechanism.hasValue()) {
            this.getHelper().setParticle(mechanism.getValue().asString().toUpperCase());
        }
        if (mechanism.matches("radius") && mechanism.requireFloat()) {
            this.getHelper().setRadius(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("radius_on_use") && mechanism.requireFloat()) {
            this.getHelper().setRadiusOnUse(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("radius_per_tick") && mechanism.requireFloat()) {
            this.getHelper().setRadiusPerTick(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("reapplication_delay") && mechanism.requireObject(DurationTag.class)) {
            this.getHelper().setReappDelay(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("source") && mechanism.requireObject(EntityTag.class)) {
            this.getHelper().setSource((ProjectileSource)mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("wait_time") && mechanism.requireObject(DurationTag.class)) {
            this.getHelper().setWaitTime(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
    }
}

