/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalCreateScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ElementTag reason;
    public PortalCreateEvent event;

    public PortalCreateScriptEvent() {
        this.registerCouldMatcher("portal created (because <'reason'>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(2).equals("because") && !PortalCreateScriptEvent.runGenericCheck(path.eventArgLowerAt(3), this.reason.asString())) {
            return false;
        }
        if (!this.runInCheck(path, ((BlockState)this.event.getBlocks().get(0)).getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.event.getEntity() != null ? new EntityTag(this.event.getEntity()).getDenizenObject() : null;
            }
            case "world": {
                return new WorldTag(this.event.getWorld());
            }
            case "reason": {
                return this.reason;
            }
            case "blocks": {
                ListTag blocks = new ListTag();
                for (BlockState blockState : this.event.getBlocks()) {
                    blocks.addObject(new LocationTag(blockState.getLocation()));
                }
                return blocks;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPortalCreate(PortalCreateEvent event) {
        this.reason = new ElementTag(event.getReason().name());
        this.event = event;
        this.fire((Event)event);
    }
}

