/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.speech;

import com.denizenscript.denizen.npc.speech.DenizenSpeechContext;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.speech.SpeechController;
import net.citizensnpcs.api.ai.speech.event.NPCSpeechEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

public class DenizenSpeechController
implements SpeechController {
    private Entity entity;
    private boolean isNPC;

    public DenizenSpeechController(Entity entity) {
        this.entity = entity;
        this.isNPC = CitizensAPI.getNPCRegistry().isNPC(entity);
    }

    public void speak(DenizenSpeechContext context) {
        context.setTalker(this.entity);
        if (this.isNPC) {
            NPCSpeechEvent event = new NPCSpeechEvent((SpeechContext)context, "denizen_chat");
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        CitizensAPI.getSpeechFactory().getVocalChord("denizen_chat").talk((SpeechContext)context);
    }

    public void speak(SpeechContext context) {
        if (context instanceof DenizenSpeechContext) {
            this.speak((DenizenSpeechContext)context);
        } else {
            this.speak(context, "chat");
        }
    }

    public void speak(SpeechContext context, String vocalChordName) {
        context.setTalker(this.entity);
        if (this.isNPC) {
            NPCSpeechEvent event = new NPCSpeechEvent(context, vocalChordName);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            vocalChordName = event.getVocalChordName();
        }
        CitizensAPI.getSpeechFactory().getVocalChord(vocalChordName).talk(context);
    }
}

