/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.inventory.InventoryContents;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.inventory.InventoryHolder;

public class EntityInventory
implements Property {
    public static final String[] handledTags = new String[]{"inventory"};
    public static final String[] handledMechs = new String[]{"inventory_contents"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof InventoryHolder;
    }

    public static EntityInventory getFrom(ObjectTag entity) {
        if (!EntityInventory.describes(entity)) {
            return null;
        }
        return new EntityInventory((EntityTag)entity);
    }

    private EntityInventory(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return new InventoryContents(this.entity.getInventory()).getContents(false).identify();
    }

    @Override
    public String getPropertyId() {
        return "inventory_contents";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("inventory")) {
            InventoryTag inventory = this.entity.getInventory();
            if (inventory != null) {
                return inventory.getObjectAttribute(attribute.fulfill(1));
            }
            return null;
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("inventory_contents")) {
            ListTag list = ListTag.valueOf(mechanism.getValue().asString(), mechanism.context);
            InventoryTag inv = this.entity.getInventory();
            inv.clear();
            int i = 0;
            for (String str : list) {
                inv.setSlots(i, ItemTag.valueOf(str, mechanism.context).getItemStack());
                ++i;
            }
        }
    }
}

