/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.CustomScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.DataScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.ProcedureScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.WorldScriptContainer;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.lang.invoke.MethodHandle;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptRegistry {
    public static Map<String, ScriptContainer> scriptContainers = new HashMap<String, ScriptContainer>();
    public static Map<String, MethodHandle> typeConstructors = new HashMap<String, MethodHandle>();
    public static ArrayList<Map.Entry<String, YamlConfiguration>> toPostLoadAttempt = new ArrayList();

    public static void _registerType(String typeName, Class<? extends ScriptContainer> scriptContainerClass) {
        typeConstructors.put(CoreUtilities.toLowerCase(typeName), ReflectionHelper.getConstructor(scriptContainerClass, YamlConfiguration.class, String.class));
    }

    public static void _registerCoreTypes() {
        ScriptRegistry._registerType("custom", CustomScriptContainer.class);
        ScriptRegistry._registerType("task", TaskScriptContainer.class);
        ScriptRegistry._registerType("procedure", ProcedureScriptContainer.class);
        ScriptRegistry._registerType("world", WorldScriptContainer.class);
        ScriptRegistry._registerType("data", DataScriptContainer.class);
        ScriptRegistry._registerType("yaml data", DataScriptContainer.class);
    }

    public static boolean containsScript(String id, Class scriptContainerType) {
        if (!scriptContainers.containsKey(CoreUtilities.toLowerCase(id))) {
            return false;
        }
        ScriptContainer script = scriptContainers.get(CoreUtilities.toLowerCase(id));
        return scriptContainerType.isInstance(script);
    }

    public static void postLoadScripts() {
        try {
            for (Map.Entry<String, YamlConfiguration> script : toPostLoadAttempt) {
                ScriptRegistry.attemptLoadSingle(script.getValue(), script.getKey(), true);
            }
        }
        finally {
            toPostLoadAttempt.clear();
        }
    }

    public static void attemptLoadSingle(YamlConfiguration script, String scriptName, boolean shouldErrorOnType) {
        String type = script.getString("type");
        if (type == null) {
            Debug.echoError("Found type-less container: '<Y>" + scriptName + "<W>'.");
            ScriptHelper.setHadError();
            return;
        }
        if (!typeConstructors.containsKey(type = CoreUtilities.toLowerCase(type))) {
            if (shouldErrorOnType) {
                Debug.echoError("Trying to load an invalid script. '<A>" + scriptName + "<Y>(" + type + ")<W>' is an unknown type.");
                ScriptHelper.setHadError();
            } else {
                toPostLoadAttempt.add(new AbstractMap.SimpleEntry<String, YamlConfiguration>(scriptName, script));
            }
            return;
        }
        MethodHandle constructor = typeConstructors.get(type);
        if (CoreConfiguration.debugLoadingInfo) {
            Debug.log("Adding script " + scriptName + " as type " + type);
        }
        try {
            String nameLow = CoreUtilities.toLowerCase(scriptName);
            if (scriptContainers.containsKey(nameLow)) {
                Debug.echoError("Duplicate script name '<Y>" + scriptName + "<W>'");
            }
            ScriptContainer instance = constructor.invoke(script, scriptName);
            scriptContainers.put(nameLow, instance);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            ScriptHelper.setHadError();
        }
    }

    public static void buildCoreYamlScriptContainers(List<YamlConfiguration> yamlScripts) {
        scriptContainers.clear();
        OldEventManager.world_scripts.clear();
        OldEventManager.events.clear();
        DenizenCore.implementation.refreshScriptContainers();
        if (yamlScripts == null) {
            return;
        }
        Debug.log("Loading <A>" + yamlScripts.size() + "<W> script files...");
        for (YamlConfiguration script : yamlScripts) {
            for (StringHolder key : script.contents.keySet()) {
                YamlConfiguration container = script.getConfigurationSection(key.str);
                if (container == null) {
                    Debug.echoError("Invalid container '" + key.str + "' in file '" + ScriptHelper.getSource(key.low) + "' - missing contents?");
                    continue;
                }
                ScriptRegistry.attemptLoadSingle(container, key.str, false);
            }
        }
    }

    public static <T extends ScriptContainer> T getScriptContainerAs(String name, Class<T> type) {
        try {
            ScriptContainer container = scriptContainers.get(CoreUtilities.toLowerCase(name));
            if (container != null) {
                return (T)((ScriptContainer)type.cast(container));
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T extends ScriptContainer> T getScriptContainer(String name) {
        ScriptContainer container = scriptContainers.get(CoreUtilities.toLowerCase(name));
        if (container != null) {
            return (T)container;
        }
        return null;
    }
}

