/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.codegen;

import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.codegen.DenizenCodeGenException;
import com.denizenscript.shaded.org.objectweb.asm.ClassWriter;
import com.denizenscript.shaded.org.objectweb.asm.Label;
import com.denizenscript.shaded.org.objectweb.asm.MethodVisitor;
import com.denizenscript.shaded.org.objectweb.asm.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class MethodGenerator {
    public String className;
    public int access;
    public MethodVisitor mv;
    public Label startLabel;
    public Label curLabel;
    public int lineNumber = 0;
    public ArrayList<Local> locals = new ArrayList();
    public int nextLocalIndex = 0;
    public static Method METHOD_BOOLEAN_VALUEOF = ReflectionHelper.getMethod(Boolean.class, "valueOf", Boolean.TYPE);
    public static Method METHOD_INTEGER_VALUEOF = ReflectionHelper.getMethod(Integer.class, "valueOf", Integer.TYPE);
    public static Method METHOD_LONG_VALUEOF = ReflectionHelper.getMethod(Long.class, "valueOf", Long.TYPE);
    public static Method METHOD_FLOAT_VALUEOF = ReflectionHelper.getMethod(Float.class, "valueOf", Float.TYPE);
    public static Method METHOD_DOUBLE_VALUEOF = ReflectionHelper.getMethod(Double.class, "valueOf", Double.TYPE);
    public static Method METHOD_CHARACTER_VALUEOF = ReflectionHelper.getMethod(Character.class, "valueOf", Character.TYPE);
    public static Method METHOD_BYTE_VALUEOF = ReflectionHelper.getMethod(Byte.class, "valueOf", Byte.TYPE);
    public static Method METHOD_SHORT_VALUEOF = ReflectionHelper.getMethod(Short.class, "valueOf", Short.TYPE);

    public static void genDefaultConstructor(ClassWriter cw, String className) {
        MethodGenerator gen = MethodGenerator.generateMethod(className, cw, 1, "<init>", "()V");
        gen.loadThis();
        gen.invokeSpecial("java/lang/Object", "<init>", "()V");
        gen.returnNone();
        gen.end();
    }

    public static MethodGenerator generateMethod(String className, ClassWriter cw, int access, String name, String descriptor) {
        MethodGenerator gen = new MethodGenerator(cw.visitMethod(access, name, descriptor, null, null), className, access);
        gen.start();
        return gen;
    }

    public MethodGenerator(MethodVisitor mv, String className, int access) {
        this.mv = mv;
        this.className = className;
        this.access = access;
    }

    public void start() {
        this.mv.visitCode();
        this.startLabel = new Label();
        this.advanceAndLabel(this.startLabel);
        if ((this.access & 8) == 0) {
            this.addLocal("this", "L" + this.className + ";");
        }
    }

    public void end() {
        for (Local local : this.locals) {
            this.finalizeLocalVar(local.name, local.descriptor, local.index);
        }
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    public void moveToLabel(Label label) {
        this.mv.visitLabel(label);
        this.curLabel = label;
    }

    public void advanceLineNumber() {
        this.mv.visitLineNumber(++this.lineNumber, this.curLabel);
    }

    public void advanceAndLabel(Label label) {
        this.moveToLabel(label);
        this.advanceLineNumber();
    }

    public void advanceAndLabel() {
        this.advanceAndLabel(new Label());
    }

    public void jumpTo(Label label) {
        this.mv.visitJumpInsn(167, label);
    }

    public void jumpIfFalseTo(Label target) {
        this.mv.visitJumpInsn(153, target);
    }

    public void jumpIfTrueTo(Label target) {
        this.mv.visitJumpInsn(154, target);
    }

    public void jumpIfNullTo(Label target) {
        this.mv.visitJumpInsn(198, target);
    }

    public void jumpIfNotNullTo(Label target) {
        this.mv.visitJumpInsn(199, target);
    }

    public void cast(Class<?> type) {
        this.mv.visitTypeInsn(192, Type.getInternalName(type));
    }

    public static Method getAutoBoxMethodFor(char c) {
        switch (c) {
            case 'I': {
                return METHOD_INTEGER_VALUEOF;
            }
            case 'Z': {
                return METHOD_BOOLEAN_VALUEOF;
            }
            case 'B': {
                return METHOD_BYTE_VALUEOF;
            }
            case 'C': {
                return METHOD_CHARACTER_VALUEOF;
            }
            case 'S': {
                return METHOD_SHORT_VALUEOF;
            }
            case 'D': {
                return METHOD_DOUBLE_VALUEOF;
            }
            case 'F': {
                return METHOD_FLOAT_VALUEOF;
            }
            case 'J': {
                return METHOD_LONG_VALUEOF;
            }
        }
        return null;
    }

    public void autoBox(Class<?> type) {
        this.autoBox(Type.getDescriptor(type));
    }

    public void autoBox(String typeDescriptor) {
        Method method = MethodGenerator.getAutoBoxMethodFor(typeDescriptor.charAt(0));
        if (method != null) {
            this.invokeStatic(method);
        }
    }

    public void loadInstanceField(Field f) {
        this.loadInstanceField(Type.getInternalName(f.getDeclaringClass()), f.getName(), Type.getDescriptor(f.getType()));
    }

    public void loadInstanceField(String className, String field, String descriptor) {
        this.mv.visitFieldInsn(180, className, field, descriptor);
    }

    public void loadStaticField(Field f) {
        this.loadStaticField(Type.getInternalName(f.getDeclaringClass()), f.getName(), Type.getDescriptor(f.getType()));
    }

    public void loadStaticField(String className, String field, Class<?> type) {
        this.loadStaticField(className, field, Type.getDescriptor(type));
    }

    public void loadStaticField(String className, String field, String descriptor) {
        this.mv.visitFieldInsn(178, className, field, descriptor);
    }

    public void finalizeLocalVar(String name, String descriptor, int index) {
        this.mv.visitLocalVariable(name, descriptor, null, this.startLabel, this.curLabel, index);
    }

    public void invokeSpecial(Constructor<?> ctor) {
        this.invokeSpecial(Type.getInternalName(ctor.getDeclaringClass()), "<init>", Type.getConstructorDescriptor(ctor));
    }

    public void invokeSpecial(Method method) {
        this.invokeSpecial(Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor(method));
    }

    public void invokeSpecial(String type, String methodName, String descriptor) {
        this.mv.visitMethodInsn(183, type, methodName, descriptor, false);
    }

    public void invokeVirtual(Method method) {
        this.invokeVirtual(Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor(method));
    }

    public void invokeVirtual(String type, String methodName, String descriptor) {
        this.mv.visitMethodInsn(182, type, methodName, descriptor, false);
    }

    public void invokeStatic(Method method) {
        this.invokeStatic(Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor(method));
    }

    public void invokeStatic(String type, String methodName, String descriptor) {
        this.mv.visitMethodInsn(184, type, methodName, descriptor, false);
    }

    public void invokeInterface(Method method) {
        this.invokeInterface(Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor(method));
    }

    public void invokeInterface(String type, String methodName, String descriptor) {
        this.mv.visitMethodInsn(185, type, methodName, descriptor, true);
    }

    public void loadString(String text) {
        this.mv.visitLdcInsn(text);
    }

    public void loadInt(int intVal) {
        this.mv.visitIntInsn(17, intVal);
    }

    public void stackDuplicate() {
        this.mv.visitInsn(89);
    }

    public void createArray(Class<?> type) {
        this.mv.visitTypeInsn(189, Type.getInternalName(type));
    }

    public void arrayStore(Class<?> arrayType) {
        this.arrayStore(Type.getDescriptor(arrayType));
    }

    public void arrayStore(String arrayTypeDescriptor) {
        this.mv.visitInsn(MethodGenerator.getOpcodeTypeOffset(79, arrayTypeDescriptor));
    }

    public void loadThis() {
        this.mv.visitVarInsn(25, 0);
    }

    public void loadLocal(Local local) {
        this.mv.visitVarInsn(MethodGenerator.getOpcodeTypeOffset(21, local.descriptor), local.index);
    }

    public void storeLocal(Local local) {
        this.mv.visitVarInsn(MethodGenerator.getOpcodeTypeOffset(54, local.descriptor), local.index);
    }

    public void returnNone() {
        this.mv.visitInsn(177);
    }

    public void returnValue(Class<?> type) {
        this.returnValue(Type.getDescriptor(type));
    }

    public void returnValue(String valTypeDescriptor) {
        if (valTypeDescriptor.equals("V")) {
            this.returnNone();
        } else {
            this.mv.visitInsn(MethodGenerator.getOpcodeTypeOffset(172, valTypeDescriptor));
        }
    }

    public Local addLocal(String name, Class type) {
        return this.addLocal(name, Type.getDescriptor(type));
    }

    public Local addLocal(String name, String descriptor) {
        int index = this.nextLocalIndex++;
        char c = descriptor.charAt(0);
        if (c == 'D' || c == 'J') {
            ++this.nextLocalIndex;
        }
        return this.addLocal(name, descriptor, index);
    }

    public Local addLocal(String name, String descriptor, int index) {
        Local local = new Local();
        local.name = name;
        local.descriptor = descriptor;
        local.index = index;
        this.locals.add(local);
        return local;
    }

    public static int getOpcodeTypeOffset(int iOpcode, String typeDescriptor) {
        switch (typeDescriptor.charAt(0)) {
            case 'L': {
                return iOpcode + 4;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return iOpcode;
            }
            case 'F': {
                return iOpcode + 2;
            }
            case 'D': {
                return iOpcode + 3;
            }
            case 'J': {
                return iOpcode + 1;
            }
        }
        throw new DenizenCodeGenException("Invalid type '" + typeDescriptor + "' cannot be used.");
    }

    public static class Local {
        public String name;
        public int index;
        public String descriptor;
    }
}

