/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.shaded.redis.clients.jedis;

import com.denizenscript.shaded.redis.clients.jedis.BuilderFactory;
import com.denizenscript.shaded.redis.clients.jedis.DefaultJedisClientConfig;
import com.denizenscript.shaded.redis.clients.jedis.DefaultJedisSocketFactory;
import com.denizenscript.shaded.redis.clients.jedis.HostAndPort;
import com.denizenscript.shaded.redis.clients.jedis.JedisClientConfig;
import com.denizenscript.shaded.redis.clients.jedis.JedisSocketFactory;
import com.denizenscript.shaded.redis.clients.jedis.Protocol;
import com.denizenscript.shaded.redis.clients.jedis.commands.ProtocolCommand;
import com.denizenscript.shaded.redis.clients.jedis.exceptions.JedisConnectionException;
import com.denizenscript.shaded.redis.clients.jedis.exceptions.JedisDataException;
import com.denizenscript.shaded.redis.clients.jedis.util.IOUtils;
import com.denizenscript.shaded.redis.clients.jedis.util.RedisInputStream;
import com.denizenscript.shaded.redis.clients.jedis.util.RedisOutputStream;
import com.denizenscript.shaded.redis.clients.jedis.util.SafeEncoder;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;

public class Connection
implements Closeable {
    private static final byte[][] EMPTY_ARGS = new byte[0][];
    private boolean socketParamModified = false;
    private JedisSocketFactory socketFactory;
    private Socket socket;
    private RedisOutputStream outputStream;
    private RedisInputStream inputStream;
    private int soTimeout = 2000;
    private int infiniteSoTimeout = 0;
    private boolean broken = false;

    public Connection() {
        this("localhost", 6379);
    }

    @Deprecated
    public Connection(String host) {
        this(host, 6379);
    }

    public Connection(String host, int port) {
        this(new HostAndPort(host, port), DefaultJedisClientConfig.builder().build());
    }

    @Deprecated
    public Connection(String host, int port, boolean ssl) {
        this(new HostAndPort(host, port), DefaultJedisClientConfig.builder().ssl(ssl).build());
    }

    @Deprecated
    public Connection(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new HostAndPort(host, port), DefaultJedisClientConfig.builder().ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Connection(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new DefaultJedisSocketFactory(hostAndPort, clientConfig));
        this.soTimeout = clientConfig.getSocketTimeoutMillis();
        this.infiniteSoTimeout = clientConfig.getBlockingSocketTimeoutMillis();
    }

    public Connection(JedisSocketFactory jedisSocketFactory) {
        this.socketFactory = jedisSocketFactory;
        this.soTimeout = jedisSocketFactory.getSoTimeout();
    }

    public String toString() {
        return "Connection{" + this.socketFactory + "}";
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getConnectionTimeout() {
        return this.socketFactory.getConnectionTimeout();
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Deprecated
    public void setConnectionTimeout(int connectionTimeout) {
        this.socketFactory.setConnectionTimeout(connectionTimeout);
    }

    public void setSoTimeout(int soTimeout) {
        this.socketFactory.setSoTimeout(soTimeout);
        this.soTimeout = soTimeout;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(soTimeout);
            }
            catch (SocketException ex) {
                this.broken = true;
                throw new JedisConnectionException(ex);
            }
        }
    }

    public void setInfiniteSoTimeout(int infiniteSoTimeout) {
        this.infiniteSoTimeout = infiniteSoTimeout;
    }

    public void setTimeoutInfinite() {
        try {
            if (!this.isConnected()) {
                this.connect();
            }
            this.socket.setSoTimeout(this.infiniteSoTimeout);
        }
        catch (SocketException ex) {
            this.broken = true;
            throw new JedisConnectionException(ex);
        }
    }

    public void rollbackTimeout() {
        try {
            this.socket.setSoTimeout(this.socketFactory.getSoTimeout());
        }
        catch (SocketException ex) {
            this.broken = true;
            throw new JedisConnectionException(ex);
        }
    }

    public void sendCommand(ProtocolCommand cmd, String ... args) {
        byte[][] bargs = new byte[args.length][];
        for (int i = 0; i < args.length; ++i) {
            bargs[i] = SafeEncoder.encode(args[i]);
        }
        this.sendCommand(cmd, bargs);
    }

    public void sendCommand(ProtocolCommand cmd) {
        this.sendCommand(cmd, EMPTY_ARGS);
    }

    public void sendCommand(ProtocolCommand cmd, byte[] ... args) {
        try {
            this.connect();
            Protocol.sendCommand(this.outputStream, cmd, args);
        }
        catch (JedisConnectionException ex) {
            try {
                String errorMessage = Protocol.readErrorLineIfPossible(this.inputStream);
                if (errorMessage != null && errorMessage.length() > 0) {
                    ex = new JedisConnectionException(errorMessage, ex.getCause());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.broken = true;
            throw ex;
        }
    }

    public String getHost() {
        return this.socketFactory.getHost();
    }

    @Deprecated
    public void setHost(String host) {
        this.socketFactory.setHost(host);
        this.socketParamModified = true;
    }

    public int getPort() {
        return this.socketFactory.getPort();
    }

    @Deprecated
    public void setPort(int port) {
        this.socketFactory.setPort(port);
        this.socketParamModified = true;
    }

    public void connect() throws JedisConnectionException {
        if (this.socketParamModified) {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.isConnected()) {
            try {
                this.socket = this.socketFactory.createSocket();
                this.outputStream = new RedisOutputStream(this.socket.getOutputStream());
                this.inputStream = new RedisInputStream(this.socket.getInputStream());
            }
            catch (IOException ioe) {
                this.broken = true;
                throw new JedisConnectionException("Failed to create input/output stream", ioe);
            }
            catch (JedisConnectionException jce) {
                this.broken = true;
                throw jce;
            }
            finally {
                if (this.broken) {
                    IOUtils.closeQuietly(this.socket);
                }
            }
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.outputStream.flush();
                this.socket.close();
            }
            catch (IOException ex) {
                this.broken = true;
                throw new JedisConnectionException(ex);
            }
            finally {
                IOUtils.closeQuietly(this.socket);
            }
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isBound() && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    public String getStatusCodeReply() {
        this.flush();
        byte[] resp = (byte[])this.readProtocolWithCheckingBroken();
        if (null == resp) {
            return null;
        }
        return SafeEncoder.encode(resp);
    }

    public String getBulkReply() {
        byte[] result = this.getBinaryBulkReply();
        if (null != result) {
            return SafeEncoder.encode(result);
        }
        return null;
    }

    public byte[] getBinaryBulkReply() {
        this.flush();
        return (byte[])this.readProtocolWithCheckingBroken();
    }

    public Long getIntegerReply() {
        this.flush();
        return (Long)this.readProtocolWithCheckingBroken();
    }

    public List<String> getMultiBulkReply() {
        return BuilderFactory.STRING_LIST.build(this.getBinaryMultiBulkReply());
    }

    public List<byte[]> getBinaryMultiBulkReply() {
        this.flush();
        return (List)this.readProtocolWithCheckingBroken();
    }

    @Deprecated
    public List<Object> getRawObjectMultiBulkReply() {
        return this.getUnflushedObjectMultiBulkReply();
    }

    public List<Object> getUnflushedObjectMultiBulkReply() {
        return (List)this.readProtocolWithCheckingBroken();
    }

    public List<Object> getObjectMultiBulkReply() {
        this.flush();
        return this.getUnflushedObjectMultiBulkReply();
    }

    public List<Long> getIntegerMultiBulkReply() {
        this.flush();
        return (List)this.readProtocolWithCheckingBroken();
    }

    public Object getOne() {
        this.flush();
        return this.readProtocolWithCheckingBroken();
    }

    public boolean isBroken() {
        return this.broken;
    }

    protected void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException ex) {
            this.broken = true;
            throw new JedisConnectionException(ex);
        }
    }

    protected Object readProtocolWithCheckingBroken() {
        if (this.broken) {
            throw new JedisConnectionException("Attempting to read from a broken connection");
        }
        try {
            return Protocol.read(this.inputStream);
        }
        catch (JedisConnectionException exc) {
            this.broken = true;
            throw exc;
        }
    }

    public List<Object> getMany(int count) {
        this.flush();
        ArrayList<Object> responses = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            try {
                responses.add(this.readProtocolWithCheckingBroken());
                continue;
            }
            catch (JedisDataException e) {
                responses.add(e);
            }
        }
        return responses;
    }
}

