/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.shaded.redis.clients.jedis.params;

import com.denizenscript.shaded.redis.clients.jedis.Protocol;
import com.denizenscript.shaded.redis.clients.jedis.params.Params;
import com.denizenscript.shaded.redis.clients.jedis.util.SafeEncoder;
import java.util.ArrayList;
import java.util.Collections;

public class GeoRadiusParam
extends Params {
    private static final String WITHCOORD = "withcoord";
    private static final String WITHDIST = "withdist";
    private static final String WITHHASH = "withhash";
    private static final String ASC = "asc";
    private static final String DESC = "desc";
    private static final String COUNT = "count";

    public static GeoRadiusParam geoRadiusParam() {
        return new GeoRadiusParam();
    }

    public GeoRadiusParam withCoord() {
        this.addParam(WITHCOORD);
        return this;
    }

    public GeoRadiusParam withDist() {
        this.addParam(WITHDIST);
        return this;
    }

    public GeoRadiusParam withHash() {
        this.addParam(WITHHASH);
        return this;
    }

    public GeoRadiusParam sortAscending() {
        this.addParam(ASC);
        return this;
    }

    public GeoRadiusParam sortDescending() {
        this.addParam(DESC);
        return this;
    }

    public GeoRadiusParam count(int count) {
        if (count > 0) {
            this.addParam(COUNT, count);
        }
        return this;
    }

    public byte[][] getByteParams(byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        Collections.addAll(byteParams, args);
        if (this.contains(WITHCOORD)) {
            byteParams.add(SafeEncoder.encode(WITHCOORD));
        }
        if (this.contains(WITHDIST)) {
            byteParams.add(SafeEncoder.encode(WITHDIST));
        }
        if (this.contains(WITHHASH)) {
            byteParams.add(SafeEncoder.encode(WITHHASH));
        }
        if (this.contains(COUNT)) {
            byteParams.add(SafeEncoder.encode(COUNT));
            byteParams.add(Protocol.toByteArray((Integer)this.getParam(COUNT)));
        }
        if (this.contains(ASC)) {
            byteParams.add(SafeEncoder.encode(ASC));
        } else if (this.contains(DESC)) {
            byteParams.add(SafeEncoder.encode(DESC));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

